/***************************************************************************
    file	         : kb_qryquerydlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qframe.h>
#include	<qmessagebox.h>

#include	"kb_node.h"

#include	"kb_attr.h"
#include	"kb_dbinfo.h"
#include	"kb_dbdociter.h"
#include	"kb_propdlg.h"
#include	"kb_query.h"
#include	"kb_qryquery.h"
#include	"kb_table.h"
#include	"kb_qryexpr.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_docroot.h"

#ifndef 	_WIN32
#include 	"kb_qryquerydlg.moc"
#else
#include 	"kb_qryquerydlg.h"
#endif

class LIBKBASE_API KBQryAttrItem : public KBAttrItem
{
	KBQryQueryPropDlg	*qDlg	;

public	:

	inline	KBQryAttrItem
		(	KBAttr			*attr,
			KBQryQueryPropDlg	*qDlg
		)
		:
		KBAttrItem	(attr),
		qDlg		(qDlg)
	{
	}

	virtual	QString	displayValue	() ;
}	;

QString	KBQryAttrItem::displayValue ()
{
	return	qDlg->nameForIdent (m_value) ;
}


/*  KBQryQueryPropDlg							*/
/*  KBQryQueryPropDlg							*/
/*		: Constructor for query-query properties dialog		*/
/*  link	: KBLink *	 : Parent link				*/ 
/*  caption	: const char *   : Dialog box caption			*/
/*  attribs	: QList<KBAttr>& : List of attributes			*/
/*  (returns)	: KBQryQueryPropDlg :					*/

KBQryQueryPropDlg::KBQryQueryPropDlg
	(	KBQryQuery	*query,
		cchar		*caption,
		QList<KBAttr>	&attribs
	)
	:
	KBPropDlg	(query, caption, attribs),
	query		(query),
	topTableWidget	(&topWidget),
	topTableCombo	(&topTableWidget)
{
	idmap.setAutoDelete (true) ;
	topTableWidget.hide () ;

	connect	(&topTableWidget, SIGNAL(resized       (KBResizeWidget *, QSize)),
		 this,		  SLOT  (topTableResize(KBResizeWidget *, QSize))) ;
	connect	(&topTableCombo,  SIGNAL(activated     (int)),
		 this,	    	  SLOT  (showBlockUp   (int))) ;

	qryRoot	= 0 ;

	if (!query->getQryName().isEmpty())
	{
		KBError	error	;
		if (!loadQueryList (query->getQryName(), query->getTopTable(), error))
			error.DISPLAY() ;
	}
}

/*  KBQryQueryPropDlg							*/
/*  ~KBQryQueryPropDlg							*/
/*		: Destructor for block properties dialog		*/
/*  (returns)	: void		:					*/

KBQryQueryPropDlg::~KBQryQueryPropDlg ()
{
	if (blockUp.count() > 0) delete blockUp.at(0) ;
	DELOBJ	(qryRoot) ;
}

/*  KBQryQueryPropDlg							*/
/*  getAttrItem	: Get attribute item for attribute			*/
/*  attr	: KBAttr *	: Attribute				*/
/*  (returns)	: KBAttrItem *	: Associated attribute item		*/

KBAttrItem *KBQryQueryPropDlg::getAttrItem
	(	KBAttr	*attr
	)
{
	if (attr->getName() == "toptable")
		return	new KBQryAttrItem (attr, this) ;

	return	KBPropDlg::getAttrItem (attr) ;
}

/*  KBQryQueryPropDlg							*/
/*  nameForIdent: Get name to display for table identifier		*/
/*  ident	: const QString & : Table identifier			*/
/*  (returns)	: QString	  : Display name			*/

QString	KBQryQueryPropDlg::nameForIdent
	(	const QString	&ident
	)
{
	LITER
	(	KBTable,
		qryList,
		table,

		if (table->getIdent() == ident)
		{
			if (table->getAlias().isEmpty())
				return	table->getTable() ;

			return	QString	("%1 as %2")
					.arg(table->getTable())
					.arg(table->getAlias()) ;
		}
	)

	return	ident	;
}

/*  KBQryQueryPropDlg							*/
/*  loadQueryList: Load table list for query				*/
/*  qryName	 : const QString & : Query name				*/
/*  topTable	 : const QString & : Top table identifier		*/
/*  error	 : KBError &	   : Error return			*/
/*  (returns)	 : bool		   : Success				*/

bool	KBQryQueryPropDlg::loadQueryList
	(	const QString	&qryName,
		const QString	&topTable,
		KBError		&error
	)
{
	KBLocation location
	(	query->getDocRoot()->getDBInfo  (),
		"query",
		query->getDocRoot()->getLocation().docLocn,
		qryName
	) ;

	DELOBJ	(qryRoot);
	qryList.clear  ();

	/* Read in the query definition, and parse it. If either fails	*/
	/* then return an error.					*/
	QByteArray doc ;

	if (!location.contents (doc, error))
		return false	;
	if ((qryRoot = KBOpenQueryText (location, doc, error)) == 0)
		return false ;

	QList<KBQryExpr>exprList;
	QString		svrName	;
	int		at = -1 ;

	topTableCombo.clear ()	;
	idmap	     .clear ()	;

	qryRoot->getQueryInfo (svrName, qryList, exprList) ;
	for (uint idx = 0 ; idx < qryList.count() ; idx += 1)
	{
		KBTable	*table	= qryList.at(idx)   ;
		QString	text	= table->getTable() ;

		if (!table->getAlias().isEmpty())
			text	= QString("%1 as %2")
					 .arg(text)
					 .arg(table->getAlias()) ;

		topTableCombo.insertItem (text) ;
		idmap	     .append	 (new QString(table->getIdent())) ;

		if (table->getIdent() == topTable) at = idx ;
	}

	if (at >= 0) topTableCombo.setCurrentItem (at) ;

	showBlockUp	(at >= 0 ? at : 0) ;

	return	true	;
}

/*  KBQryQueryPropDlg							*/
/*  showProperty: Show property						*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Property on show			*/

bool	KBQryQueryPropDlg::showProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Query							*/
	/* This should display a list of all available KBase-level	*/
	/* queries.							*/
	if (aName == "query")
	{
		KBDocRoot	*docRoot  = query  ->getDocRoot() ;
		KBDBInfo	*dbInfo   = docRoot->getDBInfo () ;
		int		at	  = -1  ;
		KBDBDocIter	docIter	  ;
		QString		name	  ;
		QString		stamp	  ;
		KBError		error	  ;

		comboBox.clear () ;

		if (!docIter.init
			(	dbInfo,
				docRoot->getLocation().docLocn,
				"query",
				QString("%1.qry").arg(dbInfo->getDBExtn()),
				error
			))
		{
			error.DISPLAY() ;
			return	false	;
		}

		while (docIter.getNextDoc (name, stamp))
		{	comboBox.insertItem (name) ;
			if (name == item->value())
				at = comboBox.count() - 1 ;
		}

		if (at >= 0) comboBox.setCurrentItem (at) ;
		comboBox.show  () ;
		return	true	  ;
	}

	/* TopTable							*/
	/* This should display a list of the tables in the query.	*/
	if (aName == "toptable")
	{
		topTableCombo.show () ;
		setUserWidget	   (&topTableWidget ) ;
		return	true	   ;
	}

	return	KBPropDlg::showProperty (item) ;
}

/*  KBPropDlg								*/
/*  saveProperty: Check and save attribute				*/
/*  item	: KBAttrItem *	: Associated item			*/
/*  (returns)	: bool		: Attribute OK				*/

bool	KBQryQueryPropDlg::saveProperty
	(	KBAttrItem	*item
	)
{
	const QString	&aName = item->attr()->getName () ;

	/* Query							*/
	/* We need to verify that the query exists (well, someone may	*/
	/* have deleted it) and, more importantly, this it is valid.	*/
	if (aName == "query")
	{
		QString	qryName	= comboBox.currentText()   ;
		bool	delta	= qryName != item->value() ;

		setProperty (aName,      qryName) ;
		setProperty ("toptable", ""	) ;

		KBError	error	;
		if (!loadQueryList (qryName, QString::null, error))
			error.DISPLAY() ;

		if (delta && !item->value().isEmpty())
			KBError::EWarning
			(	TR("Changing the query will probably invalidate the form or report structure"),
				QString::null,
				__ERRLOCN
			)	;

		return	true  ;
	}

	/* TopTable							*/
	/* This retrieves a value via the combobox.			*/
	if (aName == "toptable")
	{
		QString	ident	= *idmap.at (topTableCombo.currentItem()) ;
		bool	delta	= ident != item->value() ;

		setProperty (aName, ident) ;

		if (delta && !item->value().isEmpty())
			KBError::EWarning
			(	TR("Changing the top-level table will probably invalidate the form or report structure"),
				QString::null,
				__ERRLOCN
			)	;

		return	true ;
	}

	return	KBPropDlg::saveProperty (item) ;
}

/*  KBPropDlg								*/
/*  showBlockUp	: Set blocking for specified top-level tape		*/
/*  index	: int		: Index into top-level combobox		*/
/*  (returns)	: void		:					*/

void	KBQryQueryPropDlg::showBlockUp
	(	int	index
	)
{
	if (blockUp.count()  > 0) delete blockUp.at(0) ;
	blockUp.clear () ;
	if (qryList.count() == 0) return ;

	QList<KBTable>	blkList ;
	KBError		error	;
	if (!KBTable::blockUp (qryList, *idmap.at(index), blkList, error))
	{	error.DISPLAY()	;
		return	;
	}

	QWidget	*parent	= &topTableWidget ;

	LITER
	(	KBTable,
		blkList,
		table,

		QLabel	*label	= new QLabel (parent) ;

		label->setText	     (table->getTableText ()) ;
		label->setAlignment  (Qt::AlignLeft|Qt::AlignTop) ;
		label->setFrameStyle (QFrame::WinPanel|QFrame::Sunken) ;
		label->setLineWidth  (2) ;

		blockUp.append	     (label) ;
		parent	= label	;
	)

	setBlockSizes	   () ;
	blockUp.at(0)->show() ;
}

void	KBQryQueryPropDlg::topTableResize
	(	KBResizeWidget	*,
		QSize		size
	)
{
	topTableCombo.move   (0, 0) ;
	topTableCombo.resize (size.width(), topTableCombo.sizeHint().height()) ;
	setBlockSizes	     () ;
}

/*  KBPropDlg								*/
/*  setBlockSizes: Set sizes in blockup diagram				*/
/*  (returns)	 : void		:					*/

void	KBQryQueryPropDlg::setBlockSizes ()
{
	if (blockUp.count() == 0) return ;

	int	x	= 0 ;
	int	y	= topTableCombo .sizeHint().height() * 3 / 2 ;
	int	w	= topTableWidget.width   () ;
	int	h	= topTableWidget.height  () - y ;

	LITER
	(	QLabel,
		blockUp,
		label,

		label->setGeometry (x, y, w, h) ;

		x  = 16 ;
		w  = topTableWidget.width () - 32 ;

		h -= y + 16 ;
	)	
}



/*  KBQryQueryProdDlg							*/
/*  playerPerform							*/
/*		: Perform a stanza from a score				*/
/*  action	: const QString		: Action			*/
/*  args	: const QStringList &	: Arguemnts			*/
/*  pError	: KBError &		: Error return			*/
/*  (returns)	; bool			: Success			*/

bool	KBQryQueryPropDlg::playerPerform
	(	const QString		&action,
		const QStringList	&args,
		KBError			&pError
	)
{
	if (!KBPropDlg::playerPerform (action, args, pError))
		return	false	;

	if ((action == "set") && (args[0] == "query"))
		return	loadQueryList (args[1], QString::null, pError) ;

	return	true	;
}

/*  qryQueryPropDlg							*/
/*		: Run the link properties dialog			*/
/*  query	: KBQryQuery *	: Parent link				*/ 
/*  caption	: cchar * 	: Dialog box caption			*/
/*  attribs	: QList<KBAttr>&: List of attributes			*/
/*  (returns)	: bool		: Success				*/

bool LIBKBASE_API qryQueryPropDlg
	(	KBQryQuery	*query,
		cchar		*caption,
		QList<KBAttr>	&attribs
	)
{
	KBQryQueryPropDlg qDlg (query, caption, attribs) ;
	return	qDlg.exec () ;
}
