/***************************************************************************
    file	         : kb_qtgrid.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qlabel.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#ifndef 	_WIN32
#include 	"kb_grid.moc"
#else
#include 	"kb_grid.h"
#endif

#include	"kb_block.h"
#include	"kb_display.h"
#include	"kb_writer.h"
#include	"kb_qtgrid.h"



/*  KBCtrlGrid								*/
/*  KBCtrlGrid	: Constructor for grid header wrapper			*/
/*  display	: KBDisplay *	: Parent display			*/
/*  grid	: KBGrid 	: Parent grid header			*/
/*  (returns)	: KBCtrlGrid	:					*/

KBCtrlGrid::KBCtrlGrid
	(	KBDisplay	*display,
		KBGrid		*grid
	)
	:
	QHeader	  (display->getDisplayWidget()),
	KBControl (this, display, grid),
	grid	  (grid)
{
	QHeader::connect
	(	(QHeader *)this, SIGNAL (sizeChange (int,int,int)),
		grid,		 SLOT   (sizeChange (int,int,int))
	)	;
	QHeader::connect
	(	(QHeader *)this, SIGNAL (indexChange(int,int,int)),
		grid,		 SLOT   (indexChange(int,int,int))
	)	;
	QHeader::connect
	(	(QHeader *)this, SIGNAL (clicked      (int)),
		grid,		 SLOT   (columnClicked(int))
	)	;

	setTracking     (false) ;
	setClickEnabled (true ) ;
}

/*  KBCtrlGrid								*/
/*  ~KBCtrlGrid: Destructor for grid header widget			*/
/*  (returns)	 :		:					*/

KBCtrlGrid::~KBCtrlGrid ()
{
}

/*  KBCtrlGrid								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlGrid::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

	QRect	g = grid->geometry ()	;

#if	! __KB_RUNTIME
	if (mode == KB::ShowAsDesign)
		resize	(g.width(), g.height()) ;
	else
#endif
		resize	(4096, 	    g.height()) ;
}

/*  KBCtrlGrid								*/
/*  clearLabels	: Clear all labels and sections				*/
/*  (returns)	: void		:					*/

void	KBCtrlGrid::clearLabels ()
{
	while (count() > 0) removeLabel (0) ;
}

/*  KBCtrlGrid								*/
/*  appendLabel	: Append a label and section				*/
/*  label	: const QString & : Label text				*/
/*  width	: int		  : Section width			*/
/*  dynamic	: bool		  : Section is dynamic			*/
/*  (returns)	: void		  :					*/

void	KBCtrlGrid::appendLabel
	(	const QString	&label,
		int		width,
		bool		dynamic
	)
{
	int	section	= addLabel (label, width) ;
	setResizeEnabled (dynamic, section) ;
}

/*  KBCtrlGrid								*/
/*  write	: Write grid header 					*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlGrid::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		extra	= 0	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}
