/***************************************************************************
    file	         : kb_querychooser.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_QUERYCHOOSER_H
#define	__KB_QUERYCHOOSER_H

#include	<qlayout.h>
#include	<qlabel.h>
#include	<qcombobox.h>
#include	<qpushbutton.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_dialog.h"

#include	"kb_dblink.h"
#include	"kb_dbinfo.h"

#include	"libkbase_exports.h"

/*  KBQueryChooser							*/
/*  --------------							*/
/*  This is a simple helper class which controls a pair of combo boxes	*/
/*  which allow server and query selection. Emits a "changed()" signal	*/
/*  each time something changes.					*/
/*  NOTE: This class does not handle GUI layout, the constructor is	*/
/*	  passed the server and table combo boxes.			*/

class	LIBKBASE_API	KBQueryChooser : public QObject
{
	Q_OBJECT

	KBLocation	&location	;
	QComboBox	&cbServer	;
	QComboBox	&cbQuery	;

signals	:

	void		serverChanged	()	;
	void		queryChanged	()	;

protected slots :

	void		serverSelected	(const QString &) ;
	void		querySelected	(const QString &) ;

public	:

	KBQueryChooser	(KBLocation &, QComboBox &, QComboBox &) ;

	bool		setServer	(const QString &) ;
	bool		setQuery	(const QString &) ;
}	;


/*  KBQueryChooserDlg							*/
/*  -----------------							*/
/*  This class provies a simple server/query selection dialog, based on	*/
/*  the query chooser class above.					*/

class	LIBKBASE_API	KBQueryChooserDlg : public _KBDialog
{
	Q_OBJECT

	KBLocation	location	;
	QComboBox	cbServer	;
	QComboBox	cbQuery		;
	QLabel		lServer		;
	QLabel		lQuery		;
	KBQueryChooser	chooser		;
	QPushButton	bOK		;
	QPushButton	bCancel		;
	QGridLayout	*layMain	;

protected slots :

	void		changed	    ()	;
	void		clickOK	    ()	;
	void		clickCancel ()	;

public	:

	KBQueryChooserDlg (KBLocation &);

	inline	QString	getServer   () { return cbServer.currentText() ; }
	inline	QString	getQuery    () { return cbQuery .currentText() ; }
}	;

#endif	// __KB_QUERYCHOOSER_H
