/***************************************************************************
    file	         : kb_reportblock.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_REPORTBLOCK_H
#define	_KB_REPORTBLOCK_H

#include	"kb_block.h"

#include	"libkbase_exports.h"

class LIBKBASE_API	KBYObject
{
public	:

	KBObject	*object	;
	uint		needs	;
	uint		y	;

	KBYObject	(KBObject *) ;
}	;

class	KBYSort : public QList<KBYObject>
{
protected :

	int	compareItems (QCollection::Item, QCollection::Item) ;
}	;

/*  KBReportBlock							*/
/*  ------------							*/
/*  This class implements the block object when embedded in a report.	*/

class LIBKBASE_API	KBReportBlock : public KBBlock
{
	Q_OBJECT

	KBAttrInt		pThrow	;
	KBYSort			ySort	;

	void			ySortObjects	()	;
	virtual	KBPopupMenu	*makeNewPopup	(bool, QRect) ;

protected :

	void			addFramers	()	;
	void			startPage	()	;
	void			finishPage	(bool)	;

public	:

	KBReportBlock (KBNode   *, const QDict<QString> &, cchar * = "KBReportBlock", bool * = 0) ;
	KBReportBlock (KBObject *, const QRect &, BlkType, bool  &, cchar * = "KBReportBlock") ;
	KBReportBlock (KBNode   *, KBReportBlock *) ;
virtual~KBReportBlock () ;

	virtual	KBNode		*replicate	(KBNode *) ;

	virtual	KBReportBlock	*isReportBlock	() { return this ; }

	virtual	void		move		(int, int)  ;
	virtual	bool		resize		(int, int)  ;
	bool			showData	() ;
	virtual	KBValue		getValue	(uint) ;
	virtual	bool		setValue	(uint, const KBValue &) ;
	virtual	KBValue		*getBlockVal	() ;
	virtual	uint		rowsInBlock	() ;

public	slots :

	virtual void		docPropDlg	() ;
	virtual KBNode		*newNode	(int) ;

	void			newTableBlock	() ;
	void			newSQLBlock	() ;
	void			newQueryBlock	() ;
	void			addHeader	() ;
	void			addFooter	() ;
}	;

#endif	// _KB_REPORTBLOCK_H
