/***************************************************************************
    file	         : kb_tabpagedlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef		_WIN32
#include	"kb_tabpagedlg.moc"
#else
#include	"kb_tabpagedlg.h"
#endif


KBTabPageDlg::KBTabPageDlg
	(	QList<KBTabberPage>	&pageList
	)
	:
	_KBDialog	("Set page order", true),
	m_bMoveUp	(this),
	m_bMoveDown	(this),
	m_bOK		(this),
	m_bCancel	(this),
	m_pageListBox	(this, &m_bMoveUp, &m_bMoveDown),
	m_pageList	(pageList)
{
	m_layMain	= new QHBoxLayout (this);
	m_layMain->addWidget (&m_pageListBox)	;

	m_layButt	= new QGridLayout (m_layMain) ;
	m_layButt->addWidget (&m_bMoveUp,   0, 0) ;
	m_layButt->addWidget (&m_bMoveDown, 0, 1) ;
	m_layButt->addWidget (&m_bOK,	    2, 0) ;
	m_layButt->addWidget (&m_bCancel,   2, 1) ;

	m_layButt->setRowStretch (1, 1) ;

	m_bMoveUp  .setText  (TR("Move Up"  )) ;
	m_bMoveDown.setText  (TR("Move Down")) ;
	m_bOK	   .setText  (TR("OK"       )) ;
	m_bCancel  .setText  (TR("Cancel"   )) ;

	for (KBTabberPage *page  = m_pageList.first() ;
			   page != 0 ;
			   page  = m_pageList.next ())
		new KBPageListBoxItem (&m_pageListBox, page) ;

	connect	(&m_bOK	,    SIGNAL(clicked()), SLOT(clickOK    ())) ;
	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;

	m_pageListBox.setMinimumHeight (150) ;
}

void	KBTabPageDlg::clickOK ()
{
	m_pageList.clear () ;

	for (uint idx = 0 ; idx < m_pageListBox.count() ; idx += 1)
		m_pageList.append (((KBPageListBoxItem *)m_pageListBox.item(idx))->getPage()) ;

	done	(1) ;
}

void	KBTabPageDlg::clickCancel ()
{
	done	(0) ;
}

/*  KBTabPageDlg							*/
/*  clickMoveUp	 : Handle click of the move-up button			*/
/*  (returns)	 : void		:					*/

void	KBTabPageDlg::clickMoveUp ()
{
	int		idx	;
	QListBoxItem	*cur	;

	if ((idx = m_pageListBox.currentItem()) <= 0) return ;
	if ((cur = m_pageListBox.item    (idx)) == 0) return ;

	m_pageListBox.takeItem       (cur) ;
	m_pageListBox.insertItem     (cur, idx - 1) ;
	m_pageListBox.setCurrentItem (cur) ;
}

/*  KBTabPageDlg							*/
/*  clickMoveDown: Handle click of the move-down button			*/
/*  (returns)	 : void		:					*/

void	KBTabPageDlg::clickMoveDown ()
{
	int		idx	;
	QListBoxItem	*cur	;

	if ((idx = m_pageListBox.currentItem())  < 0) return ;
	if ((cur = m_pageListBox.item    (idx)) == 0) return ;
	if (idx >= (int)m_pageListBox.count  ()  - 1) return ;

	m_pageListBox.takeItem       (cur) ;
	m_pageListBox.insertItem     (cur, idx + 1) ;
	m_pageListBox.setCurrentItem (cur) ;
}

