/***************************************************************************
    file	         : tk_print.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	"tk_print.h"


/*  Debugging routines. The two routines below can dump the KPrinter	*/
/*  options map and the corresponding DOM element attribute set to	*/
/*  standard error.							*/

#define		__DUMP	0


#if	! __DUMP

#define	dumpMap(w,m)
#define	dumpElem(e,m)

#else

/*  dumpMap	: Dump options map					*/
/*  where	: const char *	: Legend				*/
/*  map		: QMap ...	: Options map				*/
/*  (returns)	: void		:					*/

static	void	dumpMap
	(	const char			*where,
		const QMap<QString,QString>	&map
	)
{

	QMap<QString,QString>::ConstIterator iter ;

	fprintf	(stderr, "%s:\n", where) ;
	for (iter = map.begin() ; iter != map.end() ; ++iter)
		fprintf
		(	stderr,
			"%s: %s=%s\n",
			where,
			iter.key ().latin1(),
			iter.data().latin1()
		)	;
}

/*  dumpElem	: Dump element attributes				*/
/*  where	: const char *	: Legend				*/
/*  elem	: QDomElement &	: Element				*/
/*  (returns)	: void		:					*/

static	void	dumpElem
	(	const char			*where,
		const QDomElement		&elem
	)
{
	QDomNamedNodeMap	amap = elem.attributes() ;

	fprintf	(stderr, "%s:\n", where) ;
	for (uint idx = 0 ; idx < amap.length() ; idx += 1)
		fprintf
		(	stderr,
			"%s: %s=%s\n",
			where,
			amap.item(idx).nodeName ().latin1(),
			amap.item(idx).nodeValue().latin1()
		)	;
}
#endif

/*  ------------------------------------------------------------------  */


/*  TKPrinter								*/
/*  TKPrinter	: Constructor for printer wrapper class			*/
/*  resolution	: Resolution	: Print resolution			*/
/*  settings	: TKPrinterSettings *					*/
/*				: Initial settings or null		*/
/*  (returns)	: TKPrinter	:					*/

TKPrinter::TKPrinter
	(	Resolution		resolution,
		TKPrinterSettings	*settings
	)
	:
	KPrinter
	(	false,
		resolution == ResHigh    ? QPrinter::HighResolution    :
		resolution == ResPrinter ? QPrinter::PrinterResolution :
					   QPrinter::ScreenResolution
	)
{
	/* This seems to be neccessary to get selection to work. Assume	*/
	/* 1024 will be enough!						*/
	setMinMax (1, 1024) ;

	if (settings != 0)
	{
		fprintf
		(	stderr,
			"TKPrinter::TKPrinter: pn=[%s]\n",
			(const char *)settings->m_printerName
		)	;

		setColorMode	 (settings->m_colorMode     ) ;
		setNumCopies	 (settings->m_numCopies	    ) ;
		setOrientation	 (settings->m_orientation   ) ;
		setOutputFileName(settings->m_outputFileName) ;
		setOutputToFile	 (settings->m_outputToFile  ) ;
		setPageOrder	 (settings->m_pageOrder	    ) ;
		setPageSize	 (settings->m_pageSize	    ) ;
		setPrintProgram	 (settings->m_printProgram  ) ;
		setPrinterName	 (settings->m_printerName   ) ;
		setPrinterSelectionOption
				 (settings->m_printerSelectionOption) ;
		initOptions	 (settings->m_options	    ) ;

		if (!settings->m_printerName.isEmpty())
			setSearchName (settings->m_printerName) ;
	}
}

/*  TKPrinter								*/
/*  saveSettings: Save the current settings				*/
/*  elem	: QDomElement &	: Element into which to save		*/
/*  (returns)	: void		:					*/

void	TKPrinter::saveSettings
	(	QDomElement	&elem
	)
{
	QDomElement	qpElem	;
	QDomElement	kpElem	;

	/* Look for extant child nodes for QPrinter and for KPrinter.	*/
	/* If they do not exist then thay are created.			*/
	for (QDomNode node = elem.firstChild() ; !node.isNull() ; node = node.nextSibling())
	{
		QDomElement e = node.toElement () ;
		if (e.isNull()) continue ;

		if (e.tagName() == "QPrinter") qpElem = e ;
		if (e.tagName() == "KPrinter") kpElem = e ;
	}

	if (qpElem.isNull())
	{	qpElem = elem.ownerDocument().createElement ("QPrinter") ;
		elem.appendChild (qpElem) ;
	}
	if (kpElem.isNull())
	{	kpElem = elem.ownerDocument().createElement ("KPrinter") ;
		elem.appendChild (kpElem) ;
	}

	/* Save all the QPrinter settings. We do this even if running	*/
	/* under KDE to give some possibility of forward and backward	*/
	/* movement of databases.					*/
	qpElem.setAttribute ("colorMode",      colorMode     ()) ;
	qpElem.setAttribute ("numCopies",      numCopies     ()) ;
	qpElem.setAttribute ("orientation",    orientation   ()) ;
	qpElem.setAttribute ("outputFilename", outputFileName()) ;
	qpElem.setAttribute ("outputToFile",   outputToFile  ()) ;
	qpElem.setAttribute ("pageOrder",      pageOrder     ()) ;
	qpElem.setAttribute ("pageSize",       pageSize      ()) ;
	qpElem.setAttribute ("printProgram",   printProgram  ()) ;
	qpElem.setAttribute ("printerName",    printerName   ()) ;
	qpElem.setAttribute ("selectOption",   printerSelectionOption()) ;

	/* Save KPrinter settings. Here we fish the stuff out of the	*/
	/* options map and save as a set of identically named		*/
	/* attributes.							*/

	const QMap<QString,QString>	     optMap  = options() ;
	QMap<QString,QString>::ConstIterator optIter ;

	for (optIter = optMap.begin() ; optIter != optMap.end() ; ++optIter)
		kpElem.setAttribute
		(	optIter.key ().latin1(),
			optIter.data().latin1()
		)	;
}

void	TKPrinter::saveSettings
	(	TKPrinterSettings	&settings
	)
{
	settings.m_colorMode		= colorMode	() ;
	settings.m_numCopies		= numCopies	() ;
	settings.m_orientation		= orientation	() ;
	settings.m_outputFileName	= outputFileName() ;
	settings.m_outputToFile		= outputToFile	() ;
	settings.m_pageOrder		= pageOrder	() ;
	settings.m_pageSize		= pageSize	() ;
	settings.m_printProgram 	= printProgram	() ;
	settings.m_printerName		= printerName	() ;
	settings.m_printerSelectionOption
					= printerSelectionOption () ;
	settings.m_options		= options	() ;
}

/*  TKPrinter								*/
/*  loadSettings: Load settings to restore printer state		*/
/*  elem	: QDomElement &	: Specification				*/
/*  (returns)	: void		:					*/

void	TKPrinter::loadSettings
	(	QDomElement	&elem
	)
{
	QDomElement	qpElem	;
	QDomElement	kpElem	;

	/* Look for the QPrinter and KPrinter child nodes, and restore	*/
	/* if they exist.						*/
	for (QDomNode node = elem.firstChild() ; !node.isNull() ; node = node.nextSibling())
	{
		QDomElement e = node.toElement () ;
		if (e.isNull()) continue ;

		if (e.tagName() == "QPrinter") qpElem = e ;
		if (e.tagName() == "KPrinter") kpElem = e ;
	}

	if (!qpElem.isNull())
	{
		dumpElem ("qpElem", qpElem) ;

		setColorMode	 ((ColorMode  )qpElem.attribute ("colorMode"     ).toInt()) ;
		setNumCopies	 (	       qpElem.attribute ("numCopies"     ).toInt()) ;
		setOrientation	 ((Orientation)qpElem.attribute ("orientation"   ).toInt()) ;
		setOutputFileName(	       qpElem.attribute ("outputFilename")) ;
		setOutputToFile	 (	       qpElem.attribute ("outputToFile"  )) ;
		setPageOrder	 ((PageOrder  )qpElem.attribute ("pageOrder"     ).toInt()) ;
		setPageSize	 ((PageSize   )qpElem.attribute ("pageSize"      ).toInt()) ;
		setPrintProgram	 (	       qpElem.attribute ("printProgram"  )) ;
		setPrinterName	 (	       qpElem.attribute ("printerName"   )) ;
		setPrinterSelectionOption
				 (	       qpElem.attribute ("selectOption"  )) ;
	}

	if (!kpElem.isNull())
	{
		dumpElem ("kpElem", kpElem   ) ;
		dumpMap  ("Before", options()) ;

		QMap<QString,QString>	optMap  ;
		QDomNamedNodeMap	nodeMap = kpElem.attributes() ;

		for (uint idx = 0 ; idx < nodeMap.length() ; idx += 1)
		{
			QDomNode node = nodeMap.item(idx) ;
			optMap.insert (node.nodeName(), node.nodeValue()) ;
		}
		initOptions (optMap) ;

		QString	pn = qpElem.attribute ("printerName") ;
		if (!pn.isEmpty()) setSearchName (pn) ;

		dumpMap  ("After", options()) ;

	}
}

bool	TKPrinter::setup ()
{
	return	KPrinter::setup () ;
}

QValueList<int>
	TKPrinter::pageList ()
	const
{
	return	KPrinter::pageList () ;
}
