/***************************************************************************
    file	         : tk_progress.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qapplication.h>
#include	<qlayout.h>
#include	<qfont.h>
#include	<qfontmetrics.h>

#include	"tk_progress.moc"


/*  TKProgress								*/
/*  TKProgress	: Constructor for progress dialog			*/
/*  caption	: const QString & : Dialog caption			*/
/*  legend	: const QString & : Legend text				*/
/*  of		: const QString & : Text for "of" label			*/
/*  showTotal	: bool		  : Show total field			*/
/*  showat	: uint		  : Count at which to show		*/
/*  (returns)	: TKProgress	  :					*/

TKProgress::TKProgress
	(	const QString	&caption,
		const QString	&legend,
		const QString	&of,
		bool		showTotal,
		uint		showat
	)
	:
	QDialog		(0, "tkprogress", true),
	m_legend	(this),
	m_count		(this),
	m_of		(this),
	m_total		(this),
	m_bCancel	(this),
	m_showat	(showat)
{
	QVBoxLayout	*layMain = new QVBoxLayout (this) ;
	QHBoxLayout	*layProg = new QHBoxLayout (layMain) ;
	QHBoxLayout	*layButt = new QHBoxLayout (layMain) ;

	layMain->setMargin (4) ;
	layMain->setSpacing(4) ;
	layProg->setMargin (4) ;
	layProg->setSpacing(4) ;
	layButt->setMargin (4) ;
	layButt->setSpacing(4) ;

	layProg->addWidget (&m_legend ) ;
	layProg->addWidget (&m_count  ) ;
	layProg->addWidget (&m_of     ) ;
	layProg->addWidget (&m_total  ) ;

	layButt->addStretch()		;
	layButt->addWidget (&m_bCancel) ;

	m_legend .setText  (legend    ) ;
	m_of	 .setText  (of	      ) ;
	m_bCancel.setText  ("Cancel"  ) ;

	if (of.isEmpty()) m_of   .hide () ;
	if (!showTotal  ) m_total.hide () ;

	int	width	= QFontMetrics(QFont()).width("000000") ;
	m_count.setFixedWidth (width) ;
	m_of   .setFixedWidth (width) ;

	m_count.setReadOnly   (true ) ;
	m_total.setReadOnly   (true ) ;

	setCaption (caption) ;

	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;
	connect (&m_timer,   SIGNAL(timeout()), SLOT(slotTimer  ())) ;

	m_cancelled = false 	;
	m_period    = 0		;
	m_done	    = 0x7ffffff	;
	m_next	    = 0		;

	if (!showTotal) m_of.hide() ;
}

/*  TKProgress								*/
/*  clickCancel	: User clicks cancel					*/
/*  (returns)	: void		:					*/

void	TKProgress::clickCancel ()
{
	m_cancelled = true ;
}

/*  TKProgress								*/
/*  slotTimer	: Timer event						*/
/*  (returns)	: void		:					*/

void	TKProgress::slotTimer ()
{
	/* If the done value has changed then update the display with	*/
	/* the new value.						*/
	if (m_next != m_done)
		m_count.setText (QString("%1").arg(m_done = m_next)) ;
}

/*  TKProgress								*/
/*  setTotal	: Set the total value					*/
/*  total	: uint		: Value					*/
/*  (returns)	: void		:					*/

void	TKProgress::setTotal
	(	uint	total
	)
{
	m_total.setText (QString("%1").arg(total)) ;
}

/*  TKProgress								*/
/*  setDone	: Set the count done					*/
/*  done	: uint		: Count					*/
/*  (returns)	: void		:					*/

void	TKProgress::setDone
	(	uint	done
	)
{
	if (m_period > 0)
	{
		m_next = done ;

		/* If the timer has not already been started then do	*/
		/* so now. This avoids unneccessary timer events until	*/
		/* the called actually uses the dialog.			*/
		if (!m_timer.isActive()) m_timer.start (m_period) ;
	}
	else
	{
		m_count.setText (QString("%1").arg(m_done = m_next = done)) ;
	}

	if ((done > m_showat) && !isVisible()) show () ;

	/* Drive the event loop to process any outstanding events,	*/
	/* which may include our own timer events.			*/
	qApp->processEvents() ;
}
