/***************************************************************************
    file	         : tk_config.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<qstringlist.h>

#include	"qsettings.h"
#include	"tk_config.h"

static	TKConfig	*appConfig	;

TKConfig::TKConfig ()
{
	m_vendor = "unknown"	;
	m_app	 = "unknown"	;
	m_group	 = "unknown"	;
	m_prefix = QString("/%1/%2/").arg(m_app).arg(m_group) ;

	m_config = new QSettings () ;
}

TKConfig*TKConfig::getConfig ()
{
	if (appConfig == 0) appConfig = new TKConfig () ;
	return	appConfig ;
}

void	TKConfig::setVendor
	(	const char	*vendor
	)
{
	m_vendor = vendor ;
	m_prefix = QString("/%1/%2/").arg(m_app).arg(m_group) ;
}

void	TKConfig::setApplication
	(	const char	*app
	)
{
	m_app    = app	  ;
	m_prefix = QString("/%1/%2/").arg(m_app).arg(m_group) ;
}

QString	TKConfig::makeKey
	(	const QString	&key
	)
	const
{
	return	m_prefix + key ;
}

void	TKConfig::writeEntry
	(	const QString	&key,
		const QString	&value
	)
{
	m_config->writeEntry (makeKey(key), value) ;
}

void	TKConfig::writeEntry
	(	const QString	&key,
		int		value
	)
{
	m_config->writeEntry (makeKey(key), value) ;
}

void	TKConfig::writeEntry
	(	const QString	&key,
		unsigned int	value
	)
{
	m_config->writeEntry (makeKey(key), (int)value) ;
}

void	TKConfig::writeEntry
	(	const QString	&key,
		const QSize	&value
	)
{
	QValueList<int> list ;
	list.append (value.width ()) ;
	list.append (value.height()) ;
	writeEntry  (key, list) ;
}

void	TKConfig::writeEntry
	(	const QString		&key,
		const QValueList<int>	&value
	)
{
	QString	text	;

	for (unsigned int idx = 0 ; idx < value.count() ; idx += 1)
	{
		if (!text.isEmpty()) text += "," ;
		text += QString("%1").arg(value[idx]) ;
	}

	writeEntry (key, text) ;
}

void	TKConfig::writeEntry
	(	const QString 		&key,
		const QStringList 	&value,
		char			sep
	)
{
	m_config->writeEntry (key, value.join (QString("%1").arg(sep))) ;
}


QString	TKConfig::readEntry
	(	const QString	&key,
		const QString	&def
	)
{
	return	m_config->readEntry (makeKey(key), def) ;
}

unsigned
int	TKConfig::readUnsignedNumEntry
	(	const QString	&key,
		unsigned int	def
	)
	const
{
	bool		ok	 ;
	unsigned int	value	 = m_config->readNumEntry (makeKey(key), def, &ok) ;
	return	ok ? value : def ;
}

int	TKConfig::readNumEntry	
	(	const QString	&key,
		int		def
	)
	const
{
	bool	ok	;
	int	value	= m_config->readNumEntry (makeKey(key), def, &ok) ;
	return	ok ? value : def ;
}

bool	TKConfig::readBoolEntry	
	(	const QString	&key,
		bool		def
	)
	const
{
	bool	ok	;
	int	value	= m_config->readNumEntry (makeKey(key), def, &ok) ;
	return	ok ? value : def ;
}

QSize	TKConfig::readSizeEntry	
	(	const QString	&key,
		const QSize	*def
	)
	const
{
	QValueList<int> values = readIntListEntry (key) ;
	if (values.count() == 2) return QSize(values[0], values[1]) ;
	if (def == 0) return QSize() ;
	return	*def ;
}

QValueList<int>
	TKConfig::readIntListEntry
	(	const QString	&key
	)
	const
{
	QString		text	= m_config->readEntry (makeKey(key)) ;
	QStringList	list	= QStringList::split (",", text, true) ;
	QValueList<int>	values	;

	for (unsigned int idx = 0 ; idx < list.count() ; idx += 1)
		values.append (list[idx].toInt()) ;

	return	values	;
}

QStringList
	TKConfig::readListEntry
	(	const QString	&key,
		char		sep
	)
	const
{
	QString	text	= m_config->readEntry (makeKey(key)) ;
	return	QStringList::split (sep, text, true) ;
}

void	TKConfig::setGroup
	(	const QString	&group
	)
{
	m_group	 = group ;
//	m_prefix = QString("/%1/%2/%3/").arg(m_vendor).arg(m_app).arg(m_group) ;
	m_prefix = QString("/%1/%2/").arg(m_app).arg(m_group) ;
}

void	TKConfig::sync ()
{
	delete m_config	;
	m_config = new QSettings () ;
}

void	TKConfig::insertSearchPath
	(	int		system,
		const QString	&path
	)
{
	m_config->insertSearchPath ((QSettings::System)system, path) ;
}

