/***************************************************************************
    file	         : tk_print.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"tk_print.h"


/*  TKPrinter								*/
/*  TKPrinter	: Constructor for printer wrapper class			*/
/*  resolution	: Resolution	: Print resolution			*/
/*  settings	: TKPrinterSettings *					*/
/*				: Initial settings or null		*/
/*  (returns)	: TKPrinter	:					*/

TKPrinter::TKPrinter
	(	Resolution		resolution,
		TKPrinterSettings	*settings
	)
	:
	QPrinter ()
{
	/* This seems to be neccessary to get selection to work. Assume	*/
	/* 1024 will be enough!						*/
	setMinMax (1, 1024) ;

	if (settings != 0)
	{
		fprintf
		(	stderr,
			"TKPrinter::TKPrinter: pn=[%s]\n",
			(const char *)settings->m_printerName
		)	;

		setColorMode	 (settings->m_colorMode     ) ;
		setNumCopies	 (settings->m_numCopies	    ) ;
		setOrientation	 (settings->m_orientation   ) ;
		setOutputFileName(settings->m_outputFileName) ;
		setOutputToFile	 (settings->m_outputToFile  ) ;
		setPageOrder	 (settings->m_pageOrder	    ) ;
		setPageSize	 (settings->m_pageSize	    ) ;
		setPrintProgram	 (settings->m_printProgram  ) ;
		setPrinterName	 (settings->m_printerName   ) ;
		setPrinterSelectionOption
				 (settings->m_printerSelectionOption) ;
	}
}

void TKPrinter::saveSettings(QDomElement &elem)
{
	QDomElement	qpElem;
	
	for(QDomNode node = elem.firstChild(); !node.isNull(); node = node.nextSibling())
	{
		QDomElement e = node.toElement();

		if(e.isNull()) 
			continue ;

		if(e.tagName() == "QPrinter") 
			qpElem = e ;
	}

	if(qpElem.isNull())
	{	
		qpElem = elem.ownerDocument().createElement("QPrinter");
		elem.appendChild (qpElem) ;
	}

	qpElem.setAttribute("colorMode", 	colorMode	()) ;
	qpElem.setAttribute("numCopies", 	numCopies	()) ;
	qpElem.setAttribute("orientation", 	orientation	()) ;
	qpElem.setAttribute("outputFilename", 	outputFileName	()) ;
	qpElem.setAttribute("outputToFile", 	outputToFile	()) ;
	qpElem.setAttribute("pageOrder", 	pageOrder	()) ;
	qpElem.setAttribute("pageSize", 	pageSize	()) ;
	qpElem.setAttribute("printProgram", 	printProgram	()) ;
	qpElem.setAttribute("printerName", 	printerName	()) ;
	qpElem.setAttribute("selectOption", 	printerSelectionOption()) ;
}

void	TKPrinter::saveSettings
	(	TKPrinterSettings	&settings
	)
{
	settings.m_colorMode		= colorMode	() ;
	settings.m_numCopies		= numCopies	() ;
	settings.m_orientation		= orientation	() ;
	settings.m_outputFileName	= outputFileName() ;
	settings.m_outputToFile		= outputToFile	() ;
	settings.m_pageOrder		= pageOrder	() ;
	settings.m_pageSize		= pageSize	() ;
	settings.m_printProgram 	= printProgram	() ;
	settings.m_printerName		= printerName	() ;
	settings.m_printerSelectionOption
					= printerSelectionOption () ;
}

void TKPrinter::loadSettings(QDomElement &elem)
{
	QDomElement	qpElem	;

	for (QDomNode node = elem.firstChild(); !node.isNull(); node = node.nextSibling())
	{
		QDomElement e = node.toElement();
		
		if (e.isNull()) 
			continue ;

		if (e.tagName() == "QPrinter") 
			qpElem = e ;
	}

	if (!qpElem.isNull())
	{
		setColorMode	 ((ColorMode  )qpElem.attribute ("colorMode"     ).toInt()) ;
		setNumCopies	 (	       qpElem.attribute ("numCopies"     ).toInt()) ;
		setOrientation	 ((Orientation)qpElem.attribute ("orientation"   ).toInt()) ;
		setOutputFileName(	       qpElem.attribute ("outputFilename")) ;
		setOutputToFile	 (	       qpElem.attribute ("outputToFile"  )) ;
		setPageOrder	 ((PageOrder  )qpElem.attribute ("pageOrder"     ).toInt()) ;
		setPageSize	 ((PageSize   )qpElem.attribute ("pageSize"      ).toInt()) ;
		setPrintProgram	 (	       qpElem.attribute ("printProgram"  )) ;
		setPrinterName	 (	       qpElem.attribute ("printerName"   )) ;
		setPrinterSelectionOption
				 (	       qpElem.attribute ("selectOption"  )) ;
	}
}

bool TKPrinter::setup()
{
	return	QPrinter::setup() ;
}

QValueList<int> TKPrinter::pageList() const
{
	int fp = fromPage();
	int	tp = toPage();
	QValueList<int>	pl;

	if((fp == 0) && (tp == 0)) 
		return pl;

	while(fp <= tp)
	{
		pl.append (fp);
		fp += 1;
	}

	return	pl;
}
