/***************************************************************************
    file	         : tk_toolbutton.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qpainter.h>
#include	<qtooltip.h>
#include	<qdrawutil.h>
#include	<qimage.h>
#include	<qbitmap.h>

#ifndef		_WIN32
#include	"tk_toolbutton.moc"
#else
#include	"tk_toolbutton.h"
#endif

extern	QPixmap	getBarIcon	(const QString &) ;
extern	QPixmap	getSmallIcon	(const QString &) ;

#if	0
static	void	desaturate
	(	QPixmap		&pm,
		double		value
	)
{
	QImage	img	= pm.convertToImage() ;

	int 	 pixels	= (img.depth() > 8) ?
				img.width() * img.height() :
				img.numColors() ;

	unsigned *data	= (img.depth() > 8) ?
				(unsigned *)img.bits() :
				(unsigned *)img.colorTable();

	QColor	color	;
	int	h, s, v	;

	for (int i = 0 ; i < pixels ; i += 1)
	{
		color.setRgb (data[i]) ;
		color.hsv    (&h, &s, &v);
		color.setHsv (h, (int)(s * (1.0 - value) + 0.5), v) ;

		data[i] = qRgba
			  (	color.red  (),
				color.green(),
				color.blue (),
				qAlpha(data[i])
			  )	;
	}

	pm.convertFromImage (img) ;
}


static	void	togray
	(	QPixmap		&pm,
		double		value
	)
{
	QImage	img	= pm.convertToImage() ;

	int 	 pixels	= (img.depth() > 8) ?
				img.width() * img.height() :
				img.numColors() ;

	unsigned *data	= (img.depth() > 8) ?
				(unsigned *)img.bits() :
				(unsigned *)img.colorTable();

	int	rval	;
	int	gval	;
	int	bval	;
	int	val	;
	int	alpha	;

	for (int i = 0 ; i < pixels ; i += 1)
	{
		val	= qGray  (data[i]) ;

		if (value < 1.0)
		{
			rval = (int)(value * val + (1.0-value) * qRed   (data[i])) ;
			gval = (int)(value * val + (1.0-value) * qGreen (data[i])) ;
			bval = (int)(value * val + (1.0-value) * qBlue  (data[i])) ;

			data[i] = qRgb (rval, gval, bval) ;
		}
		else	data[i] = qRgb (val,  val,  val ) ;
	}

	pm.convertFromImage (img) ;
}
#endif

static	void	semiTrans
	(	QPixmap		&pm
	)
{
	QImage	img ;

	if (pm.mask() == 0)
	{
	        img.create (pm.size(), 1, 2, QImage::BigEndian) ;
        	img.fill   (1);
	}
	else	img = pm.mask()->convertToImage();
 
	for (int y = 0 ; y < img.height() ; y += 1)
	{
		uchar	*line	= (uchar *) img.scanLine (y) ;
		uchar	pattern = (y % 2) ? 0x55 : 0xaa ;

		for (int x = (img.width() + 7) / 8 ; x > 0; x -= 1)
			*line++ &= pattern ;
	}

	QBitmap	mask	  ;
	mask.convertFromImage (img) ;
	pm.setMask (mask) ;
}


TKToolBarButton::TKToolBarButton
	(	const QString	&iconName,
		const QString	&text,
		const QString	&,
		QObject		*receiver,
		const char	*slot,
		QWidget		*parent,
		const char	*name
	)
	:
	QToolButton	(parent, name)
{
	m_id	= 0	;
	init	(iconName, text) ;

	connect	(this, SIGNAL(clicked(int)), receiver, slot) ;
}

TKToolBarButton::TKToolBarButton
	(	const QString	&iconName,
		int		id,
		QWidget 	*parent,
		const char 	*name,
		const QString	&text
	)
	:
	QToolButton	(parent, name)
{
	m_id	= id	;
	init	(iconName, text) ;
}

void	TKToolBarButton::init
	(	const QString	&iconName,
		const QString	&text
	)
{
#if	__KB_EMBEDDED
	m_pmDefault	= getSmallIcon (iconName) ;
#else
	m_pmDefault	= getBarIcon   (iconName) ;
#endif
	m_pmActive	= m_pmDefault  ;
	m_pmDisabled	= m_pmDefault  ;

	semiTrans (m_pmDisabled) ;

	QButton::setPixmap (m_pmDefault) ;

	m_active		= false	;
	m_raised		= false	;

	setEnabled	(true)	;
	setAutoRaise	(true)	;
	QToolTip::add	(this, text) ;

	connect		(this, SIGNAL(clicked()), this, SLOT(slotClicked())) ;
}

void	TKToolBarButton::slotClicked ()
{
	emit	clicked	(m_id) ;
}


void	TKToolBarButton::setEnabled
	(	bool		enabled
	)
{
	QButton::setPixmap  (enabled ? m_pmDefault : m_pmDisabled) ;
	QButton::setEnabled (enabled) ;
}

void	TKToolBarButton::enterEvent
	(	QEvent		*
	)
{
	if (isEnabled())
	{
		QButton::setPixmap (m_pmActive  ) ;
		m_active = true	;
		if (!isToggleButton()) m_raised = true ;
	}
	else
	{
		QButton::setPixmap (m_pmDisabled) ;
		m_active	= false	;
		m_raised	= false	;
	}

	repaint	(false) ;
}

void	TKToolBarButton::leaveEvent
	(	QEvent		*
	)
{
	if (m_active || m_raised)
	{
		QButton::setPixmap (isEnabled() ? m_pmDefault : m_pmDisabled) ;
		m_active	= false	;
		m_raised	= false	;
	}

	repaint	(false) ;

}

void	TKToolBarButton::drawButton
	(	QPainter	*p
	)
{
	bool		 sunken	= isDown() || isOn() ;
	const QColorGroup&cg	= isEnabled() ? colorGroup() : palette().disabled() ;

	if	(  sunken) qDrawWinButton (p, 0, 0, width(), height(), cg, true ) ;
	else if (m_raised) qDrawWinButton (p, 0, 0, width(), height(), cg, false) ;

        if (pixmap())
	{
		int	dx = (width () - pixmap()->width ()) / 2 ;
		int	dy = (height() - pixmap()->height()) / 2 ;

		if (sunken)
		{	dx	+= 1 ;
			dy	+= 1 ;
		}

		p->drawPixmap (dx, dy, *pixmap()) ;
        }
	else	QToolButton::drawButton (p) ;
}

