/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#ifndef TKTEXTEDITOR_H
#define TKTEXTEDITOR_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#include <qframe.h>
#include <qaction.h>

#include "libtkwidgets_exports.h"

class LIBTKWIDGETS_API  TKTextEditorManager;
class LIBTKWIDGETS_API  TKTextMarginManager;
class LIBTKWIDGETS_API  TKTextView;
class LIBTKWIDGETS_API  TKTextDocument;

class LIBTKWIDGETS_API  TKTextEditor : public QFrame
{
	Q_OBJECT
	friend class TKTextDocument;
	friend class TKTextView;

public:

	TKTextEditor(TKTextDocument *, QWidget *parent=0, const char *name=0);
	~TKTextEditor();

	TKTextDocument *textDocument() const { return document; }
	TKTextView *textView() const { return view; }

  enum ChangeId {
    CursorPosition,
    Modification,
    UndoRedo,
    Selection
  };

  virtual bool viewSetFocusOK() ;

  void clear();
  QString getSelectedText();
  QString text();
  void setText(const QString &);
  void append(const QString &);
  void setReadOnly(bool);
  bool isReadOnly();
  void insertLine(const QString &, int line);

	QFont textFont() const;
  void setTextFont(const QFont &);

//  void addMarginItem(TKTextMarginManager *, int line, int itemId=0);
//  void removeMarginItem(TKTextMarginManager *, int line, int itemId=0);

  int line();
  int column();
  bool isModified();
  void setModified(bool);

  QString highlight();
  void setHighlight(const QString &);

  void setWrap(bool);
  bool getWrap();

  bool find(const QString &text, bool caseSensitive, bool wholeWord, bool fromCursor, bool inSelection, bool cycle=true);
  void replaceFound(const QString &text);
  //******** change type of returned value from 'void' to 'int' - return count of replacements
  /*int*/ void replaceAll(const QString &text, const QString &replaceText, bool caseSensitive, bool wholeWord, bool inSelection);

  bool findRegexp(const QString &pattern, bool caseSensitive, bool wildcard, bool fromCursor=false);

  QString html(int from=0, int to=-1);

  void setFilePath(const QString &);
  QString filePath();
  QString title();

  bool isLastView();

  void makeFold(int fromLine, int toLine);

  virtual bool eventFilter(QObject *, QEvent *);

  bool canRedo();
  bool canUndo();

  bool hasSelection();
  bool hasSelections();
  bool hasFound();

  void clearFound();

  void notifyChange(TKTextEditor::ChangeId);

#ifdef KOBOL
  bool isLinuNumberMarginVisible();
#endif

public slots:
  void print();
  bool save();
  bool saveAs(const QString &);
  bool open(const QString &);
  void fileNew();

  void del();
  void cut();
  void copy();
  void paste();

  void indent();
  void unindent();

  void undo();
  void redo();

  void completeWord();

  void moveCursor(int line, int column);
  void setTextCodec(QTextCodec *);

  void setLinuNumberMarginVisible(bool);

signals:
  void update();
  void changed(int);
  void filePathChange();

public:
#ifdef KOBOL
  bool fLinuNumberMargin;
#endif

protected:
  void printPreview();

protected:
  TKTextDocument *document;
  TKTextEditorManager *manager;
  TKTextView *view;
  QTextCodec *textCodec;

  QString path;
};

#endif
