/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#ifndef TKTEXTLINE_H
#define TKTEXTLINE_H

#ifdef _WIN32
#pragma warning(disable : 4251)
#endif

#include <qstring.h>
#include <qvaluelist.h>

#if QT_VERSION >= 300
#include <qptrlist.h>
#else
#include <qlist.h>
#define QPtrList QList
#endif

#include "libtkwidgets_exports.h"

class LIBTKWIDGETS_API  TKTextLine : public QString
{
public:
  TKTextLine();
  ~TKTextLine();

  void resetHighlight(int context);
  void doneHighlight();
  bool isHighlighted();
  int highlightContext();

  void setContext(int);
  int context();

  void set(const QString &);
  void replace(uint index, uint len, const QString &);
  bool removeSpaces();

  int firstChar() const;
  QChar &ref(uint);

  void setAttributes(int attribute, uint start, uint end);
  int attribute(uint pos) const;

  void setMarked (int m);
  int marked ();

private:
  QByteArray attributes;

  int ctx;
  int hctx;
  int mark;
  bool highlighted;

/* Folding */
public:
  enum Status { Mater=1, Open=2, Close=4, Slave=8 , Last=16, Wrapped=32 };

  void appendChild(TKTextLine *);
  QPtrList<TKTextLine> *children() const;
  void removeChildren();

  void setStatus(int);
  int status();

private:
  int st;
  QPtrList<TKTextLine> *sublines;

/* Numbers */
public:
  void setNumber(int);
  int number() const;
  void setInternalNumber(int);
  int internalNumber() const;

private:
  int num;
  int intnum;

/* Margins */
public:
  void setMargin(int classId, int itemId);
  void delMargin(int classId, int itemId);
  bool firstMargin(int &classId, int &itemId);
  QValueList<int> marginsForClass(int classId);
	
/* Breakpoint */
public:
	void setBreakpoint(bool);
	void enableBreakpoint(bool);
	bool isBreakpoint();
	bool isBreakpointEnabled();

private:
	bool breakpoint;
	bool breakpointEnabled;
		
private:
  struct MarginData {
    int classId;
    int itemId;
  };
  QPtrList<MarginData> *margins;
};

inline void TKTextLine::setContext(int context)
{ ctx = context; }

inline int TKTextLine::context()
{ return ctx; }

inline bool TKTextLine::isHighlighted()
{ return highlighted; }

inline int TKTextLine::highlightContext()
{ return hctx; }

inline void TKTextLine::doneHighlight()
{ highlighted = true; }

inline void TKTextLine::setStatus(int status)
{ st = status; }

inline int TKTextLine::status()
{ return st; }

inline QPtrList<TKTextLine> *TKTextLine::children() const
{ return sublines; }

inline void TKTextLine::setNumber(int n)
{ num = n; }

inline int TKTextLine::number() const
{ return num; }

inline void TKTextLine::setInternalNumber(int n)
{ intnum = n; }

inline int TKTextLine::internalNumber() const
{ return intnum; }

inline void TKTextLine::setMarked (int m)
{ mark = m ; }

inline int TKTextLine::marked ()
{ return mark ; }

inline void TKTextLine::setBreakpoint(bool f)
{ breakpoint = f; }

inline bool TKTextLine::isBreakpoint()
{ return breakpoint; }

inline void TKTextLine::enableBreakpoint(bool f)
{ breakpointEnabled = f; }

inline bool TKTextLine::isBreakpointEnabled()
{ return breakpointEnabled; }

#endif

