/***************************************************************************
    file	         : kb_wizmaster.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_dblink.h"
#include	"kb_location.h"
#include	"kb_qryquery.h"


#include	"kb_wizsource.h"

#ifndef		_WIN32
#include	"kb_wizmaster.moc"
#else
#include	"kb_wizmaster.h"
#endif


/*  KBWizardCtrlMaster							*/
/*  KBWizardCtrlMaster							*/
/*		: Constructor for single column wizard control		*/
/*  page	: KBWizardPage *	 : Parent page			*/
/*  elem	: QDomElement  &	 : Definition element		*/
/*  (returns)	: KBWizardCtrlMaster :					*/

KBWizardCtrlMaster::KBWizardCtrlMaster
	(	KBWizardPage		*page,
		const QDomElement	&elem
	)
	:
	KBWizardCtrl	(page, elem.attribute("name"))
{
	/* The "source" attribute should have the form "page.ctrl"	*/
	/* and names the control (which should actually be of class	*/
	/* "KBWizardCtrlDataSource") that specifies the source for the	*/
	/* fields.							*/
	m_sourceName	= elem.attribute  ("source") ;

	setWidget	(m_fields = new QComboBox (page)) ;
}

/*  KBWizardCtrlMaster							*/
/*  ~KBWizardCtrlMaster							*/
/*		: Destructor for data source wizard control		*/
/*  (returns)	:		:					*/

KBWizardCtrlMaster::~KBWizardCtrlMaster ()
{
}

/*  KBWizardCtrlMaster							*/
/*  pageShown	: Page containing control is shown			*/
/*  next	: bool		: Moving to next page			*/
/*  (returns)	: void		:					*/

void	KBWizardCtrlMaster::pageShown
	(	bool		next
	)
{
	/* Do nothing if moving backwards. The field list will not	*/
	/* have changed and this preserves the user selection.		*/
	if (!next) return ;

	KBQryBase	*query	= (KBQryBase *)page()->wizard()->cookie("query") ;

	if (query == 0)
	{
		KBError::EError
		(	TR("Cannot locate parent query"),
			QString::null,
			__ERRLOCN
		)	;
		return	;
	}

	m_fields->clear () ;

	QList<KBFieldSpec> fldList ;
	int		   pKey	   ;
	if (!query->getFieldList (0, fldList, pKey))
	{
		query->lastError().DISPLAY() ;
		return	;
	}

	LITER
	(	KBFieldSpec,
		fldList,
		fldSpec,

		m_fields->insertItem (fldSpec->m_name)
	)
}

/*  KBWizardCtrlMaster							*/
/*  setValue	: Set data value					*/
/*  value	: const QString & : Value to set			*/
/*  (returns)	: void		  :					*/

void	KBWizardCtrlMaster::setValue
	(	const QString	&
	)
{
	/* Not used! Anyway, it is a bit meaningless since we'd need	*/
	/* the name *and* the type.					*/
}

/*  KBWizardCtrlMaster							*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBWizardCtrlMaster::value ()
{
	return	m_fields->currentText() ;
}


WIZARDCTRLREG(Master)
