/***************************************************************************
    file	         : kb_componentviewer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_COMPONENTVIEWER_H
#define  _KB_COMPONENTVIEWER_H

#include	"kb_classes.h"
#include	"kb_attrdict.h"
#include	"kb_conductor.h"
#include	"kb_viewer.h"
#include	"kb_navgui.h"


class	KBObjTreeViewer	;



/*  KBComponentViewer							*/
/*  -----------------							*/
/*  This class is the MDI child wrapper for viewing components (only in	*/
/*  design mode).							*/

class	KBComponentViewer : public KBViewer, protected KBPlayer
{
	Q_OBJECT

	KBAttrDict		m_pDict		;

	QGuardedPtr<KBComponent>
				m_docRoot 	;
	KBNavGUI		*m_dataGUI	;
	KBObjTreeViewer		*m_objTree	;

	KBaseGUI		*m_designGUI	;

protected slots	:

	void			objTreeViewerDead	()	;

public	:

	KBComponentViewer (KBObjBase*, QWidget *, const QDict<QString> &, bool = false) ;
virtual~KBComponentViewer () ;

	virtual	KBComponentViewer
				*isComponentViewer	() { return this  ; }
	virtual	cchar		*getChanged		(bool)	;
	virtual	bool		queryClose		()	;

	KB::ShowRC		startup			(KBComponent *, KBError &) ;

	virtual	QString		playerName		()	;

	virtual	bool		playerPerform
				(	const QString	  &,
					const QStringList &,
					KBError		  &
				)	;
public	slots	:

	virtual	void	showAs		(KB::ShowAs)	;

	void		saveDocument	()     		;
	void		saveDocumentAs	()     		;

	void		doCtrlAlign	(int)		;
	void		doCut		()		;
	void		doCopy		()		;
	void		doSaveComponent	()		;
	void		doPaste		()		;
	void		snapToGrid	()		;

	void		showObjTree	()		;
	void		doMultiProp	()		;
	void		doProperties	()		;
}	;

extern	KBComponent
	*KBOpenCOmponent  (KBDBInfo *, const QString &, QDict<QString> *, KBError &) ;

#endif // _KB_COMPONENTVIEWER_H
