/***************************************************************************
    file	         : kb_editor.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  _KB_EDITOR_H
#define  _KB_EDITOR_H

#include	<qmultilineedit.h>
#include	<qlistbox.h>
#include	<qpushbutton.h>
#include	<qregexp.h>


#include	"tktextmanager.h"
#include	"tktexteditor.h"
#include	"tktextdoc.h"

#include	"tkc_tkemapper.h"

#include	"kb_locator.h"
#include	"kb_viewer.h"

#include	"tk_config.h"



class	QSplitter	;

/*  KBEditor								*/
/*  --------								*/
/*  Basic script editor class						*/

class	KBEditor : public KBViewer
{
	Q_OBJECT

	QSplitter		*m_splitter	;
	TKTextDocument		*m_document	;
	TKTextEditor		*m_editWin	;
	TKCTKEMapper		*m_mapper	;
	QListBox		*m_errWin	;
	KBaseGUI		*m_gui		;

	QRegExp			m_errExp	;
	QSize			m_size		;
	int			m_ewind		;

	KBScriptIF		*scrIface	;

	void		gotoLine	(int)	;
	void		loadPattern	(const QString &) ;
	void		loadFiles	(const QString &, uint) ;

public	:

		 KBEditor (KBObjBase *, QWidget *) ;
	virtual	~KBEditor () ;

	virtual	KBEditor	*isEditor	() { return this ; }
	virtual	cchar		*getChanged	(bool)	;
	virtual	bool		queryClose	()	;

	virtual	void		reloadScript	(const QString &, const QString &, uint) ;
	bool			startup		(const QString &, const QString &, int, bool) ;

	QString					def() ;

private	slots	:

	void			errSelected	(int)  ;
	void			modified	()     ;

public	slots	:

	virtual	void		showAs		(KB::ShowAs) ;

	void			saveDocument	()     ;
	void			saveDocumentAs	()     ;
	void			doCompile	()     ;
}	;

#endif // _KB_EDITOR_H
