/***************************************************************************
    file	         : kb_formlist.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include 	<qcursor.h>
#include 	<qpopupmenu.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_dbinfo.h"
#include	"kb_listitem.h"
#include	"kb_viewer.h"

#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_appptr.h"
#include	"kb_callback.h"

#ifndef 	_WIN32
#include	"kb_formlist.moc"
#else
#include	"kb_formlist.h"
#endif

#include	"kb_formviewer.h"

#if		! __KB_RUNTIME
#include	"kb_wizform.h"
#endif


/*  KBFormList								*/
/*  KBFormList	: Constructor for form list widget			*/
/*  parent	: QWidget *	: Parent widget				*/
/*  dbInfo	: KBDBInfo *	: Database information object		*/
/*  (returns)	: KBFormList	:					*/

KBFormList::KBFormList
	(	QWidget		*parent,
		KBDBInfo	*dbInfo
	)
	:
	KBFileList
	(	parent,
		dbInfo,
		"Create new form",
		"form",
		"form",
		"Form name"
	)
{
	enableWizard () ;
}

/*  KBFormList								*/
/*  ~KBFormList	: Destructor for form list widget			*/
/*  (returns)	:		:					*/

KBFormList::~KBFormList ()
{
}

/*  KBFormList								*/
/*  showServerMenu : Show popup menu for server entries			*/
/*  (returns)	   : void	:					*/

void	KBFormList::showServerMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertSeparator () ;
	pop.insertItem (TR("&Reload form list"),   this, SLOT(reloadServer())) ;
#if	! __KB_RUNTIME
	pop.insertItem (TR("&Copy to server ..."), this, SLOT(copyToServer())) ;
#endif
	pop.exec       (QCursor::pos()) ;
	return	;
}

/*  KBFormList								*/
/*  showObjectMenu : Show popup menu for server entries			*/
/*  (returns)	   : void	:					*/

void	KBFormList::showObjectMenu ()
{
	QPopupMenu pop ;
	pop.insertItem (TR("Cancel")) ;
	pop.insertSeparator () ;
	pop.insertItem (TR("&Data view"),    this, SLOT(showAsData  ())) ;
#if	! __KB_RUNTIME
	pop.insertItem (TR("D&esign view"),  this, SLOT(showAsDesign())) ;
	pop.insertItem (TR("&Rename form"),  this, SLOT(renameForm  ())) ;
	pop.insertItem (TR("De&lete form"),  this, SLOT(deleteForm  ())) ;
	pop.insertItem (TR("&Save to file"), this, SLOT(saveToFile  ())) ;
#endif
	pop.exec       (QCursor::pos()) ;
}

#if	! __KB_RUNTIME

/*  KBFormList								*/
/*  createByWizard							*/
/*		: Handle request to create object using a wizard	*/
/*  item	: KBListItem *	: Selected item				*/
/*  (returns)	: void		:					*/

void	KBFormList::createByWizard
	(	KBListItem	*item
	)
{
	QString		server	= item->parent()->text(0) ;
	KBLocation	dummy	(m_dbInfo, "form", server, "") ;

	KBWizardForm	wizForm (dummy, server)	;
	if (!wizForm.exec()) return ;

	KB::ShowAs	showAs	;
	QString		name	;
	QString		form	= wizForm.create (name, showAs)	;

	if (form.isEmpty ()) return ;

	KBLocation location	(m_dbInfo, "form", server, name) ;
	KBError	   error	;

	if (!location.save
		(	QString::null,
			QString::null,
			form,
			error
		))
	{
		error.DISPLAY()	;
		return	;	;
	}

	QDict<QString>	empty	 ;
	KBCallback	*cb	= KBAppPtr::getCallback() ;
	if (cb->openObject (location, showAs, empty, error) == KB::ShowRCError)
		error.DISPLAY () ;
}
#endif

/*  KBFormList								*/
/*  renameForm	: Rename a form						*/
/*  (returns)	: void		:					*/

void	KBFormList::renameForm ()
{
#if	! __KB_RUNTIME
	rename	(m_curItem) ;
#endif
}

/*  KBFormList								*/
/*  deleteForm	: Delete a form						*/
/*  (returns)	: void		:					*/

void	KBFormList::deleteForm ()
{
#if	! __KB_RUNTIME
	delobj	(m_curItem) ;
#endif
}
