/***************************************************************************
    file	         : kb_querybase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<errno.h>
#include	<time.h>

#include	<qwidget.h>


#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_location.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_display.h"
#include	"kb_node.h"
#include	"kb_query.h"
#include	"kb_options.h"
#include	"kb_string.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_docroot.h"
#include	"kb_viewer.h"
#include	"kb_build.h"

#include	"kb_queryviewer.h"

#include	"kb_objbase.h"

#ifndef		_WIN32
#include	"kb_querybase.moc"
#else
#include	"kb_querybase.h"
#endif

#include	"kb_querylist.h"


/*  KBQueryBase	:							*/
/*  KBQueryBase	: Constructor for base object for forms			*/
/*  parent	: QObject *	: Parent object				*/
/*  (returns)	: KBForm	:					*/

KBQueryBase::KBQueryBase
	(	QObject	*parent
	)
	:
	KBObjBase (parent)
{
	m_qryRoot = 0 ;
	m_viewer  = 0 ;
}

/*  KBQueryBase	:							*/
/*  ~KBQueryBase	: Destructor for base object for forms			*/
/*  (returns)	:		:					*/

KBQueryBase::~KBQueryBase ()
{
	DELOBJ (m_qryRoot) ;
}

/*  KBQueryBase	:							*/
/*  build	: Build an instance of an object			*/
/*  location	: KBLocation &	  : Object location			*/
/*  create	: bool		  : Creating a new object		*/
/*  pError	: KBError &	  : Error return			*/
/*  (returns)	: bool		  :					*/

bool	KBQueryBase::build
	(	KBLocation	&location,
		bool		create,
		KBError		&pError
	)
{
	setLocation (location) ;

	if (create)
	{
		m_qryRoot = new KBQuery () ;
	}
	else
	{
		QByteArray doc ;

		if (!getLocation().contents (doc, pError))
			return	false	;

		if ((m_qryRoot = KBOpenQueryText (getLocation(), doc, pError)) == 0)
			return	false	;
	}

	return	true	;
}

/*  KBQueryBase	:							*/
/*  show	: Show form						*/
/*  embed	: QWidget *	  : Widget into which to embed display	*/
/*  pDict	: QDict<QString>& : Parameter dictionary		*/
/*  showAs	: KB::ShowAs	  : Display mode			*/
/*  pError	: KBError &	  : Error return			*/
/*  key		: const KBValue & : Parent key				*/
/*  rDict	: QDict<QString>* : Results dictionary			*/
/*  (returns)	: KB::ShowRC	  : Startup success			*/

KB::ShowRC
	KBQueryBase::show
	(	KB::ShowAs		showAs,
		const QDict<QString>	&,
		QWidget			*embed,
		KBError			&pError,
		const KBValue		&,
		QDict<QString>		*
	)
{
	if (m_viewer == 0)
	{
		m_viewer = new KBQueryViewer (this, embed) ;
		setPart	(m_viewer, false) ;

		KB::ShowRC rc = m_viewer->startup (m_qryRoot, showAs, pError) ;

		if (rc != KB::ShowRCOK)
		{
			delete	m_viewer;
			return	rc	;
		}

		return	KB::ShowRCOK	;
	}

	m_viewer->widget()->setFocus()	;
	m_viewer->showAs(showAs)	;

	return	KB::ShowRCOK	;
}

QString	KBQueryBase::def ()
{
	QString	text	;
	m_qryRoot->printNode (text, 0) ;
	return	text	;
}

void	KBQueryBase::widgetClosing ()
{
	DELOBJ (m_qryRoot) ;
}

/*  ------------------------------------------------------------------  */


KBFACTORYIMPL
(	KBQueryFactory,
	queryview,
	"Rekall query viewer",
	"Plugin",
	"0",
	"7",
	"0"
)

QObject	*KBQueryFactory::create
	(	QObject		  *parent,
		cchar		  *name,
		cchar		  *className,
		const QStringList &
	)
{
	if ((className != 0) && (strcmp (className, "browser") == 0))
		return	new KBQueryList ((QWidget *)parent, (KBDBInfo *)name) ;

	return	new	KBQueryBase (parent) ;
}

cchar	*KBQueryFactory::ident ()
{
	return	__KB_BUILD_IDENT	;
}
