/***************************************************************************
    file	         : kb_kjsscript.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_KJSSCRIPT_H
#define	_KB_KJSSCRIPT_H


#include	<kjs/global.h>
#include	<kjs/interpreter.h>
#include	<kjs/lookup.h>
#include	<kjs/object.h>
#include	<kjs/operations.h>
#include	<kjs/types.h>
#include	<kjs/ustring.h>
#include	<kjs/value.h>

#include	"kb_classes.h"
#include	"kb_script.h"
#include	"kb_build.h"



/*  KBKJSScriptCode							*/
/*  --------------							*/
/*  KJS-specific class for precompiled inline code.			*/

class	KBKJSScriptCode : public KBScriptCode
{
public	:

	KJS::Interpreter	*m_interpreter	;
	KJS::Object		m_kjsFunc	;
	KBLocation		m_location	;
	int			m_sourceID	;

	KBKJSScriptCode
	(	KJS::Interpreter	*,
		const QString		&,
		const QString		&,
		KBLocation		&,
		bool			&
	)	;

	virtual	~KBKJSScriptCode	() ;

	virtual	KBScript::ExeRC	execute
		(	KBNode		*,
			uint		,
			const KBValue	*,
			KBValue		&
		)	;

	virtual	KBScript::ExeRC	execute
		(	KBNode		*,
			KBNode		*,
			const QString	&,
			uint		,
			const KBValue	*,
			KBValue		&
		)	;
}	;

/*  KBKJSScriptIF							*/
/*  ------------							*/
/*  This is the script interface object for the KJS script module.	*/

class	KBKJSScriptIF : public KBScriptIF
{
	Q_OBJECT

	KJS::Interpreter	*m_interpreter	;

	KJS::Value	compileText
			(	KBLocation		&,
				const QString		&,
				QString			&,
				QString			&,
				KBError			&
			) 	;

	KBScriptCode   *compileInline
			(	const QString		&,
				const QString		&,
				QString			&,
				QString			&,
				const QStringList	&,
				KBError			&
			)	;

	KJS::Value	findFunction
			(	const QStringList	&,
				const QString		&
			)	;

public	:

	KBKJSScriptIF () ;
	virtual	~KBKJSScriptIF () ;

	bool	load
		(	KBLocation		&,
			QString			&,
			QString			&,
			KBError			&,
			bool			&
		)	;

	virtual	void	setApp
		(	KBNotifier		*,
			KBCallback		*
		)	;

	virtual	bool	compile
		(	KBLocation		&,
			QString			&,
			QString			&,
			KBError			&
		)	;

	virtual	KBScriptCode   *compileFunc
		(	const QString		&,
			const QString		&,
			QString			&,
			QString			&,
			const QStringList	&,
			KBError			&
		)	;

	virtual	KBScriptCode   *compileExpr
		(	const QString		&,
			QString			&,
			QString			&,
			const QStringList	&,
			KBError			&
		)	;

	virtual	bool	load
		(	KBLocation		&,
			QString			&,
			QString			&,
			KBError			&
		)	;

	virtual	KBScript::ExeRC	execute
		(	const QStringList	&,
			const QString		&,
			KBNode			*,
			uint,
			const KBValue		*,
			KBValue 		&
		)	;


	virtual	KBLocation	exeError	(QString &, uint &, QString &) ;

	virtual	bool		unlink		(KBLocation     &, KBError &) ;
	virtual	bool		rename		(KBLocation     &, const QString &, KBError &) ;

	virtual	void		editorInit	(TKTextEditor   *) ;
	virtual	KBDebug		*showDebug	(TKToggleAction *) ;
	virtual	bool		debugScript	(KBLocation   &, KBError 	   &) ;  

	virtual	QString		ident		() ;

	static	KBKJSScriptIF 	*getIface	() ;
}	;



#endif	// _KB_KJSSCRIPT_H
