/***************************************************************************
    file	         : tkc_excskipdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef _WIN32
#include	"tkc_excskipdlg.moc"
#else
#include "tkc_excskipdlg.h"
#endif

/*  TKCExcSkipDlg							*/
/*  TKCExcSkipDlg: Constructor for exceptions skip list dialog		*/
/*  excSkipList	 : QStringList & : Current skip list			*/
/*  (returns)	 : TKCExcSkipDlg :					*/

TKCExcSkipDlg::TKCExcSkipDlg
	(	QStringList	&excSkipList
	)
	:
	_KBDialog	(TR("Exceptions to be ignored"), true),
	m_excSkipList	(excSkipList),
	m_info		(this),
	m_edit		(this),
	m_list		(this),
	m_bAdd		(this),
	m_bRemove	(this),
	m_bOK		(this),
	m_bCancel	(this),
	m_addRemCtl	(m_edit, m_list, m_bAdd, m_bRemove, false)
{
	m_layMain	= new QVBoxLayout (this		  ) ;
	m_layListAddRem	= new QHBoxLayout (m_layMain	  ) ;
	m_layListAddRem	->addWidget (&m_info	) ;

	m_layCtrls	= new QVBoxLayout (m_layListAddRem) ;
	m_layOKCancel	= new QHBoxLayout (m_layMain	  ) ;

	m_layListAddRem	->addWidget (&m_list	) ;
	m_layCtrls	->addWidget (&m_edit	) ;
	m_layCtrls	->addWidget (&m_bAdd	) ;
	m_layCtrls	->addWidget (&m_bRemove	) ;
	m_layOKCancel	->addStretch() ;
	m_layOKCancel	->addWidget (&m_bOK	) ;
	m_layOKCancel	->addWidget (&m_bCancel	) ;

	m_bAdd		 .setText   (TR("Add >>"   ))	;
	m_bRemove	 .setText   (TR("<< Remove"))	;
	m_bOK		 .setText   (TR("OK"	   ))	;
	m_bCancel	 .setText   (TR("Cancel"   ))	;

	connect	(&m_bOK,     SIGNAL(clicked()), SLOT(clickOK    ())) ;
	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;

	m_list.insertStringList (m_excSkipList) ;

	m_info.setText
	(	TR
		(	"<qt>"
			"When exception trapping is enabled, any exceptions "
			"raised from modules whose path is prefixed by an "
			"entry in the list will be ignored"
			"</qt>"
		)
	)	;
	m_info.setMinimumSize (m_info.sizeHint()) ;
}

/*  TKCExcSkipDlg							*/
/*  clickOK	: User clicks OK					*/
/*  (returns)	: void		:					*/

void	TKCExcSkipDlg::clickOK ()
{
	m_excSkipList.clear () ;
	for (uint idx = 0 ; idx < m_list.count() ; idx += 1)
		m_excSkipList.append (m_list.text(idx)) ;

	done	(1) ;
}

/*  TKCExcSkipDlg							*/
/*  clickCancel	: User clicks cancel					*/
/*  (returns)	: void		:					*/

void	TKCExcSkipDlg::clickCancel ()
{
	done	(0) ;
}

