/***************************************************************************
    file	         : tkc_pydebugbase.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TKC_PYDEBUGBASE_H
#define	__TKC_PYDEBUGBASE_H

#include	"kb_python.h"


#if	(PY_MAJOR_VERSION  > 2)
#define	__PY22PLUS	1
#endif

#if	(PY_MAJOR_VERSION == 2) && (PY_MINOR_VERSION >= 2)
#define	__PY22PLUS	1
#endif

#ifndef	__PY22PLUS
#define	__PY22PLUS	0
#endif

#if	(PY_MAJOR_VERSION == 2) && (PY_MINOR_VERSION >= 3)
#define	PY_FRAME_TYPE	_frame
#else
#define	PY_FRAME_TYPE	PyObject
#endif

#include	<qlist.h>
#include	<qdict.h>
#include	<qwidget.h>
#include	<qshared.h>
#include	<qptrdict.h>
#include	<qstring.h>

#include	"tkc_pyvalue.h"

class		TKTextEditor	;

/*  TKCPyTraceOpt							*/
/*  -------------							*/
/*  Options on continuing from a breakpoint				*/

enum	TKCPyTraceOpt
{
	OptContinue,			/* Continue execution normally	*/
	OptStep,			/* Single-step			*/
	OptAbort			/* Abort (throws an exception)	*/
}	;


/*  TKCPyTracePoint							*/
/*  ---------------							*/
/*  Class (struct really, but it gives us a constructor) which contains	*/
/*  tracepoint information. For function entry, "pyObj" points to the	*/
/*  code, with "lineNo" set to zero and "fName" null. For a line	*/
/*  tracepoint, "pyObj" points to the module, with "lineNo" being the	*/
/*  module line number, and "fName" containing the source file name.	*/

class	TKCPyTracePoint
{
public	:

	PyObject	*pyObj	;	/* Code or module		*/
	void		*userPtr;	/* User pointer			*/
	uint		lineNo	;	/* Module line number		*/
	QString		fName	;	/* Module file name		*/

	TKCPyTracePoint (PyObject *, void *, uint = 0) ;
}	;


/*  TKCPyCookie								*/
/*  -----------								*/
/*  The debugger code is intended for use in situations where python	*/
/*  modules may be stored other than in files (eg., Rekall stores them	*/
/*  inside the database as well). This is a virtual base class used to	*/
/*  hold the location of a module source (which in the simple case is	*/
/*  a file name), and to get and set the module text.			*/

class	TKCPyCookie
{
public	:

	virtual	~TKCPyCookie () ;

	virtual	bool		get		(      QString &, QString &, QString &) = 0 ;
	virtual	bool		put		(const QString &, QString &, QString &) = 0 ;
	virtual	bool		operator==	(const TKCPyCookie &) = 0 ;
	virtual	TKCPyCookie	*replicate	() = 0 ;
	virtual	QString		title		() = 0 ;
}	;


/*  TKCPyDebugBase							*/
/*  --------------							*/
/*  This is the base class for the debugger. It handles hooking into	*/
/*  the python interpreter, and provides a number of support functions.	*/
/*  Note that there should only be a single instance of this object.	*/

class	TKCPyDebugBase : public QObject
{
	Q_OBJECT

	static	TKCPyDebugBase		*debugger  	;
	static	QList<TKCPyTracePoint>	tracePoints	;
	static	TKCPyTraceOpt		traceOpt	;

	static	TKCPyTracePoint	*findTracePoint	(PyObject *, uint = 0) ;
	static	void		enable		() 	;
	static	void		disable		() 	;
	
public	:

	TKCPyDebugBase				() 	;
	virtual ~TKCPyDebugBase			() 	;

	QString			init		()	;

#if	! __PY22PLUS
	PyObject		*funcTraceHook	(PyObject *) ;
	PyObject		*lineTraceHook	(PyObject *) ;
	PyObject		*profTraceHook	(PyObject *) ;
#endif
#if	__PY22PLUS
	int			pythonTraceHook	(PyFrameObject *, int, PyObject *) ;
#endif
	PyObject		*debugHook	(PY_FRAME_TYPE *, const char *) ;

	virtual	TKCPyTraceOpt	funcTraceHook	(PyObject *, PyObject *, PyObject *, void *) ;
	virtual	TKCPyTraceOpt	lineTraceHook	(PyObject *, PyObject *, PyObject *, void *) ;
	virtual	TKCPyTraceOpt	profTraceHook	(PyObject *, PyObject *, PyObject *, void *) ;
	virtual	TKCPyTraceOpt	doDebugHook	(PY_FRAME_TYPE *, const char *) ;

	static	TKCPyTracePoint	*codeTraced	(PyCodeObject *) ;
	static	TKCPyTracePoint	*moduleTraced	(PyCodeObject *) ;
	static	TKCPyTracePoint	*moduleTraced	(PyCodeObject *, uint) ;

	static	void		setTracePoint	(PyObject *, void *, uint = 0) ;
	static	void		clearTracePoint	(PyObject *, uint = 0) ;
	static	bool		isTraced	(PyObject *, uint) ;
	static	void		trapExceptions	(bool) ;

	static	void		loadDictionary	(PyObject *, QDict<TKCPyValue> &) ;
	static	void		getModuleDict	(PyObject *, QDict<TKCPyValue> &) ;
	static	void		getModuleDict	(QDict<TKCPyValue> &) ;
	static	QString		getObjectName	(PyObject *) ;

	static	const TKCPyType*getPythonType	(PyObject *)	;
	static	QString		getPythonString	(PyObject *)	;
	static	void		inDebugger	(bool)		;

	static	TKCPyDebugBase	*self	()
	{
		return	debugger ;
	}
}	;


class	TKCScintilla	;

/*  The following routines must be provided by the application. We	*/
/*  could make them pure virtuals method of TKCPyDebugBase, but we	*/
/*  want to be able to invoke them even if there is no instance of that	*/
/*  class.								*/

extern	void		TKCPyDebugError
			(	const QString &,
				const QString & = QString::null,
				bool = false
			)	;

extern	bool		TKCPyCompileAndLoad
			(	TKCPyCookie	*,
				QString 	&,
				QString		&,
				QString		&,
				bool		&
			)	;

extern	void		TKCPySetupEditor     (TKTextEditor  *) ;
extern	TKCPyCookie	*TKCPyModuleToCookie (const QString &) ;
extern	PyObject	*TKCPyCookieToModule (TKCPyCookie   *) ;

extern	void		TKCPySetErrDebugged  () ;

#endif	// __TKC_PYDEBUGBASE_H
