/***************************************************************************
    file	         : value.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<errno.h>
#include	<unistd.h>

#include	<qfile.h>
#include	<qdom.h>
#include	<qlibrary.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_library.h"



#if		__KB_KDE
#include	<kapp.h>
#include	<klocale.h>
#include	<kaboutdata.h>
#include	<kcmdlineargs.h>
#endif

#define		SKELL	"value"
#define		SKELU	"Value"

static	FILE	*errfile	;


void	showValue
	(	const QString	&text,
		const QString	&format,
		const KBValue	&value
	)
{
	KBError	e	;

	printf
	(	"Value: [%s][%d][%s]->[%s]\n",
		(cchar *)text,
		value.getType()->isValid(text, e),
		(cchar *)format,
		(cchar *)value.getText(format)
	)	;
}

bool	valueString
	(	const QString	&text,
		const QString	&format
	)
{
	showValue (text, format, KBValue (text)) ;
	return	true	;
}

bool	valueFixed
	(	const QString	&text,
		const QString	&format
	)
{
	showValue (text, format, KBValue (text.toInt())) ;
	return	true	;
}

bool	valueFloat
	(	const QString	&text,
		const QString	&format
	)
{
	showValue (text, format, KBValue (text.toDouble())) ;
	return	true	;
}

bool	valueDateTime
	(	const QString	&text,
		const QString	&format
	)
{
	showValue (text, format, KBValue (text, &_kbDateTime)) ;
	return	true	;
}

bool	deformatFixed
	(	const QString	&text,
		const QString	&format
	)
{
	KBValue	value	(text, &_kbFixed, format) ;

	printf
	(	"Deformat fixed: [%s][%s]->[%s]\n",
		(cchar *)text,
		(cchar *)format,
		(cchar *)value.getRawText()
	)	;

	return	true	;
}

bool	deformatFloat
	(	const QString	&text,
		const QString	&format
	)
{
	KBValue	value	(text, &_kbFloat, format) ;
	printf
	(	"Deformat float: [%s][%s]->[%s]\n",
		(cchar *)text,
		(cchar *)format,
		(cchar *)value.getRawText()
	)	;

	return	true	;
}

bool	xmlTest
	(	const QString	&xmlName
	)
{
	QFile	xmlFile	(xmlName) ;
	if (!xmlFile.open (IO_ReadOnly))
	{
		fprintf	(errfile, "xmlFile: %s: %s\n", (cchar *)xmlName, strerror(errno)) ;
		return	false	;
	}

	QDomDocument doc	;
	if (!doc.setContent (&xmlFile))
	{
		fprintf	(errfile, "xmlFile: %s: cannot parse\n", (cchar *)xmlName) ;
		return	false	;
	}

	QDomElement  docElem	= doc.documentElement() ;
	for (QDomNode node = docElem.firstChild	() ;
			     !node  .isNull	() ;
		      node = node   .nextSibling() )
	{
		QDomElement elem = node.toElement () ;
		if (elem.isNull()) continue ;

		if (elem.nodeName() == "value")
		{
			QString	text	= elem.attribute("text"  ) ;
			QString	type	= elem.attribute("type"  ) ;
			QString	format	= elem.attribute("format") ;

			if (type == "string"  )
			{
				if (!valueString   (text, format)) return false ;
				continue ;
			}
			if (type == "fixed"   )
			{
				if (!valueFixed    (text, format)) return false ;
				continue ;
			}
			if (type == "float"   )
			{
				if (!valueFloat    (text, format)) return false ;
				continue ;
			}
			if (type == "datetime")
			{
				if (!valueDateTime (text, format)) return false ;
				continue ;
			}

			fprintf	(stderr, SKELL ": unknown value type '%s'\n", (cchar *)type) ;
			return	false ;
		}

		if (elem.nodeName() == "deformat")
		{
			QString	text	= elem.attribute("text"  ) ;
			QString	type	= elem.attribute("type"  ) ;
			QString	format	= elem.attribute("format") ;

			if (type == "fixed"   )
			{
				if (!deformatFixed (text, format)) return false ;
				continue ;
			}
			if (type == "float"   )
			{
				if (!deformatFloat (text, format)) return false ;
				continue ;
			}

			fprintf	(stderr, SKELL ": unknown deformat type '%s'\n", (cchar *)type) ;
			return	false ;
		}
	}

	return	true	;
}


int	main
	(	int	argc,
		char	*argv[]
	)
{
	cchar	*sstde	= getenv ("REKALL_SHOWSTDERR") ;

	if ((sstde == 0) || (strcmp(sstde, "YES") != 0))
	{
		freopen	("/dev/null", "w", stderr) ;
		errfile	= fopen ("/dev/tty",  "w") ;
	}
	else	errfile	= stderr ;

#if	__KB_KDE
	char *dummy[2]	;

	dummy[0] = (char *)"script" ;
	dummy[1] = 0	;

	KAboutData about ("rekall",
			  I18N_NOOP("Rekall" SKELU "Test"),
			  "0.0.0",
			  I18N_NOOP("Rekall: " SKELU " test harness"),
			  KAboutData::License_Unknown,
			  "(c) 2000,2001,2002 by theKompany.com",
			  0,
			  "http://www.rekall.a-i-s.co.uk",
			  "mike@quaking.demon.co.uk"
			 ) ;
	about.addAuthor  ("Mike Richardson", 0, "mike@quaking.demon.co.uk") ; 
	about.addAuthor  ("John Dean", 	     0, "john@rygannon.com") ; 

	KCmdLineArgs::init (2, dummy, &about) ;

	KApplication	app	;
#endif

	KBError		error	;

	if (argc != 2)
	{
		fprintf	(errfile, "usage: " SKELL " xmlfile\n") ;
		exit	(1) ;
	}

	if (!xmlTest (argv[1]))
	{	fprintf	(errfile, SKELU " test exiting: failed\n") ;
		_exit	(1) ;
	}

	fprintf	(errfile, SKELU " test exiting\n") ;
}
