#!/bin/sh

VER=2.0.1-`date +%y%m%d`
DESTDIR=/tmp/rekallqt-2.0.1
LIB2DIR=${DESTDIR}/usr/local/rekallqt/lib2

install(){

	rm -rf	${DESTDIR}
	make	DESTDIR=${DESTDIR} install

	mkdir	${LIB2DIR}
	cp -a	/lib/libgcc_*				${LIB2DIR}
	cp -a	/usr/lib/libstdc++.so.5* 		${LIB2DIR}
	cp -a	/usr/lib/libxbase* 			${LIB2DIR}
	cp -a	/usr/lib/libxbsql* 			${LIB2DIR}
	cp -a	/usr/local/qt-3.1.1-tkc/lib/libqt-mt*	${LIB2DIR}
}

package(){

	./bin/rpmlist.pl --tgz rekall ${DESTDIR} .

	for f in file.list.rekall*
	do
		here=`pwd`
		part=-`echo ${f} | sed 's/file.list.rekall.//'`

		[ "${part}" = "-full" ] && part=

		(	cd ${DESTDIR}
			echo Packing ${part} ....
			sed 's/^\///' ${here}/${f} > /tmp/${f}
			tar -czf ${here}/rekallqt${part}-${VER}.tgz -T /tmp/${f}
		)
	done
}

get(){

	type=$1
	shift

	rm -rf	 /tmp/rekallqt${type}-${VER}
	mkdir -p /tmp/rekallqt${type}-${VER}

	for file in $*
	do
		cp ${file}-${VER}.tgz /tmp/rekallqt${type}-${VER}
	done

	sed	"s/TYPE/$type/" <<'EOF' > /tmp/rekallqt${type}-${VER}/rekallqt${type}
#!/bin/sh

REKALLQT_HOME=/usr/local/rekallqt
export  LD_LIBRARY_PATH=${REKALLQT_HOME}/lib:${REKALLQT_HOME}/lib2
exec    ${REKALLQT_HOME}/bin/rekallTYPE $*

EOF

	sed 	"s/TYPE/$type/" << 'EOF' > /tmp/rekallqt${type}-${VER}/install
#!/bin/sh

here=`pwd`
for p in *.tgz
do
	(	cd /
		echo Unpacking ${p} ...
		tar -xzf ${here}/${p}
	)
done

cp rekallqtTYPE     /usr/bin

echo
echo    "*** Thank you for installing RekallQT 2.0.1 ..."
echo    "*** RekallQT command   -> rekallqtTYPE (in /usr/bin)"
echo    "*** RekallQT directory -> /usr/local/rekallqt"
echo    "*** Have fun with Rekall ...."
echo

EOF

	chmod +x /tmp/rekallqt${type}-${VER}/rekallqt${type}
	chmod +x /tmp/rekallqt${type}-${VER}/install


	cp	../RekallDemo.tgz /tmp/rekallqt${type}-${VER}

	cat	<< 'EOF' > /tmp/rekallqt${type}-${VER}/README.FIRST
This is the QT3-only build of Rekall 2.0.1, and has been tested
on the following Linux distributions:

        RedHat          7.3, 8.0, 9.0
        Suse            8.1, 8.2
        Mandrake        9.0, 9.1

However, since it includes a (licensed) build of QT 3.1.1, and
copies of other libraries on which it depends, it should run on
most recent Linux distributions. It is not necessary to have the
distribution-specific version of QT3 installed.

To install RekallQT, run the install script in this directory:

./install

This will install Rekall to the directory /usr/local/rekallqt,
and will install the command to run Rekall in /usr/bin. Depending
on the version you have downloaded, this will be:

rekallqt	Full version
rekallqtrt	Runtime version
rekallqtDemo	Demonstration version
rekallqtrtDemo	Demonstration runtime version

The pack should also include a demonstration database. This is
contained in the file "RekallDemo.tgz", which expands to a directory
"RekallDemo". Use Rekall to open the "RekallDemo.rkl" file to run the
database; go to the forms tab, expand the "!Files" entry, and
double-click "MainForm" to open up the main database menu. This
database is uses XBase/XBSQL, so you do not need a connection to a
MySQL or PostgreSQL server to run it.


Please visit http://www.rekall.a-i-s.co.uk/ for articles and
information on Rekall.
EOF

	(
		cd  /tmp
		tar -czf rekallqt${type}-${VER}.tgz rekallqt${type}-${VER}
	)
}

common="rekallqt-lib2 rekallqt-common rekallqt-docs rekallqt-drivers rekallqt-mysql rekallqt-pgsql rekallqt-python-common rekallqt-xbase"

full="$common rekallqt-libs rekallqt-python rekallqt"
fullrt="$common rekallqt-rtlibs rekallqt-python-runtime rekallqt-runtime"
demo="$common rekallqt-libs rekallqt-python rekallqt-demo"
demort="$common rekallqt-rtlibs rekallqt-python-runtime rekallqt-demo-runtime"

#install
package

get	''		${full}
get	'rt'		${fullrt}
get	'Demo'		${demo}
get	'rtDemo'	${demort}

rm -f	/tmp/file.list.rekall*
#rm -f	file.list.rekall*
