/***************************************************************************
    file	         : kb_odbc_jet.cpp
    copyright            : (C) 1999,2000,2001 by Mike Richardson
			   (C) 2000,2001 by theKompany.com
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *     This program is licensed under the terms contained in the file      *
 *     LICENSE which is contained with the source code distribution.       *
 *                                                                         *
 ***************************************************************************/


#include	"kb_odbc.h"


/*  The Jet SQL ODBC interface does not seem to be able to properly	*/
/*  report primary key columns. For the purpose of the Jet helper, we	*/
/*  assume NotNull/unique/Serial/ReadOnly as representing a primary key	*/
/*  column.								*/

const	uint	pkf	=
		KBFieldSpec::NotNull | KBFieldSpec::Unique   |
		KBFieldSpec::Serial  | KBFieldSpec::ReadOnly ;


namespace	ODBC_NS
{

/*  MSJetQryInsert							*/
/*  --------------							*/
/*  This is a wrapper class for KBODBCQryInsert, which can access the	*/
/*  MSJet last-inserted-key value.					*/

class	MSJetQryInsert : public KBODBCQryInsert
{
protected :

	SQLHSTMT	m_getHandle	;
	KBValue		m_newKey	;

public	:

	MSJetQryInsert (KBODBC *, bool, const QString &, const QString &) ;
virtual~MSJetQryInsert () ;

	virtual	bool	execute	   (uint, const KBValue *) ;
	virtual	bool	getNewKey  (const QString &, KBValue &, bool) ;
}	;

}

using	namespace	ODBC_NS ;

/*  ------------------------------------------------------------------  */

/*  MSJetQryInsert							*/
/*  MSJetQryInsert							*/
/*		: Constructor for insert query object			*/
/*  server	: KBODBC *	  : Server connection object		*/
/*  data	: bool		  : Query for data			*/
/*  query	: const QString & : Insert query			*/
/*  tabName	: const QString & : Table being updated			*/
/*  (returns)	: MSJetQryInsert  :					*/

ODBC_NS::MSJetQryInsert::MSJetQryInsert
	(	KBODBC		*server,
		bool		data,
		const QString	&query,
		const QString	&tabName
	)	
	:
	KBODBCQryInsert (server, data, query, tabName)
{
	m_getHandle = 0 ;
	if (m_stmHandle == 0) return ;

	if (!m_pServer->getStatement (m_getHandle)) return ;

	cchar	*g	= "select @@IDENTITY" ;
	long	odbcRC	;

	odbcRC	= SQLPrepare (m_getHandle, (uchar *)g, strlen(g)) ;
	if (!m_pServer->checkRCOK (m_getHandle, odbcRC, "Error preparing statement from ODBC"))
	{
		SQLFreeStmt (m_getHandle, SQL_DROP) ;
		m_getHandle = 0	    ;
		m_lError    = m_pServer->lastError() ;
		return	;
	}
}

/*  MSJetQryInsert							*/
/*  ~MSJetQryInsert							*/
/*		: Destructor for insert query object			*/
/*  (returns)	:		:					*/

ODBC_NS::MSJetQryInsert::~MSJetQryInsert ()
{
	if (m_getHandle != 0)
		SQLFreeStmt  (m_getHandle, SQL_DROP) ;
}


/*  MSJetQryInsert							*/
/*  execute	: Execute the query					*/
/*  nvals	: uint		: Number of substitution values		*/
/*  value	: KBValue *	: Substitution values			*/
/*  (returns)	: bool		: Success				*/

bool	ODBC_NS::MSJetQryInsert::execute
	(	uint		nvals,
		const KBValue	*values
	)
{
	long	odbcRC	;

	if (!KBODBCQryInsert::execute (nvals, values)) return false ;

	SQLCloseCursor	(m_getHandle) ;

	odbcRC	= SQLExecute (m_getHandle) ;
	if (!m_pServer->checkRCOK(m_getHandle, odbcRC, "Error executing ODBC insert retrieve"))
	{
		m_lError = m_pServer->lastError() ;
		return	 false	;
	}

	odbcRC = SQLFetch    (m_getHandle) ;
	if (!m_pServer->checkRCOK(m_getHandle, odbcRC, "Error fetching ODBC insert retrieve"))
	{
		m_lError = m_pServer->lastError () ;
		return	 false	;
	}

	char		buffer[32]	;
	SQLINTEGER	bufflen		;

	odbcRC = SQLGetData
		 (	m_getHandle,
			1,
			SQL_C_LONG,
			buffer,
			sizeof(buffer),
			&bufflen
		 )	;

	if (!m_pServer->checkRCOK(m_getHandle, odbcRC, "Error fetching ODBC retrieve"))
	{
		m_lError = m_pServer->lastError () ;
		return	 false	;
	}

	m_newKey = KBValue ((int)*(SQLINTEGER *)buffer) ;

	fprintf	(stderr, "MSJetQryInsert newKey [%s]\n", (cchar *)m_newKey.getRawText()) ;
	return	 true ;
}

/*  MSJetQryInsert							*/
/*  getNewKey	: Get new primary key value				*/
/*  primary	: const QString & : Key column name			*/
/*  _newKey	: KBValue &	  : New key value			*/
/*  prior	: bool		  : Pri-insert call			*/
/*  (returns)	: bool		  : Success				*/

bool	ODBC_NS::MSJetQryInsert::getNewKey
	(	const QString	&,
		KBValue		&_newKey,
		bool		prior
	)
{
	if (prior)
	{
		_newKey	 = KBValue () ;
		return	true ; 
	}

	_newKey = m_newKey ;
	return	true ;
}

static	KBSQLSelect
	*ODBCMSJetQrySelect
	(	KBODBC		*odbc,
		bool		data,
		const QString	&select,
		bool		update
	)
{
	fprintf	(stderr, "ODBC: called ODBCMSJetQrySelect\n") ;
	return	new KBODBCQrySelect (odbc, data, select, update) ;
}

static	KBSQLUpdate
	*ODBCMSJetQryUpdate
	(	KBODBC		*odbc,
		bool		data,
		const QString	&update,
		const QString	&tabName
	)
{
	fprintf	(stderr, "called ODBCMSJetQryUpdate\n") ;
	return new KBODBCQryUpdate (odbc, data, update, tabName) ;
}

static	KBSQLInsert
	*ODBCMSJetQryInsert
	(	KBODBC		*odbc,
		bool		data,
		const QString	&insert,
		const QString	&tabName
	)
{
	fprintf	(stderr, "called ODBCMSJetQryInsert\n") ;
	return new MSJetQryInsert (odbc, data, insert, tabName) ;
}

static	KBSQLDelete
	*ODBCMSJetQryDelete
	(	KBODBC		*odbc,
		bool		data,
		const QString	&_delete,
		const QString	&tabName
	)
{
	fprintf	(stderr, "called ODBCMSJetQryDelete\n") ;
	return new KBODBCQryDelete (odbc, data, _delete, tabName) ;
}


/*  KBODBC								*/
/*  ODBCMSJetDoListFields						*/
/*		: Field listing extension function			*/
/*  odbc	: KBODBC *	: Parent connection object		*/
/*  tabSpec	: KBTableSpec &	: Table specification			*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

static	bool	ODBCMSJetDoListFields
	(	ODBC_NS::KBODBC	*,
		KBTableSpec	&tabSpec,
		KBError		&
	)
{
	LITER
	(	KBFieldSpec,
		tabSpec.m_fldList,
		fSpec,

		/* Also check if the column looks appropriate as a	*/
		/* primary key, in which case flags it as such.		*/
		if ((fSpec->m_flags & pkf) == pkf)
		{
			fSpec->m_flags |= KBFieldSpec::Primary  ;
		}

		/* If a column is a primary key and it is has fixed	*/
		/* data type, then view it as the Rekall default.	*/
		if ((fSpec->m_flags & KBFieldSpec::Primary) != 0)
			if (fSpec->m_typeIntl == KB::ITFixed)
				fSpec->m_typeName = "Primary Key"  ;

		/* Check for a serial (auto_unique) column, which can	*/
		/* be retrieved after an insert.			*/
		if ((fSpec->m_flags & KBFieldSpec::Serial) != 0)
		{
			fSpec->m_flags |= KBFieldSpec::InsAvail ;
		}

	)

	return	true	;
}


/*  ------------------------------------------------------------------  */

namespace	ODBC_NS
{
struct	ODBCDriverExtn	ODBCMSJetDriverExtn =
{
	"\\*\\.mdb",

	ODBCMSJetQrySelect,
	ODBCMSJetQryUpdate,
	ODBCMSJetQryInsert,
	ODBCMSJetQryDelete,

	ODBCMSJetDoListFields,

	0,

	ODBC_FLAGS_USED
}	;
}

