/***************************************************************************
    file	         : kb_factory.cpp
    copyright            : (C) 1999,2000,2001 by Mike Richardson
			   (C) 2000,2001 by theKompany.com
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *     This program is licensed under the terms contained in the file      *
 *     LICENSE which is contained with the source code distribution.       *
 *                                                                         *
 ***************************************************************************/



#include	"kb_odbc.h"
#include	"kb_odbcadv.h"
#include	"kb_build.h"


using	namespace ODBC_NS ;



#ifndef _WIN32
KBFACTORY
(	KBODBCFactory,
	"driver_odbc"
)

KBFACTORYIMPL
(	KBODBCFactory,
	driver_odbc,
	"Rekall ODBC driver",
	"Plugin",
	"0",
	"7",
	"0"
)
#else
class	KBODBCFactory : public KBFactory
{
public:
	inline	KBODBCFactory() : KBFactory ()
	{
	}
	virtual	QObject	*create(QObject * = 0, const char *	= 0, const char * = 0, 
		const QStringList &	= QStringList());
	virtual const char* ident();
};

extern	"C"	__declspec(dllexport) void *init_libkbase_driver_odbc()			
{							
	return	new KBODBCFactory;				
}							
#endif


QObject	*KBODBCFactory::create
	(	QObject		  *parent,
		cchar		  *object,
		cchar		  *,
		const QStringList &
	)
{
	if ((parent != 0) && !parent->inherits ("QWidget"))
	{
		fprintf	(stderr, "KBODBCFactory: parent does not inherit QWidget\n") ;
		return	0  ;
	}

	if (strcmp (object, "driver"  ) == 0) return new KBODBC () ;

	if (strcmp (object, "advanced") == 0) return new KBODBCAdvanced () ;

	return	0 ;
}

cchar	*KBODBCFactory::ident ()
{
	return	__KB_BUILD_IDENT	;
}
