/***************************************************************************
    file	         : kb_xbadvanced.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<qtabwidget.h>

#ifndef		_WIN32
#include	"kb_xbadvanced.moc"
#else
#include	"kb_xbadvanced.h"
#endif



/*  KBXBAdvanced							*/
/*  KBXBAdvanced: Constructor for XBase advanced options object		*/
/*  (returns)	: KBXBAdvanced	:					*/

KBXBAdvanced::KBXBAdvanced  ()
	:
	KBDBAdvanced ("xbase")
{
	fprintf	(stderr, "KBXBAdvanced::KBXBAdvanced  ()\n") ;
	m_packOnClose    = false ;
	m_caseSensitive  = false ;
	m_mapExpressions = false ;
//	m_useWildcard	 = false ;
	m_goSlow	 = false ;
}

/*  KBXBAdvanced							*/
/*  ~KBXBAdvanced: Destructor for PgSQL advanced options object		*/
/*  (returns)	 :		:					*/

KBXBAdvanced::~KBXBAdvanced ()
{
}

/*  KBXBAdvanced							*/
/*  load	: Load settings from DOM element			*/
/*  driverElem	: QDomElement &	: DOM element				*/
/*  (returns)	: void		:					*/

void	KBXBAdvanced::load
	(	const QDomElement &driverElem
	)
{
	m_packOnClose    = driverElem.attribute ("packonclose"   ).toUInt() ;
	m_caseSensitive  = driverElem.attribute ("casesensitive" ).toUInt() ;
	m_mapExpressions = driverElem.attribute ("mapexpressions").toUInt() ;
	m_goSlow	 = driverElem.attribute ("goslow"	 ).toUInt() ;
//	m_useWildcard	 = driverElem.attribute ("usewildcard"   ).toUInt() ;

}

/*  KBXBAdvanced							*/
/*  save	: Save settings from DOM element			*/
/*  driverElem	: QDomElement &	: DOM element				*/
/*  (returns)	: void		:					*/

void	KBXBAdvanced::save
	(	QDomElement	&driverElem
	)
{
	driverElem.setAttribute ("packonclose",    m_packOnClose   ) ;
	driverElem.setAttribute ("casesensitive",  m_caseSensitive ) ;
	driverElem.setAttribute ("mapexpressions", m_mapExpressions) ;
	driverElem.setAttribute ("goslow",	   m_goSlow	   ) ;
//	driverElem.setAttribute ("usewildcard",    m_useWildcard   ) ;
}

/*  KBXBAdvanced							*/
/*  setupDialog	: Set up advanced options dialog			*/
/*  tabWidget	: QTabWidget *	: Tab widget to which to attach pages	*/
/*  (returns)	: void		:					*/

void	KBXBAdvanced::setupDialog
	(	QTabWidget	*tabWidget
	)
{
	fprintf	(stderr, "KBXBAdvanced::setupDialog  ()\n") ;

	QWidget		*advWidget	= new QWidget	  (tabWidget) ;
	QVBoxLayout	*advLayout	= new QVBoxLayout (advWidget) ;

	tabWidget->addTab (advWidget, "XBase/XBSQL") ;

	m_cbPackOnClose	   = new QCheckBox (advWidget) ;
	m_cbCaseSensitive  = new QCheckBox (advWidget) ;
	m_cbMapExpressions = new QCheckBox (advWidget) ;
//	m_cbUseWildcard    = new QCheckBox (advWidget) ;
	m_cbGoSlow	   = new QCheckBox (advWidget) ;

	m_cbPackOnClose   ->setText 	(TR("Pack database files on close")) ;
	m_cbCaseSensitive ->setText 	(TR("Case sensitive matching"	  )) ;
	m_cbMapExpressions->setText 	(TR("Wrap names with [...]"	  )) ;
//	m_cbUseWildcard   ->setText 	(TR("Use wildcard matching"  	  )) ;
	m_cbGoSlow	  ->setText 	(TR("Minimise memory usage"	  )) ;

	m_cbPackOnClose   ->setChecked	(m_packOnClose   ) ;
	m_cbCaseSensitive ->setChecked	(m_caseSensitive ) ;
	m_cbMapExpressions->setChecked	(m_mapExpressions) ;
//	m_cbUseWildcard   ->setChecked	(m_useWildcard   ) ;
	m_cbGoSlow	  ->setChecked	(m_goSlow        ) ;

	advLayout->addWidget (m_cbPackOnClose   ) ;
	advLayout->addWidget (m_cbCaseSensitive ) ;
	advLayout->addWidget (m_cbMapExpressions) ;
//	advLayout->addWidget (m_cbUseWildcard   ) ;
	advLayout->addWidget (m_cbGoSlow	) ;

	advLayout->addStretch() ;
}

/*  KBXBAdvanced							*/
/*  saveDialog	: Save results from dialog				*/
/*  (returns)	: void		:					*/

void	KBXBAdvanced::saveDialog ()
{
	m_packOnClose    = m_cbPackOnClose   ->isChecked() ;
	m_caseSensitive  = m_cbCaseSensitive ->isChecked() ;
	m_mapExpressions = m_cbMapExpressions->isChecked() ;
//	m_useWildcard    = m_cbUseWildcard   ->isChecked() ;
	m_goSlow	 = m_cbGoSlow	     ->isChecked() ;
}

/*  KBXBAdvanced							*/
/*  copy	: Replicate this object					*/
/*  (returns)	: KBXBAdvanced * : Replicated object			*/

KBDBAdvanced
	*KBXBAdvanced::copy ()
{
	KBXBAdvanced	*copy	= new KBXBAdvanced () ;

	copy->m_packOnClose	= m_packOnClose    ;
	copy->m_caseSensitive	= m_caseSensitive  ;
	copy->m_mapExpressions	= m_mapExpressions ;
//	copy->m_useWildcard	= m_useWildcard    ;
	copy->m_goSlow		= m_goSlow	   ;

	return	copy	;
}
