#!/usr/bin/python

import	sys
import	string
import	re
import	xml.dom.minidom

from	time			import time

from	xml.dom.ext.reader.Sax2	import FromXmlStream
from	xml.xpath		import Evaluate
from	xml.xslt.Processor	import Processor
from	xml.dom.ext		import Print
from	xml.dom.ext		import PrettyPrint

def adjustCode (code) :

    lines1 = string.split (code, "\n")
    lines2 = []
    prefix = ""
    for line in lines1 :
        match = re.match ("^( *)def", line)
        if match :
            prefix = match.group(1)
            break

    for line in lines1 :
        lines2.append (re.sub ("^" + prefix, "    ", line))

    return string.join (lines2, "\n")


print	 time(), ": Parsing DocBook/XML source ....."
source	 = open ('index.docbook', 'r')
doc	 = FromXmlStream (source)

print	 time(), ": Location tagged sections ....."
s2list	 = Evaluate ('//sect2[starts-with(@id, "help_")]', doc)
s3list	 = Evaluate ('//sect3[starts-with(@id, "help_")]', doc)
palist	 = Evaluate ('//para [starts-with(@id, "help_")]', doc)
pclist	 = Evaluate ('//programlisting', doc)

for e in pclist :
    e.firstChild.data = adjustCode (e.firstChild.data)


def myGetAttribute (node, name) :

    for a in node.attributes :
        if   a.name == name : return a.value

    return ""


def addPageLink (name, node, tgt) :

    link = doc.createElement (name)
    link.setAttribute ("tag", myGetAttribute(tgt, "id")[5:])
    title = tgt.getElementsByTagName ("title")
    if len(title) > 0 :
        link.setAttribute ("title", title[0].firstChild.data)
    node.appendChild (link)

def generatePage (help, prv, nxt) :

    id     = myGetAttribute(help, "id")[5:]
    legend = myGetAttribute(help, "legend")

    if prv : addPageLink ("previous", help, prv)
    if nxt : addPageLink ("next",     help, nxt)

    text = xsltproc.runNode(help)
    text = re.sub ("<\\?.*\\?>", "", text)
    text = re.sub ("(\\w+)='([^']*)'", "\\1=\"\\2\"", text)
    file = open ("help/" + id + ".qt", "w")
    file.write (text)
    file.write ("\n")
    file.close ()

def generatePages (list) :

    for i in range (0, len(list)) :
        prv  = None
        nxt  = None
        if i > 0             : prv = list[i-1]
        if i < len(list) - 1 : nxt = list[i+1]
        generatePage (list[i], prv, nxt)

print	time(), ": Creating style sheet processor ...."
xsltproc = Processor ()
xsltproc.appendStylesheetUri ("help.xsl")

print	time(), ": Processing sect2 elements ...."
generatePages (s2list)

print	time(), ": Processing sect3 elements ...."
generatePages (s3list)

print	time(), ": Processing para elements ...."
generatePages (palist)

print	time(), ": Done"

