/***************************************************************************
    file	         : kb_dbdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qiconset.h>
#include	<qlayout.h>
#include	<qvbox.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_listitem.h"
#include	"kb_serverdlg.h"
#include	"kb_script.h"
#include	"kb_scriptlist.h"
#include	"kb_viewer.h"
#include	"kb_notifier.h"
#include	"kb_dom.h"
#include	"kb_build.h"
#include	"kb_prompt.h"

#ifndef 	_WIN32
#include	"kb_dbdlg.moc"
#else
#include	"kb_dbdlg.h"
#endif

#include	"tk_print.h"
#include	"tk_icons.h"


/*  KBDBaseDlg								*/
/*  KBDBaseDlg	: Constructor for main database dialog			*/
/*  parent	: QWidget *	  : Parent widget			*/
/*  app		: KBaseApp *	  : Application root			*/
/*  dbName	: const QString&  : Database name			*/
/*  create	: bool		  : True to create new database		*/
/*  gui		: KBaseGUI *	  : GUI for this viewer			*/
/*  (returns)	: KBDBaseDlg	  :					*/

KBDBaseDlg::KBDBaseDlg
	(	QWidget		*parent,
		KBaseApp	*app,
		const QString	&dname,
		bool		create,
		KBaseGUI	*gui
	)
	:
	QWidget		(parent),
	kbaseApp	(app),
	dirWatch	(2000),
	m_gui		(gui)
{
	QSize	minSize	(0, 0) ;

#if	__KB_EMBEDDED
	m_window	= new QTabWidget   (this) ;
#else
	m_window	= new KBListWidget (this) ;
#endif

	QVBoxLayout *l  = new QVBoxLayout  (this) ;
	l->addWidget (m_window);

	fileDict  .setAutoDelete (true) ;
	scriptDict.setAutoDelete (true) ;

	/* Create a database information structure appropriate to the	*/
	/* database, and then create the server dialog, which always	*/
	/* appears under the first tab. Then load the rest of the parts	*/
	dbInfo	   = new KBDBInfoData   (dname) ;
	dbInfo->init (create) ;

	serverDlg  = new KBServerDlg    (this,  dbInfo, gui) ;
	minSize	   = minSize.expandedTo (serverDlg->minimumSizeHint()) ;

	addPage   (serverDlg, TR("Servers"), QString::null, false) ;
	loadParts (minSize) ;

	allParts.append (TR("Graphics")) ;

#if	! __KB_EMBEDDED
	allParts.append (TR("Printers")) ;

	KBLocation::registerType
	(	"print",
		"prn",
		"Printer",
		0
	)	;
#endif
	KBLocation::registerType
	(	"graphic",
		QString::null,
		"Graphic",
		0
	)	;

//	setMinimumSize (minSize + QSize(34, 4)) ;
	setMinimumSize (m_window->minimumSizeHint()) ;

	connect
	(	&dirWatch,
		SIGNAL (dirty   (const QString &)),
		SLOT   (dirDirty(const QString &))
	)	;
	connect
	(	m_window,
		SIGNAL(currentChanged(QWidget *)),
		SLOT  (pageChanged   (QWidget *))
	)	;

	dirWatch.addDir (dbInfo->getDBPath ()) ;
}

/*  KBDBaseDlg								*/
/*  ~KBDBaseDlg	: Destructor for main database dialog			*/
/*  (returns)	:		:					*/

KBDBaseDlg::~KBDBaseDlg ()
{
	fileDict  .clear() ;
	scriptDict.clear() ;

	delete	serverDlg  ;
	delete	dbInfo	   ;
}

/*  KBDBaseDlg								*/
/*  dirDirty	: Signal that directory has changed			*/
/*  dname	: const QString & : Directory name			*/
/*  (returns)	: void		  :					*/

void	KBDBaseDlg::dirDirty
	(	const QString	&
	)
{
	KBLocation location (dbInfo, "all", KBLocation::m_pFile, "") ;

	DITER
	(	KBFileList,
		fileDict,
		list,
		list->objChange(location)
	)
	DITER
	(	KBScriptList,
		scriptDict,
		lang,
		lang->objChange(location)
	)
}

/*  KBDBaseDlg								*/
/*  autoStart	: Check for auto-start forms				*/
/*  autoLoc	: KBLocation &	: Return started location if any	*/
/*  (returns)	: bool		:					*/

bool	KBDBaseDlg::autoStart
	(	KBLocation	&autoLoc
	)
{
	return	serverDlg->autoStart (autoLoc) ;
}

/*  KBDBaseDlg								*/
/*  addPage	: Add page to tabber					*/
/*  page	: QWidget *	  : Page to add				*/
/*  label	: const QString & : Tab text				*/
/*  icon	: const QString & : Icon name				*/
/*  addToList	: bool		  : Add to allPages list		*/
/*  (returns)	: void		  :					*/

void	KBDBaseDlg::addPage
	(	QWidget		*page,
		const QString	&label,
		const QString	&icon,
		bool		addToList
	)
{
#if	__KB_EMBEDDED
	QTabWidget ::addPage (page, label) ;
#else
	m_window->addPage
	(	page,
		label,
		getSmallIcon (icon.isEmpty() ? QString("rekall") : icon)
	)	;
#endif

	if (addToList)
		allParts.append	(label) ;
}

void	KBDBaseDlg::pageChanged
	(	QWidget		*page
	)
{
	m_gui->setEnabled ("KB_showRawSQL", page == serverDlg) ;
}

/*  KBDBaseDlg								*/
/*  showObjects	: Show quick objects dialog				*/
/*  (returns)	: void		:					*/

void	KBDBaseDlg::showObjects ()
{
	KBQuickDlg	   qDlg	  (dbInfo, allParts, fileDict, scriptDict) ;
	KBQuickDlg::Option option = (KBQuickDlg::Option)qDlg.exec() ;

	if (option == KBQuickDlg::Cancelled) return ;

	QString	type	;
	QString	server	;
	QString	object	;
	QString	extn	;

	qDlg.getResults (type, server, object) ;

//	fprintf
//	(	stderr,
//		"showObjects(%s,%s,%s)\n",
//		(cchar *)type,
//		(cchar *)server,
//		(cchar *)object
//	)	;

#if	! __KB_EMBEDDED
	/* Printers are handled specially, since there is no associated	*/
	/* part.							*/
	if (type == TR("Printers"))
	{
		type	= "print" ;
		extn	= ""	  ;
	}
	else
#endif

	/* Graphics are also handled specially, again there is no part	*/
	/* associated with them ....					*/
	if (type == TR("Graphics"))
	{
		int dotp = object.findRev ('.') ;

		if (dotp >= 0)
		{	extn	= object.mid  (dotp + 1) ;
			object	= object.left (dotp) ;
		}
		else	extn	= ""  ;

		type	= "graphic" ;
	}
	/* ... while all other objects types are handled via their part	*/
	/* with just a slight difference for scripts.			*/
	else
	{
		KBFileList	*fList	= fileDict  .find (type) ;
		KBScriptList	*sList	= scriptDict.find (type) ;
		KBFileList	*oList	;

		if	(fList != 0) oList = fList ;
		else if (sList != 0) oList = sList ;
		else		     oList = 0	   ;

		if (oList == 0)
		{
			fprintf
			(	stderr,
				"KBDBDlg::showObjects type [%s] not found\n",
				(cchar *)type
			)	;
			return	;
		}

		type	= oList->getTabType     () ;
		extn	= oList->getDocExtension() ;
	}

	/* Construct the location for the object, then check first for	*/
	/* deletion, which is the same for all object types (printers	*/
	/* and graphics included).					*/
	KBLocation  locn 
	(	dbInfo,
		type,
		server,
		object,
		extn
	)	;

	KBError	   	error	;
	QDict<QString>	dummy	;

	if (option == KBQuickDlg::Delete)
	{
		if (TKMessageBox::questionYesNo
			(	0,
				QString	(TR("Definitely delete %1 on server %2"))
					.arg (object)
					.arg (server),
				QString	(TR("Delete Object ..."))
			)
			!= TKMessageBox::Yes) return ;

		if (!locn.remove (error)) error.DISPLAY() ;

		KBNotifier::self()->nObjectChanged (locn) ;
		return	;
	}

#if	! __KB_EMBEDDED
	/* Create and open are handled specially for printers ....	*/
	if (type == "print")
	{
		showPrinters (option, locn) ;
		return	;
	}
#endif
#if	! __KB_RUNTIME
	/* ... and similarly for graphics.				*/
	if (type == "graphic")
	{
		showGraphics (option, locn) ;
		return	;
	}
#endif

	if (option == KBQuickDlg::Create)
	{
		if (!kbaseApp->newObject (locn, error))
			error.DISPLAY() ;
		return	;
	}

	if (kbaseApp->openObject
		(	locn,
			KB::ShowAsData,
			dummy,
			error,
			KBValue(),
			0
		) == KB::ShowRCError) error.DISPLAY () ;
}

void	KBDBaseDlg::showRawSQL ()
{
	serverDlg->showRawSQL (kbaseApp) ;
}

#if	! __KB_RUNTIME

void	KBDBaseDlg::dumpDatabase ()
{
	serverDlg->dumpDatabase (kbaseApp) ;
}

void	KBDBaseDlg::loadDatabase ()
{
	serverDlg->loadDatabase (kbaseApp) ;
}


/*  KBDBaseDlg								*/
/*  showGraphics: Handle graphics configuration				*/
/*  option	: KBQuickDlg::Option	: Quick dialog option		*/
/*  location	: KBLocation &		: Graphic location		*/
/*  (returns)	: void			:				*/

void	KBDBaseDlg::showGraphics
	(	KBQuickDlg::Option	option,
		KBLocation		&location
	)
{
	KBError	error	;
	QString	name	;

	/* First case is request to create a new graphic. This is just	*/
	/* treated as a load into the system.				*/
	if (option == KBQuickDlg::Create)
	{
		extern	bool	importImage (KBDBInfo *, const QString &, QString &, KBError &) ;

		if (!importImage
			(	location.dbInfo,
				location.docLocn,
				name,
				error
			))
		{
			error.DISPLAY() ;
			return	;
		}

		return	;
	}

	TKMessageBox::sorry
	(	0,
		QString(TR("Edit option not available for graphics")),
		QString(TR("Edit graphic ..."))
	)	;
}
#endif

#if	! __KB_EMBEDDED

/*  KBDBaseDlg								*/
/*  showPrinters: Handle printer configuration				*/
/*  option	: KBQuickDlg::Option	: Quick dialog option		*/
/*  location	: KBLocation &		: Printer location		*/
/*  (returns)	: void			:				*/

void	KBDBaseDlg::showPrinters
	(	KBQuickDlg::Option	option,
		KBLocation		&location
	)
{
	KBError	error ;

	/* First case is request to create a new printer definition.	*/
	/* Run the printer setup, and if the user OKs then prompt for	*/
	/* a location and save.						*/
	if (option == KBQuickDlg::Create)
	{
		TKPrinter printer (TKPrinter::ResPrinter) ;
		if (!printer.setup()) return ;

		QString	name 	;
		QString	locn	= location.docLocn ;

		if (!doPromptSave
			(	TR("Save printer as ..."),
				TR("Enter printer name" ),
				name,
				locn,
				dbInfo,
				true
			))
			return	;

		QDomDocument	pXML	("printer") ;
		QDomElement	root	;

		pXML.appendChild
		(	pXML.createProcessingInstruction
			(	"xml",
				"version=\"1.0\" encoding=\"UTF-8\""
		)	)	;

		pXML   .appendChild (root = pXML.createElement ("printer")) ;
		printer.saveSettings(root) ;

		if (!location.save (locn, name, pXML.toString(), error))
			error.DISPLAY() ;

		return	;
	}

	/* Other case must be edit. In this case load the specified	*/
	/* printer definition into a printer object.			*/
	QString		_doc	= location.contents (error) ;
	if (_doc.isNull())
	{	error.DISPLAY() ;
		return	;
	}

	QDomDocument	pXML	;
	pXML.setContent	(_doc)	;
	QDomElement	root	= pXML.documentElement () ;
	if (root.isNull())
	{
		KBError::EError
		(	TR("Printer definition has no root element"),
			QString::null,
			__ERRLOCN
		)	;
		return	;
	}

	TKPrinter printer (TKPrinter::ResPrinter) ;
	printer.loadSettings  (root) ;

	/* Run the printer setup dialog, and give up if the used does	*/
	/* not OK it. Otherwise, we can just save the settings back	*/
	/* into the XML document and save it as above.			*/
	if (!printer.setup()) return ;
	printer.saveSettings  (root) ;

	QString	name 	= location.docName ;
	QString	locn	= location.docLocn ;

	if (!doPromptSave
		(	TR("Save printer as ..."),
			TR("Enter printer name" ),
			name,
			locn,
			dbInfo,
			true
		))
		return	;

	if ((name != location.docName) || (locn != location.docLocn))
	{
		KBLocation check (dbInfo, "print", locn, name, "") ;
		if (check.exists())
			if (TKMessageBox::questionYesNo
				(	0,
					QString(TR("Printer %1 on server %2 exists, overwrite?"))
						.arg(name)
						.arg(locn),
					TR("Overwrite printer ...")
				)
				!= TKMessageBox::Yes) return ;
	}

	if (!location.save (locn, name, pXML.toString(), error))
		error.DISPLAY() ;
}
#endif

/*  ------------------------------------------------------------------  */

static	QDict<QString>	identStrings	;

void	KBDBaseDlg::addIdentString
	(	const QString	&part,
		cchar		*ident
	)
{
	identStrings.setAutoDelete (true) ;
	identStrings.replace	   (part, new QString(ident)) ;
}

QString	KBDBaseDlg::getIdentStrings ()
{
	QString			res  ;
	QDictIterator<QString>	iter (identStrings) ;

	while (iter.current() != 0)
	{
		res	+= QString("<tr><td>Part</td><td><b>%1</b></td><td><nobr>%2</nobr></td></tr>")
				  .arg( iter.currentKey())
				  .arg(*iter.current   ()) ;

		iter	+= 1 ;
	}

	return	res	;
}


