/***************************************************************************
    file	         : kb_filelist.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_FILELIST_H
#define	_KB_FILELIST_H

#include	<qlistview.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_listitem.h"
#include	"kb_conductor.h"
#include	"kb_serverinfo.h"

#include	"libapp_exports.h"


/*  KBFileList								*/
/*  ----------								*/
/*  Widget used to list a subset of the files in the database		*/

class	LIBAPP_API KBFileList : public QListView, protected KBPlayer
{
	Q_OBJECT


protected :

	QWidget		*m_parent   ;	/* Notional parent		*/
	KBDBInfo	*m_dbInfo   ;	/* Database information		*/
	cchar		*m_newtext  ;	/* Text for create new item	*/
	cchar		*m_icon	    ;	/* Icon for contents		*/
	QString		m_tabType   ;	/* Type being listed		*/
	bool		m_wizard    ;	/* Wizard support for creation	*/

	KBListItem	*m_curItem  ;	/* Currently selected item	*/

#if	! __KB_RUNTIME
	virtual	bool	playerPerform	(const QString &, const QStringList &, KBError &) ;
#endif

	bool		canOperate   	(KBLocation    &, cchar *) ;
	bool		canOperate   	(KBListItem    *, cchar *) ;

	void		rename		(KBListItem    *) ;
	void		delobj		(KBListItem    *) ;

	bool		itemToLocation	(KBListItem    *, KBLocation &) ;

	virtual	void	reloadServer	(KBServerItem  *) ;
	virtual	void	showObjectAs	(KBListItem    *, KB::ShowAs  ) ;
	virtual	void	createByWizard	(KBListItem    *) ;

	virtual	void	showServerMenu	()	;
	virtual	void	showCreateMenu	()	;
	virtual	void	showObjectMenu	()	;

protected slots :

	virtual	void	showAsData	()	;
	virtual	void	showAsDesign	()	;
	virtual	void	showDefault	(QListViewItem *) ;
	virtual	void	showMenu	(QListViewItem *, const QPoint &, int) ;
	virtual	void	saveToFile	()	;
	virtual	void	copyToServer	()	;
	virtual	void	reloadServer 	()	;

	void		serverChanged	(const KBLocation &) ;

public	 slots :

	void		objChange	(const KBLocation &) ;

public	:

	KBFileList  (QWidget *, KBDBInfo *, cchar *,
					    cchar *,
					    cchar *,
					    cchar *,
					    cchar * = 0, cchar * = 0) ;
       ~KBFileList  () ;

	virtual	QStringList	getObjectNames	(KBServerInfo *) ;
	virtual	QString		getDocExtension	()	;
	virtual	QString		getTabType	()	;

	inline	void		enableWizard	()
	{
		m_wizard	= true	;
	}

	friend	class	KBServerItem ;
	friend	class	KBObjectItem ;
}	;

extern	LIBAPP_API	KB::ShowAs	showAsCode (const QString &, KB::ShowAs) ;

#endif	// _KB_FILELIST_H
