/***************************************************************************
    file	         : kb_partwidget.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qapp.h>
#include 	<qpointarray.h>

#if		__KB_KDE
#include	<kdeversion.h>
#include	<kstatusbar.h>
#include	<kaccelmanager.h>
#endif

#if		__KB_TKC
#include	<qstatusbar.h>
#endif

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_gui.h"
#include	"kb_metrics.h"

#include	"kb_appptr.h"
#include	"kb_callback.h"

#ifndef 	_WIN32
#include	"kb_partwidget.moc"
#else
#include	"kb_partwidget.h"
#endif

#include	"kb_part.h"
#include	"tk_icons.h"


/*  KBSDIMainWindow							*/
/*  KBSDIMainWindow							*/
/*		: Top-level mode window constructor			*/
/*  part	: KBasePart *	  : Associated part			*/
/*  modal	: bool		  : Runs as modal			*/
/*  (returns)	: KBSDIMainWindow :					*/

KBSDIMainWindow::KBSDIMainWindow
	(	KBasePart	*part,
		bool		modal
	)
	:
	TKMainWindow	(0, 0),
	m_part		(part),
	m_modal		(modal)
{
	setXMLFile ("rekallui.null") ;
	createGUI  (0)	;
	setIcon	   (getSmallIcon ("rekall")) ;

	m_inModalLoop = false ;
}

/*  KBSDIMainWindow							*/
/*  KBSDIMainWindow							*/
/*		: Top-level mode window destructor			*/
/*  (returns)	:		:					*/

KBSDIMainWindow::~KBSDIMainWindow ()
{
	fprintf
	(	stderr,
		"KBSDIMainWindow::~KBSDIMainWindow: inModalLoop=%d\n",
		m_inModalLoop
	)	;

	if (m_inModalLoop)
	{	qApp->exit_loop ()    ;
		m_inModalLoop = false ;
	}
}

/*  KBSDIMainWindow							*/
/*  closeEvent	: Catch window close event				*/
/*  e		: QCloseEvent *	: Associated event			*/
/*  (returns)	: void		:					*/

void	KBSDIMainWindow::closeEvent
	(	QCloseEvent	*
	)
{
	fprintf
	(	stderr,
		"KBSDIMainWindow::closeEvent: inModalLoop=%d part=[%p]\n",
		m_inModalLoop,
		(void *)m_part
	)	;

	/* Treat this exactly as if the user had hit an action that	*/
	/* triggered the part close slot.				*/
	if (m_part) m_part->slotClose () ;
}

/*  KBSDIMainWindow							*/
/*  exitModal	: Exit from modal loop					*/
/*  (returns)	: void		:					*/

void	KBSDIMainWindow::exitModal ()
{
	if (m_modal && m_inModalLoop)
	{
		qApp->exit_loop ()    ;
		m_inModalLoop = false ;
	}
}

/*  KBSDIMainWindow							*/
/*  action	: Get GUI action					*/
/*  element	: QDomElement &	: GUI element				*/
/*  (returns)	: KAction *	: Action or null if not found		*/

#if	__KB_KDE
KAction
#endif
#if	__KB_TKC
TKAction
#endif
	*KBSDIMainWindow::action
	(	const QDomElement &element
	)
	const
{
	KBaseGUI *gui = m_part->getCurrentGUI() ;

//	fprintf	(stderr, "KBSDIMainWindow::action(%s) -> %08x\n",
//			 (cchar *)element.attribute("name"), (uint)gui) ;

	/* We should not get called before a GUI is set, but check just	*/
	/* in case.							*/
	if (gui != 0)
	{
		TKAction *action = gui->getAction (element, m_part->getLocalGUISpec()) ;
		if (action != 0) return action->getAction () ;
	}

	return	TKMainWindow::action (element) ;
}

/*  KBSDIMainWindow							*/
/*  resetGUI	: Reset the GUI						*/
/*  (returns)	: void		:					*/

void	KBSDIMainWindow::resetGUI ()
{
	/* This method is called when the part changes its GUI on the	*/
	/* fly.								*/
	createGUI (m_part) ;

	KBaseGUI *gui = m_part->getCurrentGUI() ;
	if (gui->hasStatusBar())
		statusBar()->show() ;
	else	statusBar()->hide() ;
}


/*  KBSDIMainWindow							*/
/*  goModal	: Run window maybe in modal loop			*/
/*  showMode	: KB::ShowMode	: Display mode				*/
/*  (returns)	: KB::ShowRC	: Display result			*/

KB::ShowRC
	KBSDIMainWindow::goModal
	(	KB::ShowMode	showMode
	)
{
	fprintf
	(	stderr,
		"KBSDIMainWindow::goModal: modal=%d showMode=%d inModalLoop=%d\n",
		m_modal,
		showMode,
		m_inModalLoop
	)	;

	if (m_inModalLoop)
		return	KB::ShowRCModal	;

	/* If the window is to be show modal and requested automatic	*/
	/* selection, *or* requested modal, then execute modaly.	*/
	if ((m_modal && (showMode == KB::ShowAuto)) || (showMode == KB::ShowModal))
	{
		extern	void	qt_enter_modal (QWidget *) ;
		extern	void	qt_leave_modal (QWidget *) ;

		fprintf		(stderr, "KBSDIMainWindow::goModal: enter loop\n") ;
		setModal	() ;
		setActiveWindow	() ;

		qt_enter_modal  (this) ;

		m_inModalLoop = true   ;
		qApp	->enter_loop() ;

		m_inModalLoop = false  ;
		qt_leave_modal  (this) ;

		clearModal	() ;
		fprintf		(stderr, "KBSDIMainWindow::goModal: leave loop\n") ;

		return	KB::ShowRCModal;
	}

	return	KB::ShowRCOK	;
}


/*  ------------------------------------------------------------------  */

/*  KBPartWidget								*/
/*  KBPartWidget: Constructor for display widget			*/
/*  parent	: QWidget *	    : Parent widget			*/
/*  part	: KBasePart *	    : Associated part			*/
/*  flags	: int		    : Widget flags			*/
/*  mainWin	: KBSDIMainWindow * : Main window in SDI mode		*/
/*  (returns)	: KBPartWidget	    :					*/

KBPartWidget::KBPartWidget
	(	QWidget	   	*parent,
		KBasePart 	*part,
		int	   	flags,
		KBSDIMainWindow	*mainWin
	)
	:
	QWidget		(parent,  0, flags),
	m_part		(part),
	m_mainWin	(mainWin)
{
#if	__KB_KDE
#if	KDE_VERSION >= KDE_MAKE_VERSION(3,4,0)
	KAcceleratorManager::setNoAccel (this) ;
#endif
#endif

#if	! __KB_EMBEDDED
#if	QT_VERSION < 300
	if (m_mainWin == 0)
	{
		QPointArray a	  ;
		a.setPoints (3, 1,12, 12,1, 12,12 ) ;
		QRegion	    r (a) ;

		m_sizeGrip = new QSizeGrip (this) ;
		m_sizeGrip->setMask (r) ;
	}
	else
#endif
		m_sizeGrip = 0 ;
#endif
	setFocusPolicy (QWidget::ClickFocus) ;
	m_connected  = false ;

	fprintf	(stderr, "KBPartWidget:: KBPartWidget [%p] created\n", (void *)this) ;
}


/*  KBPartWidget							*/
/*  ~KBPartWidget: Constructor for display widget			*/
/*  (returns)	:		:					*/

KBPartWidget::~KBPartWidget ()
{
	fprintf	(stderr, "KBPartWidget::~KBPartWidget [%p] created\n", (void *)this) ;
}

/*  KBPartWidget							*/
/*  setGUI	: Set GUI at application				*/
/*  gui		: KBaseGUI *	: GUI to set				*/
/*  (returns)	: void		:					*/

void	KBPartWidget::setGUI
	(	KBaseGUI	*gui
	)
{
	if (m_mainWin)
	{
		m_mainWin->resetGUI () ;
		return	;
	}

	if (!m_connected && (m_part->manager() != 0))
	{
		connect
		(	this,
			SIGNAL(changeGUI(TKPart *)),
			m_part->manager()->parent(),
			SLOT  (createGUI(TKPart *))
		) ;

		m_connected = true ;
	}

	if (m_connected)
		emit changeGUI (gui == 0 ? (TKPart*)0 : (TKPart*)m_part) ;
}


/*  KBPartWidget							*/
/*  resize	: Resize widget						*/
/*  w		: int		: New width				*/
/*  h		: int		: New height				*/
/*  mtb		: bool		: Has menu and tool bars		*/
/*  sb		: bool		: Has status bar			*/
/*  (returns)	: void		:					*/

void	KBPartWidget::resize
	(	int		w,
		int		h,
		bool		mtb,
		bool		sb
	)
{
	/* HACK WARNING!						*/
	/* If someone can tell me how to set KMainWindow geometry so	*/
	/* that the client widget gets a specified size, please tell me	*/
	/* This hack adds in the menu and toolbar heights, plus a bit	*/
	/* more to make it work.					*/
	if (m_mainWin)
	{
		int	mbh = KBMetrics::getMenuBarHeight   () ;
		int	tbh = KBMetrics::getToolBarHeight   () ;
		int	sbh = KBMetrics::getStatusBarHeight () ;

//		fprintf
//		(	stderr,
//			"KBPartWidget::resize: (%d,%d) + (%d,%d) -> (%d,%d)\n",
//			w,
//			h,
//			mbh,
//			tbh,
//			w + 8,
//			h + mbh + tbh + 8
//		)	;

		if (mtb) h += mbh + tbh ;
		if (sb ) h += sbh ;

		m_mainWin->resize (w + 8, h + 8) ;
		return	;
	}

	QWidget::resize (w + 8, h + 8);
}

/*  KBPartWidget							*/
/*  showMaximized: Show window maximized				*/
/*  (returns)	 : void		:					*/

void	KBPartWidget::showMaximized ()
{
	if (m_mainWin)
	{	m_mainWin->showMaximized() ;
		return	;
	}

	showMaximized ();
}


/*  KBPartWidget							*/
/*  size	: Get widget size					*/
/*  (returns)	: QSize		: Widget size				*/

QSize	KBPartWidget::size ()
{
	return	QWidget::size() ;
}

/*  KBPartWidget							*/
/*  resizeEvent	: Handle window resize					*/
/*  e		: QResizeEvent *: Resize event				*/
/*  (returns)	: void		:					*/

void	KBPartWidget::resizeEvent
	(	QResizeEvent	*e
	)
{
#if	! __KB_EMBEDDED
	if (m_sizeGrip != 0)
	{
		m_sizeGrip->adjustSize	() ;
		m_sizeGrip->raise	() ;
		m_sizeGrip->show	() ;

		m_sizeGrip->move
		(	rect().width () - m_sizeGrip->rect().width (),
			rect().height() - m_sizeGrip->rect().height()
		)	;
	}
#endif
	/* The size event is passed to the part so that the child can	*/
	/* forward it to its real top-level widget.			*/
	m_part->resizeEvent (e) ;
}

/*  KBPartWidget							*/
/*  closeEvent	: Handle a close event					*/
/*  e		: QCloseEvent *	: The close event			*/
/*  (returns)	: void		:					*/

void	KBPartWidget::closeEvent
	(	QCloseEvent	*
	)
{
	/* This is passed to the which will indicate whether or not it	*/
	/* is actually prepared to close.				*/
	fprintf
	(	stderr,
		"KBPartWidget::closeEvent: part=[%p]\n",
		(void *)m_part
	)	;

	if (m_part) m_part->slotClose () ;
}

/*  KBPartWidget							*/
/*  show	: Show containing widget				*/
/*  reset	: bool		: Reset geometry			*/
/*  showMode	: KB::ShowMode	: Modal mode				*/
/*  (returns)	: KB::ShowRC	: Display result			*/


KB::ShowRC
	KBPartWidget::show
	(	bool		reset,
		KB::ShowMode	showMode
	)
{
	QWidget::show () ;

	if (m_mainWin)
	{
		m_mainWin->show	 (reset) ;
		m_mainWin->raise () ;

		return	m_mainWin->goModal (showMode) ;
	}

	return	KB::ShowRCOK	;
}

/*  KBPartWidget							*/
/*  hide	: Hide containing widget				*/
/*  (returns)	: void		:					*/

void	KBPartWidget::hide ()
{
	if (m_mainWin) m_mainWin->hide() ;
	QWidget::hide () ;
}

/*  KBPartWidget							*/
/*  mainWidget	: Get main widget					*/
/*  (returns)	: QWidget *	: Main widget				*/

QWidget	*KBPartWidget::mainWidget ()
{
	return	m_mainWin ? (QWidget *)m_mainWin : (QWidget *)this ;
}

QStatusBar
	*KBPartWidget::statusBar ()
{
	return	m_mainWin ? m_mainWin->statusBar() : 0 ;
}

/*  KBPartWidget								*/
/*  setCaption	: Set widget caption					*/
/*  caption	: const QString & : Caption text			*/
/*  (returns)	: void		:					*/

void	KBPartWidget::setCaption
	(	const QString	&caption
	)
{
	QWidget::setCaption (caption) ;
	if (m_mainWin) m_mainWin->setCaption(caption) ;

	KBAppPtr::getCallback()->alterPart (m_part) ;
}

void	KBPartWidget::showMenuToolBars
	(	bool	showMenuBar,
		bool	showToolBar
	)
{
	if (m_mainWin)
		m_mainWin->showMenuToolBars (showMenuBar, showToolBar) ;
}
