/***************************************************************************
    file	         : kb_viewer.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef  __KB_VIEWER_H
#define  __KB_VIEWER_H


#include	"kb_objbase.h"
#include	"kb_part.h"

#include	"libapp_exports.h"

/*  KBViewer								*/
/*  --------								*/
/*  This class is used as a base for viewers for objects like forms	*/
/*  and queries, whose definitions are stored textually either in files	*/
/*  in the database directory or in objects table entry.		*/

class	LIBAPP_API KBViewer : public KBasePart
{
	Q_OBJECT

protected :

	KBObjBase	*m_objBase	;

	void		setCaption	(const QString &) ;

signals	:

	void	objChanged	(const QString &, const QString &) ;

public	slots :

	void		showAs		(int)		 ;
	virtual	void	showAs		(KB::ShowAs) = 0 ;

public	:
		 KBViewer  (KBObjBase *, QWidget *, int flags, bool = false) ;
	virtual	~KBViewer  () ;

	inline	KBLocation &getLocation ()
	{
		return	m_objBase->getLocation() ;
	}
}	;


extern	void	setFocusAtRow (KBaseGUI *, bool, uint, uint, bool) ;

#endif // __KB_VIEWER_H
