/***************************************************************************
    file	         : kb_libloader_kde.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/


#ifndef		__KB_LIBLOADER_KDE
#define		__KB_LIBLOADER_KDE

#if		__KB_KDE

#include	<klibloader.h>
#include	<klibloader.h>
#include	<kinstance.h>
#include	<kaboutdata.h>

#include	<kparts/factory.h>

/*  If __KB_RUNTIME is not defined then it can be arbitrarily set to	*/
/*  zero (false). It will be set whenever the KBINITFUNC is actually	*/
/*  invoked in a runtime build.						*/

#if		!defined(__KB_RUNTIME)
#define		__KB_RUNTIME	0
#endif

#if		__KB_RUNTIME
#define		KBINITFUNC(part)	init_libkbasert_##part
#else
#define		KBINITFUNC(part)	init_libkbase_##part
#endif

/*  ------------------------------------------------------------------  */

/*  KBLibrary								*/
/*  ---------								*/
/*  Library wrapper class. In this case is simply wraps the standard	*/
/*  KDE KLibrary class.							*/

class	KBLibrary
{
	KLibrary	*m_library	;

public	:

	inline	KBLibrary
		(	KLibrary	*library
		)
		:
		m_library	(library)
	{
	}

	inline	void	*factory ()
	{
		return	m_library->factory () ;
	}
}	;


/*  KBLibLoader								*/
/*  -----------								*/
/*  Library loader class. For KDE builds we just wrap KLibLoader and	*/
/*  use that to do all the work.					*/

class	KBLibLoader : public KLibLoader
{
public	:

	KBLibrary	*getLibrary		(const char *) ;
	KBLibrary	*getGlobalLibrary	(const char *) ;

	static	KBLibLoader	*self	() ;
}	;


/*  ------------------------------------------------------------------  */

/*  CREATE_DEFN								*/
/*  -----------								*/
/*  Macro to generate the library creation method definition. This is	*/
/*  that same in all cases.						*/

#define	CREATE_DEFN	\
	virtual	QObject	*create						\
		(	QObject *		= 0,			\
			const char *		= 0, 			\
			const char *		= 0, 			\
			const QStringList &	= QStringList()		\
		)	;

#define	IDENT_DEFN	\
	virtual	const char *ident	() ;

/*  ------------------------------------------------------------------  */

/*  KBPartFactory							*/
/*  -------------							*/
/*  Rekall part factory. Wraps KParts::Factory, although it is not	*/
/*  obvious the Rekall parts can actually be used anywhere but in	*/
/*  Rekall. Still, it gives access to the KDE library support.		*/

class	KBPartFactory : public KParts::Factory
{
public	:

	inline	KBPartFactory
		(	QObject		*parent	= 0,
			const char	*name	= 0
		)
		:
		KParts::Factory (parent, name)
	{
	}
	virtual~KBPartFactory () ;

	virtual	KParts::Part
			*createPartObject
		(	QWidget *		,
			const char *		,
			QObject *		,
			const char *		,
			const char *		,
			const QStringList &	
		)	;

	CREATE_DEFN
	IDENT_DEFN
}	;

/*  KBFactory								*/
/*  ---------								*/
/*  Factory for Rekall plugins that are not parts. Under KDE is is	*/
/*  just a wrapper around KLibFactory.					*/

class	KBFactory : public KLibFactory
{
public	:

	inline	KBFactory
		(	QObject		*parent	= 0,
			const char	*name	= 0
		)
		:
		KLibFactory (parent, name)
	{
	}
	virtual~KBFactory () ;

	virtual QObject
			*createObject
		(	QObject *		,
			const char *		,
			const char *		,
			const QStringList &
		)	;

	CREATE_DEFN
	IDENT_DEFN
}	;

/*  ------------------------------------------------------------------	*/

/*  We now define macros that generate the right stuff, so that we can	*/
/*  handle QLibrary/KDE differences inside macros.			*/

/*  KBPARTFACTORY							*/
/*  -------------							*/
/*  This is used to generate factory classes for components which are	*/
/*  notionally KDE parts, ie., which display things, although it is not	*/
/*  obvious that Rekall's parts can be used in any general way.		*/

#define	KBPARTFACTORY(className,instName)					\
	class	className : public KBPartFactory			\
	{								\
	public	:							\
		inline	className					\
			(	QObject		*parent = 0,		\
				const char	*name   = 0		\
			)						\
			:						\
			KBPartFactory (parent, name)			\
		{							\
			if (s_instance == 0)				\
				s_instance = new KInstance (instName) ;	\
		}							\
		CREATE_DEFN						\
		IDENT_DEFN						\
	static	KInstance	*s_instance	;			\
	static	KInstance	*instance ()	{ return s_instance ; }	\
	}	;

/*  KBFACTORY								*/
/*  ---------								*/
/*  This is used to generate factory classes for components which can	*/
/*  never be a KDE part.						*/

#define	KBFACTORY(className,instName)					\
	class	className : public KBFactory				\
	{								\
	public	:							\
		inline	className					\
			(	QObject		*parent = 0,		\
				const char	*name   = 0		\
			)						\
			:						\
			KBFactory (parent, name)			\
		{							\
			if (s_instance == 0)				\
				s_instance = new KInstance (instName) ;	\
		}							\
		CREATE_DEFN						\
		IDENT_DEFN						\
	static	KInstance	*s_instance	;			\
	static	KInstance	*instance ()	{ return s_instance ; }	\
	}	;

/*  KBFACTORYIMPL							*/
/*  -------------							*/
/*  This macro is used to generate the implementation code which is not	*/
/*  inline'd in the class definition					*/

#define	KBFACTORYIMPL(className,libName,i1,i2,i3,i4,i5)			\
	extern	"C"							\
	{	void	*KBINITFUNC(libName) ()				\
		{							\
			return	new className ;				\
		}							\
	}								\
	KInstance	*className::s_instance = 0 ;



#endif	// __KB_KDE
#endif	// __KB_LIBLOADER_KDE
