/***************************************************************************
    file	         : kb_shared.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	"kb_shared.h"


/*  KBShared								*/
/*  KBShared	: Constructor for shared data base class		*/
/*  (returns)	: KBShared						*/


KBShared::KBShared ()
	:
	count	(1)
{
}

/*  KBShared								*/
/*  KBShared	: Constructor for shared data base class		*/
/*  locked	: bool		: Shared object is locked		*/
/*  (returns)	: KBShared						*/


KBShared::KBShared
	(	bool	locked
	)
	:
	count	(locked ? 0x7fffffff : 0)
{
}

/*  KBShared								*/
/*  ~KBShared	: Destructor for shared data base class			*/
/*  (returns)	:		:					*/

KBShared::~KBShared ()
{
	if ((count != 0) && (count != 0x7fffffff))
		fprintf	(stderr, "KBShared::~KBShared: c=%d\n", count) ;
}

/*  KBShared								*/
/*  ref		: Add a reference					*/
/*  (returns)	: void		:					*/

void	KBShared::ref ()
{
	if (count != 0x7fffffff) count += 1 ;
}

/*  KBShared								*/
/*  deref	: Remove a reference					*/
/*  (returns)	: void		:					*/

void	KBShared::deref ()
{
	/* This is where we differ from QShared; when the count goes to	*/
	/* zero then delete ourselves.					*/
	if (count != 0x7fffffff)
		if ((count -= 1) == 0) delete this ;
}
