/***************************************************************************
    file	         : kb_sshtunnel.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<signal.h>
#include	<sys/types.h>
#include	<sys/wait.h>

#include	<qlayout.h>
#include	<qstring.h>
#include	<qregexp.h>
#include	<qfile.h>
#include	<qtextstream.h>


#include	"kb_sshtunnel.moc"


/*  KBSSHTunnel								*/
/*  KBSSHTunnel	: Constructor for tunnel connection dialog		*/
/*  target	: const QString & : Target system			*/
/*  pid		: pid_t		  : Ssh command pid			*/
/*  port	: int		  : Redirection port			*/
/*  error	: KBError &	  : Error return			*/
/*  (returns)	: KBSSHTunnel	  :					*/

KBSSHTunnel::KBSSHTunnel
	(	const QString	&target,
		pid_t		pid,
		int		port,
		KBError		&error
	)
	:
	QDialog		(0, "ssh", true),
	m_pid		(pid),
	m_port		(port),
	m_error		(error),
	m_progress	(this),
	m_bCancel	(this)
{
	QVBoxLayout	*layMain = new QVBoxLayout (this) ;
	layMain->addWidget (&m_progress) ;

	QHBoxLayout	*layButt = new QHBoxLayout (layMain) ;
	layButt->addStretch() ;
	layButt->addWidget (&m_bCancel ) ;

	m_bCancel.setText  (TR("Cancel")) ;
	connect (&m_bCancel, SIGNAL(clicked()), SLOT(slotClickCancel())) ;
	connect	(&m_timer,   SIGNAL(timeout()), SLOT(slotTimerEvent ())) ;

	setCaption (QString(TR("Opening SSH Tunnel to %1")).arg(target)) ;

	layMain->setMargin (8) ;
	layMain->setSpacing(4) ;
	layButt->setMargin (8) ;
	layButt->setSpacing(4) ;

	m_progress.setTotalSteps   (10 ) ;
	m_progress.setMinimumWidth (380) ;
	m_timer.start (1000) ;
	m_count	= 0 ;
}

/*  KBSSHTunnel								*/
/*  slotClickCancel							*/
/*		: Used cancels						*/
/*  (returns)	: void		:					*/

void	KBSSHTunnel::slotClickCancel ()
{
	m_timer.stop() ;
	m_error	= KBError
		  (	KBError::Error,
			TR("User cancelled connection"),
			QString::null,
			__ERRLOCN
		  )	;
	done	(0)	;
}

/*  KBSSHTunnel								*/
/*  slotTimerEvent							*/
/*		: Interval timer fires					*/
/*  (returns)	: void		:					*/

void	KBSSHTunnel::slotTimerEvent ()
{
	fprintf
	(	stderr,
		"KBSSHTunnel::slotTimerTick: try %d for port %d\n",
		m_count,
		m_port
	)	;

	/* First see if the tunnel command still exists. It will go	*/
	/* away if, for instance, it could not open a connection to the	*/
	/* target system, or authentication failed.			*/
	if (kill (m_pid, 0) < 0)
	{
		m_error	= KBError
			  (	KBError::Error,
				TR("SSH tunnel command has exited"),
				QString::null,
				__ERRLOCN
			  )	;
		waitpid	  (m_pid, 0, WNOHANG) ;
		m_timer.stop  () ;
		done (0)  ;
		return	  ;
	}

	/* Next scan the list of TCP ports to see if something is	*/
	/* listening on the required one. We decode the contents of	*/
	/* "/proc/net/tcp" to determin this.				*/
	QFile		tcp	("/proc/net/tcp") ;
	tcp.open (IO_ReadOnly) ;
	QTextStream	input	(&tcp) ;

	while (!input.eof())
	{
		QString	    line = input.readLine() ;
		QStringList bits = QStringList::split (QRegExp("[ :]+"), line) ;
		int	    port = bits[2].toLong(0, 16) ;

		if (port == m_port)
		{
			m_timer.stop  () ;
			tcp    .close () ;
			done	(1) ;
			return	;
		}
	}

	/* Ho hum, not available yet. Update the progress display and	*/
	/* wait for the next timer event.				*/
	tcp.close () ;
	m_count += 1 ;

	m_progress.setProgress (m_count % 10) ;
}

