/***************************************************************************
    file	         : elt.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>
#include	<setjmp.h>
#include	<std.h>

#include	"eli.h"
#include	"interp.h"
#include	"syn.h"
#include	"code.h"

LVAR	VALUE	zero	;
LVAR	VALUE	one	;

ELShared	*space	;


GFUNC	void	KBELError
	(	const char	*msg,
		const char	*where,
		unsigned int	lno
	)
{
	fprintf	(stderr, "%s: %s, %d\n", msg, where, lno) ;
}


GFUNC	int	main
	(	int	argc,
		char	*argv[]
	)
{
extern	MC	el_lib1sp[] ;

	fprintf	   (stderr, "elt: entered\n") ;
	el_init    (0x8000, 512) ;
	fprintf	   (stderr, "elt: el_init done\n") ;
	el_initlib (el_lib1sp  ) ;
	fprintf	   (stderr, "elt: el_initlib done\n") ;

	zero.tag	= &tagNUM ;
	zero.val.num	= 0	  ;
	one.tag		= &tagNUM ;
	one.val.num	= 1	  ;

	printf	("[[[%d/%d]]]\n", sizeof(zero.val.shared), sizeof(void *)) ;

	argc	-= 1 ;
	argv	+= 1 ;

	for ( ; argc > 0 ; argc -= 1, argv += 1)
		if (el_loadfile (*argv))
			fprintf	(stderr, "el_loadfile OK on %s\n", *argv) ;
		else	fprintf	(stderr, "el_loadfile failed on %s\n", *argv) ;

#ifdef	_SPACE
	while (space != 0)
	{
		printf	("%08x: %5d %d\n", (unsigned int)space, space->count, space->freed) ;
		space	= space->next ;
	}
#endif
	return	0 ;
}
