/***************************************************************************
    file	         : kb_attrpair.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_node.h"
#include	"kb_nodemonitor.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_object.h"
#include	"kb_docroot.h"
#include	"kb_nodereg.h"
#include	"kb_attr.h"
#include	"kb_attrpair.h"
#include	"kb_dictionary.h"


KBAttrPair::KBAttrPair
	(	KBNode			*node,
		cchar			*name1,
		cchar			*name2,
		const QDict<QString>	&aList,
		uint			nflags
	)
	:
	KBAttr	(node, String, name1, aList, nflags),
	name2	(name2)
{
	QString	*v = aList.find (name2) ;

	if (v == 0)
		value2	= "" ;
	else	value2	= *v ;
}

KBAttrPair::KBAttrPair
	(	KBNode			*node,
		cchar			*name1,
		cchar			*value1,
		cchar			*name2,
		cchar			*value2,
		uint			nflags
	)
	:
	KBAttr	(node, String, name1, value1, nflags),
	name2	(name2),
	value2	(value2)
{
}

KBAttrPair::KBAttrPair
	(	KBNode			*node,
		cchar			*name1,
		cchar			*name2,
		KBNode			*srce,
		uint			nflags
	)
	:
	KBAttr	(node, name1, srce, nflags),
	name2	(name2)
{
	const KBAttr *extant ;

	if ((extant = srce->getAttr (name1)) != 0)
		value2	= ((KBAttrPair *)extant)->value2 ;
}


KBAttrPair::~KBAttrPair ()
{
}


KBAttr	*KBAttrPair::replicate
	(	KBNode  	*owner
	)
{
	return	new KBAttrPair (owner, name, name2, value, value2, nFlags) ;
}


/*  KBAttrPair								*/
/*  printAttr	: Print attribute					*/
/*  attrText	: QString &	: Result text for attribute output	*/
/*  node	: QString &	: Result text for node output		*/
/*  indent	: int		: Indent depth for node output		*/
/*  (returns)	: void		:					*/

void	KBAttrPair::printAttr
 	(	QString 	&attrText,
		QString		&,
		int
	)
{
	if ((getFlags() & (KAF_HIDDEN|KAF_USER)) == 0)
	{
		addAttrText (attrText, name,  value ) ;
		addAttrText (attrText, name2, value2) ;
	}
}


void	KBAttrPair::setValue
  	(	cchar 		*
	)
{
	KBError::EFault
	(	"Called KBAttrPair::setValue(cchar *)",
		QString::null,
		__ERRLOCN
	)	;
}


void	KBAttrPair::setValue
  	(	const QString 	&
	)
{
	KBError::EFault
	(	"Called KBAttrPair::setValue(const QString &)",
		QString::null,
		__ERRLOCN
	)	;
}


QString	KBAttrPair::getValue ()
{
	KBError::EFault
	(	"Called KBAttrPair::getValue()",
		QString::null,
		__ERRLOCN
	)	;
	return	QString::null	;
}


void	KBAttrPair::setValue
	(	cchar		*_value1,
	 	cchar		*_value2
	)
{
	value	= _value1 ;
	value2	= _value2 ;
}

void	KBAttrPair::setValue
	(	const QString	&_value1,
		const QString	&_value2
	)
{
	value	= _value1 ;
	value2	= _value2 ;
}

QString	KBAttrPair::getValue1 ()
{
	return	substitute (value) ;
	return	value	;
}

QString	KBAttrPair::getValue2 ()
{
	return	substitute (value2) ;
}
