/***************************************************************************
    file	         : kb_copybase.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<qdom.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_dom.h"
#include	"kb_copybase.h"
#include	"kb_copyexec.h"



/*  KBCopyBase								*/
/*  KBCopyBase	: Constructor for copier base class			*/
/*  (returns)	: KBCopyBase	:					*/

KBCopyBase::~KBCopyBase ()
{
}

/*  KBCopyBase								*/
/*  execute	: Execute copy						*/
/*  dest	: KBCopyBase *	: Destination copier			*/
/*  values	: KBValue *	: Value vector				*/
/*  nCols	: int		: Number of columns			*/
/*  exec	: KBCopyExec *	: Copy executor				*/
/*  (returns)	: int		: Number of rows or negative on error	*/

int	KBCopyBase::execute
	(	KBCopyBase	*dest,
		KBValue		*values,
		int		nCols,
		KBCopyExec	*exec
	)
{
	int	nRows	= 0 ;
	int	aCols	;
	bool	ok	;

	while ((aCols = getRow (values, nCols, ok)) >= 0)
	{
		for (int idx = aCols ; idx < nCols ; idx += 1)
			values[idx] = KBValue() ;

		if (!dest->putRow (values, aCols))
		{
			m_lError = dest->lastError () ;
			return	 -1	;
		}

		nRows	+= 1	;

		if (exec != 0)
			if (exec->showProgress (nRows))
			{
				m_lError = KBError
					   (	KBError::Warning,
					  	TR("User cancelled copy"),
					  	QString::null,
					  	__ERRLOCN
					   )	;
				return	 -1	;
			}

	}

	return	ok ? nRows : -1 ;
}
