/***************************************************************************
    file	         : kb_field.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_FIELD_H
#define	_KB_FIELD_H

#include	"libkbase_exports.h"

#include 	<qregexp.h>

#include	"kb_classes.h"
#include	"kb_item.h"
#include	"kb_qtfield.h"
#include	"kb_attralign.h"


/*  KBField								*/
/*  -----------								*/
/*  This class is used to represent a KBaseField element in the XML	*/
/*  form description. Note that it may map onto more than one actual	*/
/*  field.								*/

class	KBField : public KBItem
{
	KBAttrStr	fgcolor	    ;	/* Foreground (text) colour	*/
	KBAttrStr	bgcolor	    ;	/* Background colour		*/
	KBAttrStr	font	    ;	/* Report font			*/
	KBAttrBool	passwd	    ;	/* Treat as a password field	*/
	KBAttrBool	nullOK	    ;	/* Is empty field OK		*/
	KBAttrBool	m_emptyNull ;	/* Treat empty fields as null	*/
	KBAttrStr	eValid	    ;	/* Validity regular expression 	*/
	KBAttrBool	ignCase	    ;	/* Ignore case			*/
	KBAttrStr	mask	    ;	/* Input mask			*/
	KBAttrStr	format	    ;	/* Format string		*/
	KBAttrBool	m_deformat  ;	/* Deformat on save		*/
	KBAttrAlign	align	    ;	/* Alignment			*/
	KBAttrBool	supress	    ;	/* Supress repeats		*/
	KBAttrStr	helper	    ;	/* Input helper			*/
	KBAttrBool	morph	    ;
	KBEvent		onChange    ;

	QRegExp		m_rValid    ;	/* Compiled validity pattern	*/
	
	KBReport	*report	    ;	/* Embedding report		*/
	KBValue		lastVal	    ;	/* Last row value		*/

	bool			doCheckValid	(const QString &, bool) ;

protected :

	virtual	KBControl	*makeCtrl	(uint)	  ;
	virtual	bool		isMorphing	()	  ;

#if	! __KB_RUNTIME
	virtual	bool		propertyDlg	(cchar *) ;
#endif

public	:

	KBField	(KBNode  *, const QDict<QString> &, bool * = 0) ;
	KBField (KBNode  *, KBField *) ;
virtual~KBField	() ;

	virtual	KBNode		*replicate	(KBNode *) ;
	virtual	KBValue		getReportValue	(bool, bool = false) ;
	virtual	KBValue		getValue	(uint) ;

	virtual	void		showAs		(KB::ShowAs) ;

	bool			checkValid	(const QString &, bool) ;
	void			userChange	(uint) ;

	inline	QString	getFormat ()
	{
		return	format.getValue    () ;
	}
	inline	int	getAlign  ()
	{
		return	align .getIntValue () ;
	}
	inline	QString	getHelper ()
	{
		return	helper.getValue    () ;
	}
	inline	bool	getDeFormat ()
	{
		return	m_deformat.getBoolValue() ;
	}
	inline	bool	isPasswd  ()
	{
		return	passwd.getBoolValue() ;
	}

	virtual	bool		doLeave		(uint) ;
	virtual	void		doSearch	() ;
}	;


#if	! __KB_RUNTIME
extern	LIBKBASE_API	bool	fieldPropDlg
			(	KBField		*,
				cchar		*,
				QList<KBAttr>	&,
				cchar		* = 0
			)	;
#endif
#endif	// _KB_FIELD_H
