/***************************************************************************
    file	         : kb_macrodebdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qpixmap.h>

#include	"kb_classes.h"
#include	"kb_macro.h"
#include	"kb_macrodef.h"
#include	"kb_macrodebdlg.h"
#include	"kb_object.h"

#include	"tk_icons.h"



class	KBMacroDebugItem : public QListViewItem
{
	KBMacroInstr	*m_instruction	;
	bool		m_current	;

public	:

	KBMacroDebugItem
	(	QListView	*,
		QListViewItem	*,
		KBMacroInstr	*
	)	;

	inline	void	setCurrent
		(	KBMacroInstr	*instr
		)
	{
		m_current = instr == m_instruction ;
	}

	virtual	void	paintCell
	(	QPainter		*,
		const QColorGroup	&,
		int, int, int
	)	;
}	;

KBMacroDebugItem::KBMacroDebugItem
	(	QListView	*parent,
		QListViewItem	*after,
		KBMacroInstr	*instruction
	)
	:
	QListViewItem
	(	parent,
		after,
		instruction->action (),
		instruction->comment()
	),
	m_instruction (instruction)
{
	m_current = false ;
}

void	KBMacroDebugItem::paintCell
	(	QPainter	  *p,
		const QColorGroup &cg1,
		int		  column,
		int		  width,
		int		  align
	)
{
	if (m_current)
	{
		QColorGroup cg2 (cg1) ;
		cg2.setColor (QColorGroup::Text, Qt::red) ;
		QListViewItem::paintCell (p, cg2, column, width, align) ;
	}
	else	QListViewItem::paintCell (p, cg1, column, width, align) ;
}

/*  KBMacroDebugDlg							*/
/*  KBMacroDebugDlg							*/
/*		: Constructor for macro debug dialog			*/
/*  instr	: KBMacroInstr *  : Instruction				*/
/*  invoker	: KBNode *	  : Who invoked the macro		*/
/*  (returns)	: KBMacroDebugDlg :					*/

KBMacroDebugDlg::KBMacroDebugDlg
	(	const QList<KBMacroInstr>	&instructions,
		KBNode				*invoker
	)
	:
	_KBDialog	("Macro Instruction", true, "KBMacroDebigDlg"),
	m_split		(Qt::Vertical, this),
	m_macroList	(&m_split),
	m_state		(&m_split),
	m_bOK		(this, "ok"	),
	m_bCancel	(this, "cancel"	),
	m_invoker	(invoker)
{
	QVBoxLayout	*layMain = new QVBoxLayout (this) ;
	layMain->addWidget (&m_split  ) ;

	QHBoxLayout	*layButt = new QHBoxLayout (layMain) ;
	layButt->addStretch() ;
	layButt->addWidget (&m_bOK    ) ;
	layButt->addWidget (&m_bCancel) ;

	m_bOK	 .setText (TR("Continue")) ;
	m_bCancel.setText (TR("Abort"	)) ;

	/* Set up the macro instruction list. This does not change	*/
	/* during execution of the macro so we can set the list up when	*/
	/* the dialog is created.					*/
	m_macroList.setRootIsDecorated (true) ;
	m_macroList.setSorting(-1) ;

	m_macroList.addColumn (TR("Macro/Argument"), 120) ;
	m_macroList.addColumn (TR("Comment/Value" ), 330) ;

	QListViewItem	*after	= 0 ;

	LITER
	(	KBMacroInstr,
		instructions,
		instr,

		QListViewItem *arg   = 0 ;
		KBMacroDef    *def   = KBMacroDef::getMacroDef (instr->action()) ;

		after	= new KBMacroDebugItem (&m_macroList, after, instr) ;

		for (uint ano = 0 ; ano < def->m_args.count() ; ano += 1)
			arg	= new QListViewItem
				  (	after,
					arg,
					def->m_args[ano].m_arg,
					instr->args()[ano]
				  )	;
	)

	/* Set up the state list. This is loaded on each breakpoint as	*/
	/* it changes from instruction to instruction.			*/
	m_state    .addColumn (TR("Object"),   120) ;
	m_state    .addColumn (TR("Name"  ),   330) ;

	connect
	(	&m_macroList,
		SIGNAL(clicked(QListViewItem *)),
		SLOT  (clicked(QListViewItem *))
	)	;
}

/*  KBMacroDebugDlg							*/
/*  exec	: Execute dialog					*/
/*  instr	: KBMacroInstr *	   : Next instruction		*/
/*  nodes	: QMap<QString,KBNode *> & : Nodes map			*/
/*  (returns)	: int			   : Completion code		*/

int	KBMacroDebugDlg::exec
	(	KBMacroInstr			*instr,
		const QMap<QString,KBNode *>	&nodes
	)
{
	QPixmap	mark = getSmallIcon ("rekall") ;
	QPixmap none ;

	for (QListViewItem *child  = m_macroList.firstChild() ;
			    child != 0 ;
			    child  = child->nextSibling())
	{
		((KBMacroDebugItem *)child)->setCurrent (instr) ;
	}

	while (m_state.firstChild() != 0)
		delete	m_state.firstChild() ;

	QListViewItem	*after	= 0 ;

	if (m_invoker != 0)
	{
		QString	name	= TR("Unknown") ;

		if (m_invoker->isObject() != 0)
			name	= m_invoker->isObject()->getName() ;

		if (name.isEmpty())
			name	= TR("Unnamed") ;

		after	= new QListViewItem (&m_state, "[Invoker]", name) ;
	}

	QMapConstIterator<QString,KBNode *> iter ;
	for (iter = nodes.begin() ; iter != nodes.end() ; iter++)
	{
		QString	type	= iter.key   () ;
		KBNode	*node	= iter.data  () ;
		QString	name	= TR("Unknown") ;

		if (type.left(2) == "KB")
			type	= type.mid(2).lower() ;

		if (node->isObject() != 0)
			name	= TR(node->isObject()->getName()) ;

		if (name.isEmpty())
			name	= TR("Unnamed") ;

		after	= new QListViewItem (&m_state, after, type, name) ;
	}

	return	_KBDialog::exec	() ;
}
