/***************************************************************************
    file	         : kb_noobjdlg.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef 	_WIN32
#include 	"kb_noobjdlg.moc"
#else
#include 	"kb_noobjdlg.h"
#endif

#include	"kb_object.h"
#include	"kb_config.h"


/*  KBObjTreeObject							*/
/*  KBObjTreeObject							*/
/*		: Constructor for object entry 				*/
/*  parent	: QListView *	   : Parent list view			*/
/*  object	: KBObject *	   : Associated object			*/
/*  (returns)	: KBObjTreeObject :					*/

KBObjTreeObject::KBObjTreeObject
	(	QListView	*parent,
		KBObject	*object
	)
	:
	QListViewItem	(parent, object->getElement(), object->getName()),
	m_object	(object)
{
	setExpandable	(true)	;
	m_expanded =	false	;
	m_start	   =	false	;
}


/*  KBObjTreeObject							*/
/*  KBObjTreeObject							*/
/*		: Constructor for object entry 				*/
/*  parent	: QListViewItem *  : Parent list view item		*/
/*  object	: KBObject *	   : Associated object			*/
/*  (returns)	: KBObjTreeObject :					*/

KBObjTreeObject::KBObjTreeObject
	(	QListViewItem	*parent,
		KBObject	*object
	)
	:
	QListViewItem	(parent, object->getElement(), object->getName()),
	m_object	(object)
{
	setExpandable	(true)	;
	m_expanded =	false	;
	m_start	   =	false	;
}

/*  KBObjTreeObject							*/
/*  setOpen	: Open or close the item				*/
/*  open	: bool		: True to open				*/
/*  (returns)	: void		:					*/

void	KBObjTreeObject::setOpen
	(	bool		open
	)
{
	/* If we are opening and there are no known chilren then now	*/
	/* is the time to do it. If there really no children then make	*/
	/* the item non-expandable.					*/
	if (open && (childCount() == 0))
	{
		const QList<KBNode> &childList = m_object->getChildren() ;

		TITER
		(	Object,
			childList,
			child,
			new KBObjTreeObject (this, child)
		)

		if (childCount() == 0) setExpandable (false) ;
	}

	QListViewItem::setOpen (open) ;
}

void	KBObjTreeObject::paintCell
	(	QPainter	  *p,
		const QColorGroup &cg1,
		int		  column,
		int		  width,
		int		  align
	)
{
	if (m_start)
	{
		QColorGroup cg2 (cg1) ;
		cg2.setColor (QColorGroup::Text, Qt::red) ;
		QListViewItem::paintCell (p, cg2, column, width, align) ;
	}
	else	QListViewItem::paintCell (p, cg1, column, width, align) ;
}


/*  KBObjTreeObject							*/
/*  expandToObject							*/
/*		: Expand tree above specified object			*/
/*  listView	: QListView *	    : Parent list view			*/
/*  object	: KBObject *	    : Object in question		*/
/*  (returns)	: KBObjTreeObject * : List view item for the object	*/

KBObjTreeObject
	*KBObjTreeObject::expandToObject
	(	QListView	*listView,
		KBObject	*object,
		KBObject	*root
	)
{
	/* See if there is a parent object above this one. If there	*/
	/* is, the expand to that object, then add an entry for each	*/
	/* child of said parent; as we do so, make a note of the	*/
	/* item for this object.					*/
	KBNode	 *pNode	  = object->getParent () ;
	KBObject *pObject = pNode == 0 ? 0 : pNode->isObject() ;

	if ((object != root) && (pObject != 0))
	{
		KBObjTreeObject	*pItem	= expandToObject (listView, pObject, root) ;
		QListViewItem	*oItem	= 0 ;

		if (!pItem->expanded())
		{

			const QList<KBNode> &childList = pObject->getChildren() ;

			TITER
			(	Object,
				childList,
				child,
				new KBObjTreeObject (pItem, child)
			)

			pItem->setExpanded() ;
		}

		for (QListViewItem *lvi  = pItem->firstChild () ;
				    lvi != 0 ;
				    lvi  = lvi  ->nextSibling())
			if (((KBObjTreeObject *)lvi)->object() == object)
			{
				oItem	= lvi	;
				break	;
			}

		/* Paranoia! We should never fail to find this object	*/
		/* amongst its parents children, but .....		*/
		if (oItem == 0)
			oItem	= new KBObjTreeObject (pItem, object) ;

		pItem->setOpen (true) ;
		return	(KBObjTreeObject *)oItem ;
	}

	if (listView->firstChild() != 0)
		return	(KBObjTreeObject *)listView->firstChild() ;

	return	new KBObjTreeObject (listView, object) ;
}



/*  ------------------------------------------------------------------  */

/*  KBNoObjDlg								*/
/*  KBNoObjDlg	: Constructor for object-not-found dialog		*/
/*  object	: KBObject *	: Object from which search started	*/
/*  string	: QString	: Search string				*/
/*  (returns)	: KBNoObjDlg	:					*/

KBNoObjDlg::KBNoObjDlg
	(	KBObject	*object,
		QString		string
	)
	:
	_KBDialog	(TR("Named control not found ..."), true),
	m_error		(this),
	m_objTree	(this),
	m_bFail		(this),
	m_bContinue	(this)
{
	m_selected	= 0 ;

	m_layMain	= new QVBoxLayout (this) ;
	m_layMain   ->addWidget (&m_error)	 ;
	m_layMain   ->addWidget (&m_objTree)	 ;
	m_layButtons	= new QHBoxLayout (m_layMain) ;
	m_layButtons->addStretch()		 ;
	m_layButtons->addWidget (&m_bContinue)	 ;
	m_layButtons->addWidget (&m_bFail    )	 ;

	m_bFail	   .setText 	(TR("&Fail"    ));
	m_bContinue.setText 	(TR("&Continue"));

	m_objTree  .addColumn  (TR("Object"), 200) ;
	m_objTree  .addColumn  (TR("Name"  ),  80) ;
	m_objTree  .setMinimumWidth    ( 280)	;
	m_objTree  .setRootIsDecorated (true)	;

	m_error	   .setText    (string)		;

	connect
	(	&m_objTree,
		SIGNAL(clicked	    (QListViewItem *)), SLOT(slotObjClicked ())
	)	;
	connect
	(	&m_objTree,
		SIGNAL(doubleClicked(QListViewItem *)), SLOT(slotObjSelected())
	)	;
	connect
	(	&m_objTree,
		SIGNAL(returnPressed(QListViewItem *)), SLOT(slotObjSelected())
	)	;

	connect	(&m_bFail,     SIGNAL(clicked()), SLOT(clickFail      ())) ;
	connect	(&m_bContinue, SIGNAL(clicked()), SLOT(slotObjSelected())) ;

	QListViewItem	*oi = KBObjTreeObject::expandToObject(&m_objTree, object) ;

	m_objTree  .setSelected (oi, true) ;
	m_bContinue.setEnabled 	(false) ;
}

/*  KBNoObjDlg								*/
/*  slotObjClicked							*/
/*		: User clicks object					*/
/*  (returns)	: void		:					*/

void	KBNoObjDlg::slotObjClicked ()
{
	m_bContinue.setEnabled (true) ;
}

/*  KBNoObjDlg								*/
/*  slotObjSelected							*/
/*		: User clicks object					*/
/*  (returns)	: void		:					*/

void	KBNoObjDlg::slotObjSelected ()
{
	KBObjTreeObject *obj = (KBObjTreeObject *)m_objTree.currentItem() ;

	if (obj != 0)
	{
		m_selected = obj->object() ;
		done (1) ;
	}
}

/*  KBNoObjDlg								*/
/*  clickFail	: User fails operation					*/
/*  (returns)	: void		:					*/

void	KBNoObjDlg::clickFail ()
{
	done	(0) ;
}


/*  ------------------------------------------------------------------  */

/*  KBSlotFindDlg							*/
/*  KBSlotFindDlg: Constructor for slot/event finder			*/
/*  parent	 : KBObject *	   : Slot's parent			*/
/*  target	 : KBObject *	   : Current target object		*/
/*  event	 : const QString & : Current event			*/
/*  (returns)	 : KBSlotFindDlg   :					*/

KBSlotFindDlg::KBSlotFindDlg
	(	KBObject	*parent,
		KBObject	*target,
		const QString	&event
	)
	:
	_KBDialog	(TR("Locate object and event"), true),
	m_objTree	(this),
	m_events	(this),
	m_bOK		(this),
	m_bCancel	(this)
{
	m_selected	= 0 ;

	m_layMain	= new QVBoxLayout (this) ;
	m_layMain   ->addWidget (&m_objTree)	 ;
	m_layMain   ->addWidget (&m_events )	 ;
	m_layButtons	= new QHBoxLayout (m_layMain) ;
	m_layButtons->addStretch()		 ;
	m_layButtons->addWidget (&m_bOK	   )	 ;
	m_layButtons->addWidget (&m_bCancel)	 ;

	m_bOK	   .setText 	(TR("&OK"      ));
	m_bCancel  .setText 	(TR("&Cancel"  ));

	m_objTree  .addColumn  (TR("Object"), 200) ;
	m_objTree  .addColumn  (TR("Name"  ),  80) ;
	m_objTree  .setMinimumWidth    ( 280)	;
	m_objTree  .setRootIsDecorated (true)	;

	connect
	(	&m_objTree,
		SIGNAL(clicked	      (QListViewItem *)),
		SLOT  (slotObjClicked (QListViewItem *))
	)	;

	connect	(&m_bOK,     SIGNAL(clicked()), SLOT(clickOK    ())) ;
	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;

	KBObjTreeObject	*pi = KBObjTreeObject::expandToObject(&m_objTree, parent) ;
	KBObjTreeObject	*ti = KBObjTreeObject::expandToObject(&m_objTree, target) ;

	pi->setStart () ;

	m_objTree.setSelected (ti, true) ;
	slotObjClicked (ti) ;

	for (int idx = 0 ; idx < m_events.count() ; idx += 1)
		if (event == m_eventList.at(idx)->getLegend())
		{
			m_events.setCurrentItem (idx) ;
			break	;
		}
}

/*  KBSlotFindDlg							*/
/*  slotObjClicked							*/
/*		: User clicks object					*/
/*  lvi		: QListViewItem * : Item clicked			*/
/*  (returns)	: void		  :					*/

void	KBSlotFindDlg::slotObjClicked
	(	QListViewItem	*lvi
	)
{
	if (lvi != 0)
	{
		m_selected = ((KBObjTreeObject *)lvi)->object() ;

		m_events   .clear () ;
		m_eventList.clear () ;

		LITER
		(	KBAttr,
			m_selected->getAttribs(),
			attr,

			if (attr->isEvent() != 0)
			{
				m_events.insertItem (attr->getLegend()) ;
				m_eventList.append  (attr) ;
			}
		)
	}
}

/*  KBSlotFindDlg							*/
/*  clickOK	: User OKs operation					*/
/*  (returns)	: void		:					*/

void	KBSlotFindDlg::clickOK ()
{
	done	(1) ;
}

/*  KBSlotFindDlg							*/
/*  clickCancel	: User cancels operation				*/
/*  (returns)	: void		:					*/

void	KBSlotFindDlg::clickCancel ()
{
	done	(0) ;
}


KBObject*KBSlotFindDlg::selectedObj
	(	QString		&event
	)
{
	event	= m_eventList.at(m_events.currentItem())->getName() ;
	return	m_selected ;
}

/*  ------------------------------------------------------------------  */

/*  KBConfigFindDlg							*/
/*  KBConfigFindDlg							*/
/*		: Constructor for object/config finder			*/
/*  parent	: KBObject *	   : Override's parent			*/
/*  target	: KBObject *	   : Current target object		*/
/*  config	: const QString &  : Current config			*/
/*  (returns)	: KBConfigFindDlg  :					*/

KBConfigFindDlg::KBConfigFindDlg
	(	KBObject	*parent,
		KBObject	*target,
		const QString	&
	)
	:
	_KBDialog	(TR("Locate object and config"), true),
	m_objTree	(this),
	m_configs	(this),
	m_start		(parent),
	m_bOK		(this),
	m_bCancel	(this)
{
	m_selected	= 0 ;

	m_layMain	= new QVBoxLayout (this) ;
	m_layMain   ->addWidget (&m_objTree)	 ;
	m_layMain   ->addWidget (&m_configs)	 ;
	m_layButtons	= new QHBoxLayout (m_layMain) ;
	m_layButtons->addStretch()		 ;
	m_layButtons->addWidget (&m_bOK	   )	 ;
	m_layButtons->addWidget (&m_bCancel)	 ;

	m_bOK	   .setText 	(TR("&OK"      ));
	m_bCancel  .setText 	(TR("&Cancel"  ));

	m_objTree  .addColumn  (TR("Object"), 200) ;
	m_objTree  .addColumn  (TR("Name"  ),  80) ;
	m_objTree  .setMinimumWidth    ( 280)	;
	m_objTree  .setRootIsDecorated (true)	;

	connect
	(	&m_objTree,
		SIGNAL(clicked	      (QListViewItem *)),
		SLOT  (slotObjClicked (QListViewItem *))
	)	;

	connect	(&m_bOK,     SIGNAL(clicked()), SLOT(clickOK    ())) ;
	connect	(&m_bCancel, SIGNAL(clicked()), SLOT(clickCancel())) ;

	KBObjTreeObject	*pi = new KBObjTreeObject (&m_objTree, parent) ;
	KBObjTreeObject	*ti = KBObjTreeObject::expandToObject(&m_objTree, target, parent) ;

	pi->setStart () ;

	m_objTree.setSelected (ti, true) ;
	slotObjClicked (m_objTree.firstChild()) ;
}

/*  KBConfigFindDlg							*/
/*  slotObjClicked							*/
/*		: User clicks object					*/
/*  lvi		: QListViewItem * : Item clicked			*/
/*  (returns)	: void		  :					*/

void	KBConfigFindDlg::slotObjClicked
	(	QListViewItem	*lvi
	)
{
	if (lvi != 0)
	{
		m_selected = ((KBObjTreeObject *)lvi)->object() ;

		m_configs.clear () ;

		TITER
		(	Config,
			m_selected->getChildren(),
			c,

			m_configs.insertItem (c->attrib()) ;
		)

		m_bOK.setEnabled (m_configs.count() > 0) ;
	}
}

/*  KBConfigFindDlg							*/
/*  clickOK	: User OKs operation					*/
/*  (returns)	: void		:					*/

void	KBConfigFindDlg::clickOK ()
{
	done	(1) ;
}

/*  KBConfigFindDlg							*/
/*  clickCancel	: User cancels operation				*/
/*  (returns)	: void		:					*/

void	KBConfigFindDlg::clickCancel ()
{
	done	(0) ;
}


KBObject*KBConfigFindDlg::selectedConfig
	(	QString		&path,
		QString		&attrib
	)
{
	KBObjTreeObject *lvi = (KBObjTreeObject *)m_objTree.currentItem() ;

	path	= QString::null	;
	while ((lvi != 0) && (lvi->object() != m_start))
	{
		if (!path.isEmpty()) path = "/" + path ;
		path	= lvi->text  (1) + path ;
		lvi	= (KBObjTreeObject *)lvi->parent()  ;
	}

	attrib	= m_configs.currentText () ;
	return	lvi == 0 ? 0 : m_selected  ;
}

