/***************************************************************************
    file	         : kb_qtfield.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_QTFIELD_H
#define	_KB_QTFIELD_H

#include	<qpushbutton.h>

#include	"kb_ctrl.h"
#include	"kb_mask.h"

#include	"libkbase_exports.h"

#define	FIELD_NOCHANGE(s)	\
	{	m_inSetValue = true  ;	\
		s ;			\
		m_inSetValue = false ;	\
	}


/*  KBCtrlField								*/
/*  -----------								*/
/*  Wrapper class for line edit control					*/

class	LIBKBASE_API	KBCtrlField : public TKLineEdit, public KBControl
{
	Q_OBJECT

	KBField		*m_field	;
	QPushButton	*m_bHelp	;
	KBMaskedInput	m_inputMask	;
	bool		m_inSetValue	;

private slots :

	void		helpClicked 	() ;
	void		textChangedTo	(const QString &) ;

protected :

        virtual void    giveFocus	() ;
	virtual	void	focusInEvent	(QFocusEvent  *) ;
	virtual	void	focusOutEvent	(QFocusEvent  *) ;

public	:

	KBCtrlField (KBDisplay *, KBField *, uint) ;
virtual~KBCtrlField () ;

	virtual	void	showName	() ;
	virtual	void	showAs		(KB::ShowAs) ;
	virtual	void	redraw		() ;
	virtual	void	setValue	(const KBValue &) ;
	virtual	KBValue	getValue	() ;
	virtual	void	clearValue	(bool) ;
	virtual	bool	changed		() ;
	virtual	bool	isEmpty		() ;
	virtual	bool	isValid		(bool) ;
	virtual	bool	write		(KBWriter *, QRect, const KBValue &, bool, int &) ;

	virtual	QString	morphText	() ;

	SETFOCUS
	SIZEHINT
}	;


#endif	// _KB_QTFIELD_H
