/***************************************************************************
    file	         : kb_qtlink.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<ctype.h>

#include	<qapplication.h>
#include	<qlist.h>
#include	<qstring.h>
#include	<qlistbox.h>
#include	<qtimer.h>

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"

#include	"kb_writer.h"
#include	"kb_block.h"
#include	"kb_link.h"
#include	"kb_display.h"

#include	"kb_multilistbox.h"

#ifndef 	_WIN32
#include 	"kb_qtlink.moc"
#else
#include 	"kb_qtlink.h"
#endif


/*  KBCtrlLink								*/
/*  KBCtrlLink	: Constructor for combo box wrapper			*/
/*  display	: KBDisplay *	: Parent display			*/
/*  link	: KBLink *	: Parent link				*/
/*  drow	: uint		: Row number in field			*/
/*  (returns)	: KBCtrlLink	:					*/

KBCtrlLink::KBCtrlLink
	(	KBDisplay	*display,
		KBLink		*link,
		uint		drow
	)
	:
	KBComboBox (display->getDisplayWidget()),
	KBControl  (this, display, link, drow),
	m_link	   (link)
{
	m_listBox = new KBMultiListBox
			(	this,
				false,
				link->getAttrVal("showcols").toInt()
			) ;
	setListBox (m_listBox) ;

	connect	(this, SIGNAL(activated(int)), SLOT(slotActivated(int))) ;

	m_deferFocus	= 0 ;
	m_deferMouse	= 0 ;
	m_keyset	= 0 ;
}

/*  KBCtrlLink								*/
/*  ~KBCtrlLink	: Desctructor for link class				*/
/*  (returns)	:		:					*/

KBCtrlLink::~KBCtrlLink ()
{
	DELOBJ	(m_deferFocus)	;
	DELOBJ	(m_deferMouse)	;
	DELOBJ	(m_keyset    )	;
}

/*  KBCtrlLink								*/
/*  setData	: Load values into combo				*/
/*  valset	: 		: List of values			*/
/*  (returns)	: void		:					*/

void	KBCtrlLink::loadDataValues
	(	const QValueList<const QStringList>	&valset
	)
{
	m_listBox->clear () ;
	clear	 	 () ;

	for (uint idx = 0 ; idx < valset.count() ; idx += 1)
		m_listBox->insertEntry (*valset.at(idx)) ;

	m_listBox->calcGeometry () ;
}

/*  KBCtrlLink								*/
/*  setData	: Set value set						*/
/*  data	: void *	: Actually, KBLinkData			*/
/*  (returns)	: void		:					*/

void	KBCtrlLink::setData
	(	void	*data
	)
{
	KBLinkData	*ltd = (KBLinkData *)data ;
	DELOBJ		(m_keyset) ;
	loadDataValues	(ltd->m_valset) ;
}

/*  KBCtrlLink								*/
/*  slotActivated: Selection changed notification			*/
/*  idx		 : int		: Selection index			*/
/*  (returns)	 : void		:					*/

void	KBCtrlLink::slotActivated
	(	int	idx
	)
{
	if (startUpdate())
		m_link->userChange
		(	m_link->getBlock()->getCurDRow() + m_drow,
			idx
		)	;
}

/*  KBCtrlLink								*/
/*  showName	: Show control name					*/
/*  (returns)	: void		:					*/

void	KBCtrlLink::showName ()
{
#if	! __KB_RUNTIME
	if ((m_drow == 0) && (m_showing == KB::ShowAsDesign))
	{	
		clear () ;
		m_listBox->clear       () ;
		m_listBox->insertEntry (m_link->getName()) ;
	}
#endif
}

/*  KBCtrlLink								*/
/*  showAs	: Set or clear design mode				*/
/*  mode	: KB::ShowAs	: Design mode				*/
/*  (returns)	: void		:					*/

void	KBCtrlLink::showAs
	(	KB::ShowAs	mode
	)
{
	KBControl::showAs (mode) ;

	m_userSorting	= QString::null ;
	m_userFilter	= QString::null ;
	DELOBJ	(m_keyset) ;

	m_listBox->calcGeometry () ;
	m_listBox->setShowCols  (m_link->getAttrVal("showcols").toUInt()) ;
	clear	() ;
	redraw	() ;

#if	! __KB_RUNTIME
	if ((mode == KB::ShowAsDesign) && (m_drow == 0))
	{	showName () ;
		return	    ;
	}
#endif
}

/*  KBCtrlLink								*/
/*  setValue	: Set value						*/
/*  value	: const KBValue &: Value				*/
/*  (returns)	: void		 :					*/

void	KBCtrlLink::setValue
	(	const KBValue	&value
	)
{
	/* Note the new value and, if setting from the database, then	*/
	/* note it also as the initial value.				*/
	setCurrentItem (m_link->valueToItem (value, m_keyset)) ;
	KBControl::setValue (value) ;
}

/*  KBCtrlLink								*/
/*  getValue	: Get value						*/
/*  (returns)	: KBValue 	: Value					*/

KBValue	KBCtrlLink::getValue ()
{
	return	m_link->itemToValue (currentItem(), m_keyset) ;
}

/*  KBCtrlLink								*/
/*  clearValue	: Get value						*/
/*  query	: bool		: Clear for query			*/
/*  (returns)	: KBValue 	: Value					*/

void	KBCtrlLink::clearValue
	(	bool	query
	)
{
	setCurrentItem   (0) ;
	KBControl::clearValue (query) ;
}

/*  KBCtrlLink								*/
/*  changed	: See of field has changed				*/
/*  (returns)	: bool 		: Changed				*/

bool	KBCtrlLink::changed ()
{
	/* Changed if current and initial values are different. Note	*/
	/* that curVal is maintained via the "activated" signal.	*/
	return	currentItem() != (int)m_link->valueToItem (getIniValue(), m_keyset) ;
}

/*  KBCtrlLink								*/
/*  isEmpty	: See if control is empty				*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlLink::isEmpty ()
{
	return	currentItem() == 0 ;
}

/*  KBCtrlLink								*/
/*  isValid	: See if control is valid				*/
/*  allowNull	: bool		: True to ignore not-null check		*/
/*  (returns)	: bool		: Empty					*/

bool	KBCtrlLink::isValid
	(	bool		allowNull
	)
{
	/* Validity check based on index: all but the leading null	*/
	/* entry must be valid, and the validity of the leading null	*/
	/* depends on the not-null setting.				*/
	if (!m_link->checkValid (currentItem(), allowNull))
	{
		setError (m_link->lastError()) ;
		return	false	;
	}

	return	true	;
}

/*  KBCtrlLink								*/
/*  giveFocus	: Give focus to the control				*/
/*  (returns)	: void							*/

void	KBCtrlLink::giveFocus ()
{
	QComboBox::setFocus () ;
}

/*  KBCtrlLink								*/
/*  focusInEvent: Focus arrives at the control				*/
/*  e		: QFocusEvent *	: Focus event				*/
/*  (returns)	: void							*/

void	KBCtrlLink::focusInEvent
	(	QFocusEvent	*e
	)
{
	KBValue	curVal	;

	/* If in data mode and the link is dynamic then we will need to	*/
	/* refresh the control. This is nasty ....			*/
	if ((m_showing == KB::ShowAsData) && m_link->dynamic())
		switch (e->reason())
		{
			case QFocusEvent::Tab	   :
			case QFocusEvent::Shortcut :
			case QFocusEvent::Other    :
				/* These cases are easy, the one below	*/
				/* is not.				*/
				curVal	= getValue() ;
				m_link->doRefresh (m_drow) ;
				setValue (curVal)    ;
				break ;

			case QFocusEvent::Mouse    :
				/* If focus arrives on account of the	*/
				/* mouse then we have to defer then	*/
				/* focus in and mouse button events or	*/
				/* we get an escape-only lockup.	*/
				curVal	= getValue() ;
				m_link->doRefresh (m_drow) ;
				setValue (curVal)    ;

				m_deferFocus = new QFocusEvent(QEvent::FocusIn) ;
				QTimer::singleShot (250, this, SLOT(passFocus())) ;
				return	;

			default	:
				break	;
		}

	QComboBox::focusInEvent (e) ;
}

/*  KBCtrlLink								*/
/*  event	: Event filter						*/
/*  e		: QEvent *	: Event					*/
/*  (returns)	: bool		: True if event consumed		*/

bool	KBCtrlLink::event
	(	QEvent	*e
	)
{
	/* If this is a mouse press and focus is being deferred then we	*/
	/* have to defer the mouse press as well.			*/
	if (e->type() == QEvent::MouseButtonPress)
		if (m_deferFocus != 0)
		{
			QMouseEvent *me = (QMouseEvent *)e ;
			m_deferMouse = new QMouseEvent (me->type(), me->pos(), me->globalPos(), me->button(), me->state()) ;
			return	true ;
		}

	return	KBComboBox::event (e) ;
}

/*  KBCtrlLink								*/
/*  passFocus	: Actually pass focus into the control			*/
/*  (returns)	: void		:					*/

void	KBCtrlLink::passFocus ()
{
//	fprintf
//	(	stderr,
//		"KBCtrlLink::passFocus: [%p] [%p]\n",
//		(void *)m_deferFocus,
//		(void *)m_deferMouse
//	)	;

	if (m_deferFocus != 0)
	{
		QFocusEvent::setReason	    (QFocusEvent::Mouse) ;
		KBComboBox ::focusInEvent   (m_deferFocus) ;
		DELOBJ	(m_deferFocus) ;
	}

	if (m_deferMouse != 0)
	{
		KBComboBox::mousePressEvent (m_deferMouse) ;
		DELOBJ	(m_deferMouse) ;
	}
}

/*  KBCtrlLink								*/
/*  write	: Write link 						*/
/*  writer	: KBWriter *	: Output writer				*/
/*  rect	: QRect		: Field area				*/
/*  value	: KBValue &	: Value for reports			*/
/*  fSubs	: bool		: Substitution flag			*/
/*  extra	: int &		: Return extra space			*/
/*  (returns)	: bool		: Success				*/

bool	KBCtrlLink::write
	(	KBWriter	*writer,
		QRect		rect,
		const KBValue	&value,
		bool		fSubs,
		int		&extra
	)
{
	if (writer->asReport())
	{
		new KBWriterText
		(	writer,
			rect,
			m_link->getPalette(true),
			m_link->getFont   (true),
			value.getRawText  (),
			Qt::AlignLeft|Qt::AlignVCenter,
			false
		)	;

		extra	= 0	;
		return	true	;
	}

	return	KBControl::write (writer, rect, value, fSubs, extra) ;
}

/*  KBCtrlLink								*/
/*  morphText	: Get text for morphed control				*/
/*  (returns)	: QString	: Text					*/

QString	KBCtrlLink::morphText ()
{
	return	currentText()	;
}

/*  KBCtrlLink								*/
/*  redraw	: Update to match design state				*/
/*  (returns)	: void		:					*/

void	KBCtrlLink::redraw ()
{
	setReadOnly ((m_showing == KB::ShowAsData) && m_link->isReadOnly()) ;
}

/*  KBCtrlLink							*/
/*  setUserFilter						*/
/*		: Set user filter for link query		*/
/*  filter	: const QString & : Filter expression		*/
/*  (returns)	: void		  :				*/

void	KBCtrlLink::setUserFilter
	(	const QString	&filter
	)
{
	m_userFilter	= filter ;
}

/*  KBCtrlLink							*/
/*  setUserSorting						*/
/*		: Set user sorting for link query		*/
/*  sorting	: const QString & : Sorting expression		*/
/*  (returns)	: void		  :				*/

void	KBCtrlLink::setUserSorting
	(	const QString	&sorting
	)
{
	m_userSorting	= sorting ;
}

/*  KBCtrlLink							*/
/*  reload	: Reload values list				*/
/*  (returns)	: void		  :				*/

void	KBCtrlLink::reload ()
{
	KBValue	curVal	= m_curVal ;
	DELOBJ  (m_keyset) ;

	/* If either a user filter or sorting expression in set	*/
	/* the we do an explicit load for this control only,	*/
	/* providing our own keyset (which is retained).	*/
	if (!m_userFilter.isEmpty() || !m_userSorting.isEmpty())
	{
		QValueList<const QStringList> valset ;

		m_keyset = new QStringList ;

		m_link->loadValues
		(	m_userFilter,
			m_userSorting,
			*m_keyset,
			valset
		)	;

		loadDataValues (valset) ;		
	}
	else	m_link->doRefresh (m_drow) ;

	setValue (curVal)    ;
}

