/***************************************************************************
    file	         : tkc_keymapper.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__TKC_KEYMAPPER_H
#define	__TKC_KEYMAPPER_H

#include	<qobject.h>
#include	<qstring.h>
#include	<qintdict.h>
#include	<qvaluelist.h>
#include	<qguardedptr.h>

#include	"libkbase_exports.h"

class TKCKeyMapperMap	;


/*  TKCKeyMapper														*/
/*  ------------														*/
/*  This class provides a mechanism for binding aribtrary key sequences	*/
/*  to actions, such as for an editor. It is inspired by the key binder	*/
/*  for the SSED editor.												*/

class LIBKBASE_API TKCKeyMapper : public QObject
{
	Q_OBJECT

	static	QIntDict<TKCKeyMapperMap> m_map		;

	TKCKeyMapperMap			*m_currentMap	;

	static	QValueList<int>		keysToKeys(const QString &) ;
	TKCKeyMapperMap			*findMapperMap(const QValueList<int> &);

protected:

	virtual int		codeToCode	(const QString &) 	= 0 ;
	virtual	bool		helper		(int, const QString &)	= 0 ;
	virtual	bool		function	(int, const QString &)	= 0 ;
	virtual	void		error		() ;

	virtual	bool		useAtOuterLevel	(int, bool) ;

public:

	TKCKeyMapper();
	virtual	~TKCKeyMapper();

	void			bindFunction	(const QValueList<int> &, int, const QString & = QString::null);
	void			bindHelper	(const QValueList<int> &, int, const QString & = QString::null);

	bool			applyKey	(int, bool);
	void			clearKey	();

	void			clearKeyMap	();
	QString 		loadKeyMap	(const QString &);

	friend class TKCKeyMapperMap ;
}	;

#endif	// __TKC_KEYMAPPER_H
