/***************************************************************************
    file	         : kb_param.h
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	_KB_PARAM
#define	_KB_PARAM

#include	"kb_node.h"
#include	"libkbase_exports.h"

class LIBKBASE_API	KBParam : public KBNode
{
	KBAttrStr	m_name		;
	KBAttrStr	m_defval	;
	KBAttrStr	m_legend	;
	KBAttrStr	m_format	;
	KBAttrBool	m_prompt	;

	QString		m_value		;

public	:

	KBParam	(KBNode *, const QDict<QString> &, bool * = 0) ;
	KBParam (KBNode *, const QString &, const QString &, const QString &, const QString &, bool) ;
	KBParam	(KBNode *, KBParam *) ;
       ~KBParam () ;

	virtual	KBNode	*replicate 	(KBNode *) ;

	virtual	KBParam	*isParam 	() { return this ; }

	inline QString	getName		() { return m_name     .getValue    ()	; }
	inline QString	getDefval	() { return m_defval   .getValue    ()	; }
	inline QString	getLegend	() { return m_legend   .getValue    ()	; }
	inline bool	getPrompt	() { return m_prompt   .getBoolValue()	; }
	inline QString	getFormat	() { return m_format   .getValue    ()	; }

	QString		getValue	() { return m_value ; }

	virtual	void	findAllParams	(QDict<KBParamSet> &) ;

	inline	void	setValue
		(	const QString	&v
		)
	{
		m_value	= v ;
	}
}	;

extern	QString	paramSub	(const QString &, const QDict<QString> &) ;


#endif	// _KB_PARAM
