/***************************************************************************
    file	         : kb_writer.h
    copyright            : (C)	1999,2000,2001,2002,2003,2004,2005
				 by Mike Richardson
			   (C)	2001,2002,2003,2004,2005
				by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#ifndef	__KB_WRITER_H
#define	__KB_WRITER_H


#include	<qpixmap.h>
#include	<qprinter.h>
#include	<qpainter.h>
#include	<qlist.h>
#include	<qwidget.h>

#include	"libkbase_exports.h"

#include	"kb_location.h"
#include	"kb_dom.h"
#include	"tk_print.h"


/*  The classes in this file implement output writing, either to an on-	*/
/*  screen widget or a printer.						*/
/*									*/
/*  The basic mechanism is to an instances of classes derived from	*/
/*  KBWriterItem to a single instance of KBWriter, which can then be	*/
/*  used to render the output. This file, and kb_writer.cpp define and	*/
/*  implement a basic set of KBWriterItem classes; others can be	*/
/*  defined and implemented elsewhere as neccessary as database		*/
/*  controls are defined.						*/


/*  KBWriterItem							*/
/*  ------------							*/
/*  This is a base class for data which is to be written onto a widget	*/
/*  and which must therefore be retained for repaints.			*/

class	LIBKBASE_API	KBWriterItem
{
protected :

	KBWriter 	*m_writer	;
	QRect		m_rect		;

public	:

	KBWriterItem (KBWriter *, QRect) ;
	virtual	~KBWriterItem () = 0 ;

	virtual	void	paintEvent	(QPaintEvent *, QPainter &) = 0 ;
}	;


/*  KBWriterText							*/
/*  ------------							*/
/*  Class used to hold text which is to be written onto a widget. Holds	*/
/*  position and style as well as the text.				*/

class	LIBKBASE_API	KBWriterText : public KBWriterItem
{
	const QPalette	*m_pal		;
	const QFont	*m_font		;
	QString		m_text		;
	int		m_align		;
	bool		m_fSubs		;
	int		m_extra		;
	bool		m_useExtra	;

public	:

	KBWriterText	(KBWriter *, QRect, const QPalette *,
					    const QFont    *,
					    const QString  &, int, bool) ;
	virtual	~KBWriterText	() ;

	virtual	void	paintEvent (QPaintEvent *, QPainter &) ;

	inline	int	extra	()
	{
		m_useExtra = true ;
		return	m_extra	  ;
	}
}	;


/*  KBWriterBox								*/
/*  -----------								*/
/*  Class used to describe a simple box.				*/

class	LIBKBASE_API	KBWriterBox : public KBWriterItem
{
public	:

	KBWriterBox	(KBWriter *, QRect) ;
	virtual	~KBWriterBox	() ;

	virtual	void	paintEvent (QPaintEvent *, QPainter &) ;
}	;


/*  KBWriterPixmap							*/
/*  --------------							*/
/*  Class used to hold an image						*/

class	LIBKBASE_API	KBWriterPixmap : public KBWriterItem
{
	QPixmap		m_pixmap ;
	
public	:

	KBWriterPixmap	(KBWriter *, QRect, const QPixmap &) ;
	virtual	~KBWriterPixmap	() ;

	virtual	void	paintEvent (QPaintEvent *, QPainter &) ;
}	;


/*  KBWriteBG								*/
/*  ---------								*/
/*  Class used to hold background color information			*/

class	LIBKBASE_API	KBWriterBG : public KBWriterItem
{
	QString		m_color	;

public	:

	KBWriterBG	(KBWriter *, QRect, const QString &) ;
	virtual	~KBWriterBG	() ;

	virtual	void	paintEvent (QPaintEvent *, QPainter &) ;
}	;



/*  KBWriter								*/
/*  --------								*/
/*  General writer class. The main function of this class is to		*/
/*  accumulate output elements; these will then be written onto, for	*/
/*  instance, a QWidget or a Q/KPrinter.				*/

typedef	QList<KBWriterItem>	KBWPage	;

class	LIBKBASE_API	KBWriter : public QWidget
{
	KBDBInfo		*m_dbInfo	;
	QString			m_docLocn	;
	bool			m_report	;

	uint			m_lMargin	;
	uint			m_rMargin	;
	uint			m_tMargin	;
	uint			m_bMargin	;

	uint			m_vRows		;
	uint			m_vCols		;
	uint			m_vRowGap	;
	uint			m_vColGap	;
	int			m_vRowHeight	;
	int			m_vColWidth	;
	uint			m_vAtRow	;
	uint			m_vAtCol	;
	bool			m_vBorders	;

	int			m_pWidth	;
	int			m_pHeight	;

	QPoint			m_offset	;
	int			m_foot		;
	QValueList<int>		m_pageList	;

	QList<KBWPage>		m_pages		;
	KBWPage			*m_page		;
	uint			m_cPNum		;

	TKPrinterSettings	m_settings	;

#if	! __KB_EMBEDDED
	TKPrinter		*m_printer	;
	QPainter		*m_painter	;

	QDomElement	getPrinterSpec	(const QString &) ;
#endif

	void		startPage   	()	;

protected :

	virtual	void	paintEvent (QPaintEvent *) ;

public	:

	KBWriter	(QWidget *, KBLocation  &) ;
       ~KBWriter	()			;

	virtual	void	clear		()	;
	virtual	void	newPage		()	;
	virtual	bool	spaceAvailable	(int )	;
	virtual	void	showPage	(uint)	;
	virtual	bool	pageIsEmpty	()	;
	virtual	uint	numPages	()	;

	bool		setup		(const QString &, bool, uint, uint, uint, uint, bool) ;
#if	! __KB_EMBEDDED
	bool		setup		(bool)	;
#endif
	bool		setupVirtual	(uint, uint, uint, uint, bool, bool) ;

	void		add		(KBWriterItem  *, QRect &) ;
	void		adjust		(QRect &) ;

	QPoint		setOffset 	(bool, QPoint   ) ;
	QSize		getSize		()	;
	int		reserve		(int)	;
	QString		textSub		(const QString &) ;
	void		printDoc	(const QString &, int) ;

	inline	void	setReport()
	{
		m_report = true		;
	}

	inline	bool	asReport ()
	{
		return	m_report	;
	}
}	;

extern	LIBKBASE_API	double	pixelsPerMM	() ;
extern	LIBKBASE_API	void	getPixelPageSize(cchar *, int &, int &) ;

#endif	// __KB_WRITER_H
