/*
    Copyright (C) 2001-2002 by theKompany.com <www.thekompany.com>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    See COPYING.GPL file.

    In addition, as a special exception, theKompany.com gives permission
    to link the code of this program with the tkwidgets library (or with
    modified versions of tkwidgets that use the same license as tkwidgets),
    and distribute linked combinations including the two.  You must obey
    the GNU General Public License in all respects for all of the code used
    other than tkwidgets.  If you modify this file, you may extend this
    exception to your version of the file, but you are not obligated to do so.
    If you do not wish to do so, delete this exception statement from your
    version.

    This license grants you the ability to use tkwidgets with Rekall only
    and may not be used outside of Rekall.
    See also http://www.rekall.a-i-s.co.uk/products/license.txt for details.
*/


#include "tktextline.h"

#include <qregexp.h>

TKTextLine::TKTextLine()
: QString(),
  ctx(0), hctx(0), highlighted(false), st(0), sublines(0), num(-1), intnum(-1), margins(0), mark(0),
	breakpoint(false), breakpointEnabled(false)
{
}

TKTextLine::~TKTextLine()
{
  delete margins;
  delete sublines;
}

void TKTextLine::resetHighlight(int context)
{
  hctx = context;
  highlighted = false;
  attributes.fill(0, length());
}

void TKTextLine::set(const QString &text)
{
  truncate(0);
  append(text);
}

void TKTextLine::replace(uint index, uint len, const QString &s)
{
  remove(index, len);
  insert(index, s);
}

bool TKTextLine::removeSpaces()
{
  int l = find(QRegExp("\\s+$"));
  if (l != -1) {
    truncate(l);
    return true;
  }
  return false;
}

int TKTextLine::firstChar() const
{
  int r = find(QRegExp("[^\\s]"));
  return r;// == -1 ? 0 : r;
}

QChar &TKTextLine::ref(uint i)
{
  if (i < length())
    return QString::ref(i);

  int zero = 0;
  //debug("%d", 10/zero);

  static QChar ch = QChar::null;
  return ch;
}

void TKTextLine::setAttributes(int attribute, uint start, uint end)
{
  if(attributes.size() <  length())
      attributes.resize(length());
  for (uint z = start; z < QMIN(end, attributes.size()); z++)
    attributes.at(z) = attribute;
}

int TKTextLine::attribute(uint pos) const
{
  return pos < attributes.size() ? attributes.at(pos) : 0;
}

void TKTextLine::setMargin(int classId, int itemId)
{
  if (!margins) {
    margins = new QPtrList<MarginData>;
    margins->setAutoDelete(true);
  }
  MarginData *d = new MarginData;
  d->classId = classId;
  d->itemId = itemId;
  margins->append(d);
}

void TKTextLine::delMargin(int classId, int itemId)
{
  for (MarginData *d = margins->first(); d; d = margins->next())
    if (d->classId == classId && d->itemId == itemId) {
      margins->remove(d);
      if (margins->isEmpty()) {
        delete margins;
        margins = 0;
      }
      break;
    }
}

bool TKTextLine::firstMargin(int &classId, int &itemId)
{
  if (!margins || !margins->at(0))
    return false;
  classId = margins->at(0)->classId;
  itemId = margins->at(0)->itemId;
  return true;
}

QValueList<int> TKTextLine::marginsForClass(int classId)
{
  QValueList<int> list;
  for (MarginData *d = margins->first(); d; d = margins->next())
    if (d->classId == classId)
      list << d->itemId;

  return list;
}

void TKTextLine::appendChild(TKTextLine *child)
{
  if (!sublines)
    sublines = new QPtrList<TKTextLine>;
  sublines->append(child);
}

void TKTextLine::removeChildren()
{
  delete sublines;
  sublines = 0;
}

