/***************************************************************************
    file	         : kb_wizsource.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	"kb_classes.h"
#include	"kb_database.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_dbdociter.h"
#include	"kb_serverinfo.h"

#ifndef		_WIN32
#include	"kb_wizsource.moc"
#else
#include	"kb_wizsource.h"
#endif


/*  KBDataSource							*/
/*  ------------							*/
/*  Wrapper class round QListBoxText to store the data source name and	*/
/*  type, and to display the type of the source against the name.	*/

class	KBDataSource : public QListBoxText
{
private	:

	QString				m_name	;
	KBWizardCtrlDataSource::Type	m_type	;

public	:

	KBDataSource
		(	QComboBox			*parent,
			QString				name,
			KBWizardCtrlDataSource::Type	type
		)	;

	inline	KBWizardCtrlDataSource::Type type ()
	{
		return	m_type	;
	}
	inline	QString	name	()
	{
		return	m_name	;
	}
}	;


/*  KBDataSource							*/
/*  KBDataSource: Constructor for data source item			*/
/*  parent	: QComboBox *	: Parent combobox			*/
/*  name	: QString	: Data source name			*/
/*  type	: Type		: Data source type			*/
/*  (returns)	: KBDataSource	:					*/

KBDataSource::KBDataSource
	(	QComboBox			*parent,
		QString				name,
		KBWizardCtrlDataSource::Type	type
		
	)
	:
	QListBoxText	(parent->listBox()),
	m_name		(name),
	m_type		(type)
{
	switch (type)
	{
		case KBWizardCtrlDataSource::Table :
			setText (TR("Table: ") + name) ;
			break	;

		case KBWizardCtrlDataSource::Query :
			setText (TR("Query: ") + name) ;
			break	;

		default	:
			setText	(name) ;
			break	;
	}
}

/*  ------------------------------------------------------------------  */


/*  KBWizardCtrlDataSource						*/
/*  KBWizardCtrlDataSource						*/
/*		: Constructor for data source wizard control		*/
/*  page	: KBWizardPage *	 : Parent page			*/
/*  elem	: QDomElement  &	 : Definition element		*/
/*  (returns)	: KBWizardCtrlDataSource :				*/

KBWizardCtrlDataSource::KBWizardCtrlDataSource
	(	KBWizardPage		*page,
		const QDomElement	&elem
	)
	:
	KBWizardCtrl	(page, elem.attribute("name"))
{
	setWidget (m_source = new QComboBox (page)) ;
	m_source->setListBox (new QListBox (m_source)) ;

	KBWizard	*wizard	= page  ->wizard() ;
	KBDBInfo	*dbInfo	= wizard->dbInfo() ;
	const QString	&server	= wizard->server() ;

	/* Load the list of tables into the control, or report the	*/
	/* error if anything fails. Then similarly load the list of	*/
	/* queries.							*/
	KBError			error	;
	KBDBLink		dbLink	;
	KBTableDetailsList	tabList ;

	if (dbLink.connect (dbInfo, server) && dbLink.listTables (tabList))
	{
		for (uint idx = 0 ; idx < tabList.count(); idx += 1)
			new KBDataSource
			(	m_source,
				tabList[idx].m_name,
				KBWizardCtrlDataSource::Table
			)	;
	}
	else	dbLink.lastError().DISPLAY() ;


	KBDBDocIter	docIter	;
	if (docIter.init
		(	dbInfo,
			server,
			"query",
			"qry",
			error,
			false
		))
	{
		QString	name	;
		QString	stamp	;

		while (docIter.getNextDoc (name, stamp))
			new KBDataSource
			(	m_source,
				name,
				KBWizardCtrlDataSource::Query
			)	;
	}
	else	error.DISPLAY()	;

	connect
	(	m_source,
		SIGNAL(activated      (int)),
		SLOT  (ctrlChanged    ())
	)	;
}

/*  KBWizardCtrlDataSource						*/
/*  ~KBWizardCtrlDataSource						*/
/*		: Destructor for data source wizard control		*/
/*  (returns)	:		:					*/

KBWizardCtrlDataSource::~KBWizardCtrlDataSource ()
{
}

/*  KBWizardCtrlDataSource						*/
/*  setValue	: Set data value					*/
/*  value	: const QString & : Value to set			*/
/*  (returns)	: void		  :					*/

void	KBWizardCtrlDataSource::setValue
	(	const QString	&
	)
{
	/* Not used! Anyway, it is a bit meaningless since we'd need	*/
	/* the name *and* the type.					*/
}

/*  KBWizardCtrlDataSource						*/
/*  value	: Get value						*/
/*  (returns)	: QString	: Value					*/

QString	KBWizardCtrlDataSource::value ()
{
	QListBox *lb = m_source->listBox() ;
	if (lb == 0) return QString::null  ;

	KBDataSource *t = (KBDataSource *)lb->item(m_source->currentItem()) ;
	if (t  == 0) return QString::null  ;

	return	t->name() ;
}

/*  KBWizardCtrlDataSource						*/
/*  attribute	: Get control attribute value				*/
/*  attr	: const QString & : Attribute name			*/
/*  (returns)	: QVariant	  : Attribute value			*/

QVariant
	KBWizardCtrlDataSource::attribute
	(	const QString	&attr
	)
{
	/* The only attribute defined is the type, so we can find out	*/
	/* whether the value is a table or a query.			*/
	if (attr == "type")
	{
		QListBox *lb = m_source->listBox() ;
		if (lb == 0) return QVariant(0)    ;

		KBDataSource *t = (KBDataSource *)m_source->listBox()->item(m_source->currentItem()) ;
		if (t  == 0) return QVariant(0)    ;

		return	QVariant((int)t->type()) ;
	}

	return	QVariant() ;

}

WIZARDCTRLREG(DataSource)
