#!/bin/sh


rekallCopyData(){

	rm -rf	distrib/rekall
	mkdir	distrib/rekall
	mkdir	distrib/rekall/common
	mkdir	distrib/rekall/common/data
	mkdir	distrib/rekall/common/data/dict
	mkdir	distrib/rekall/common/data/script
	mkdir	distrib/rekall/common/data/script/py
	mkdir	distrib/rekall/common/data/services
	mkdir	distrib/rekall/common/data/wizards
	mkdir	distrib/rekall/common/data/stock
	mkdir	distrib/rekall/common/data/stock/component
	mkdir	distrib/rekall/common/data/stock/component/py
	mkdir	distrib/rekall/common/doc
	mkdir	distrib/rekall/python
	mkdir	distrib/rekall/python/Python-2.2.0-Win

	for dll in	\
		kbase210.dll			\
		kbase_el32.dll			\
		kbase_common210.dll		\
		kbase_app210.dll		\
		kbase_wizard210.dll		\
		kbase_plugin_extra.dll		\
		kbase_siplib.dll		\
		kbase_tkkde210.dll		\
		kbase_tkwidgets210.dll		\
		kbase_xbase.dll			\
		kbase_xbsql.dll			\
		kbase_script_py.dll		\
		kbase_script_pyinterp.dll	\
		kbase_driver_mysql.dll		\
		kbase_driver_pgsql.dll		\
		kbase_driver_xbase.dll
	do
		echo Copying $dll ...
		cp common/lib/$dll distrib/rekall
	done


	for dll in	\
		kbase_copierview.dll		\
		kbase_editor.dll		\
		kbase_formview.dll		\
		kbase_queryview.dll		\
		kbase_reportview.dll		\
		kbase_tableview.dll		\
		kbase_componentview.dll		\
		kbase_macroview.dll		\
		kbase_script_py.dll		\
		kbase_script_pyinterp.dll
	do
		echo Copying $dll ...
		cp common/lib/$dll distrib/rekall
	done

	echo Copying rekall2.exe ...
	cp ../rekall2/rekall2.exe distrib/rekall

	echo Copying additional dlls ...
	cp setup/qt-mt310.dll distrib/rekall
	cp setup/msvcrt.dll distrib/rekall
	cp setup/libmmd.dll distrib/rekall
	cp setup/python22.dll distrib/rekall
	cp setup/libmySQL.dll distrib/rekall
	cp setup/libpq.dll distrib/rekall

	echo Copying UI files ...
	for ui in `cd kbase/ui.std ; echo rekallui.*`
	do
		echo $ui '->' `echo $ui | sed 's/rekallui./rekallui_/'`
		cp kbase/ui.std/$ui distrib/rekall/common/data/`echo $ui | sed 's/rekallui./rekallui_/'`
	done

	cp script/python/stub/rekallui.pydebug distrib/rekall/common/data/rekallui_pydebug

	echo Copying desktop files
	for dt in parts/*/rekall_*.desktop
	do
		cp $dt distrib/rekall/common/data/services
	done
	for db in mysql pgsql xbase
	do
		cp db/$db/rekall_*.desktop distrib/rekall/common/data/services
	done
	cp script/python/stub/rekall_*.desktop distrib/rekall/common/data/services
	cp libs/extra/rekall_*.desktop distrib/rekall/common/data/services

	echo Copying dictionary files ...
	cp dict/*.dict distrib/rekall/common/data/dict
	cp libs/extra/extra.mac distrib/rekall/common/data/dict

	echo Copying wizards files ...
	cp wizards/*.wiz distrib/rekall/common/data/wizards

	echo Copying help file
	cp doc/rekall/chm/rekall.chm distrib/rekall/common/doc

	echo Copying editor highlight files ...
	cp -a libs/tkwidgets/highlight distrib/rekall/common/data

	echo Copying icons ...
	cp -a pics/icons distrib/rekall/common/data
	cp kbase/rekall.ico distrib/rekall

	echo Copying pictures ...
	cp -a pics/pics distrib/rekall/common/data
	cp kbase/rekall.png distrib/rekall/common/data

	echo Copying scripts ...
	cp script/python/stub/*.py distrib/rekall/common/data/script/py
	cp parts/table2/*.py distrib/rekall/common/data/script/py

	echo Copying components
	(
		sd=../../../distrib/rekall/common/data/stock/component/py

		cd script/python/components.std
		for d in `find * -type d`
		do
			mkdir $sd/$d
		done
		for c in `find * -type f -name '*.cmp'`
		do
			cp $c $sd/$c
		done
		touch	$sd/dummy
	)

	echo Copying license ...
	cp LICENSE distrib/rekall/common/data

	echo Copying python ...
	cp -a python/Python-2.2.0-Win distrib/rekall/python

	echo Odds and sods ...
	cp kbase/keymap distrib/rekall/common/data

	echo Removing CVS files ...
	find distrib/rekall -name CVS | xargs rm -rf
}



rekallPackage(){

	rm -f	data.z
	/cygdrive/c/Ishield4/PROGRAM/ICOMP.EXE 'distrib\rekall\*' data.z -i

	rm -rf	package/rekall
	mkdir	package/rekall

	(
		cd setup/rekall
		/cygdrive/c/Ishield4/PROGRAM/COMPILE.EXE setup.rul
	)

	(	cd setup/rekall
		/cygdrive/c/Ishield4/PROGRAM/PACKLIST.EXE setup.lst
	)

	/cygdrive/c/Ishield4/PROGRAM/SPLIT.EXE -f32000 data.z
	cp data.1   package/rekall
	cp setup/rekall/disk1.id  package/rekall
	cp setup/rekall/setup.ins package/rekall
	cp setup/rekall/setup.pkg package/rekall
	cp /cygdrive/c/Ishield4/PROGRAM/setup.exe	package/rekall
	cp /cygdrive/c/Ishield4/PROGRAM/UNINST.EXE	package/rekall
	cp /cygdrive/c/Ishield4/PROGRAM/_INST32I.EX_	package/rekall
	cp /cygdrive/c/Ishield4/PROGRAM/_SETUP.DLL	package/rekall
	cp /cygdrive/c/Ishield4/PROGRAM/_SETUP.LIB	package/rekall
	cp /cygdrive/c/Ishield4/PROGRAM/_ISDEL.EXE	package/rekall
}

odbcCopyData(){

	rm -rf	distrib/odbc
	mkdir	distrib/odbc
	mkdir	distrib/odbc/common
	mkdir	distrib/odbc/common/data
	mkdir	distrib/odbc/common/data/services

	for dll in	\
		kbase_driver_odbc.dll
	do
		echo Copying $dll ...
		cp common/lib/$dll distrib/odbc
	done

	echo Copying desktop files
	for db in odbc
	do
		cp db/$db/rekall_*.desktop distrib/odbc/common/data/services
	done

	echo Removing CVS files ...
	find distrib/odbc -name CVS | xargs rm -rf
}


odbcPackage(){

	rm -f	data.z
	/cygdrive/c/Ishield4/PROGRAM/ICOMP.EXE 'distrib\odbc\*' data.z -i

	rm -rf	package/odbc
	mkdir	package/odbc

	(
		cd setup/odbc
		/cygdrive/c/Ishield4/PROGRAM/COMPILE.EXE setup.rul
	)

	(	cd setup/odbc
		/cygdrive/c/Ishield4/PROGRAM/PACKLIST.EXE setup.lst
	)

	/cygdrive/c/Ishield4/PROGRAM/SPLIT.EXE -f32000 data.z
	cp data.1   package/odbc
	cp setup/odbc/disk1.id  package/odbc
	cp setup/odbc/setup.ins package/odbc
	cp setup/odbc/setup.pkg package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/setup.exe	package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/UNINST.EXE	package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/_INST32I.EX_	package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/_SETUP.DLL	package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/_SETUP.LIB	package/odbc
	cp /cygdrive/c/Ishield4/PROGRAM/_ISDEL.EXE	package/odbc
}

mkdir -p distrib
mkdir -p package

rekallCopyData
rekallPackage

odbcCopyData
odbcPackage

echo Done
