/***************************************************************************
    file	         : kb_componentviewer.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<qwidget.h>
#include	<qguardedptr.h>

#include	"tk_icons.h"
#include	"tk_messagebox.h"

#include	"kb_classes.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_gui.h"
#include	"kb_dbinfo.h"
#include	"kb_dblink.h"
#include	"kb_display.h"
#include	"kb_component.h"
#include	"kb_options.h"
#include	"kb_string.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_docroot.h"
#include	"kb_writer.h"
#include	"kb_viewer.h"

#ifndef 	_WIN32
#include	"kb_componentviewer.moc"
#else
#include 	"kb_componentviewer.h"
#endif

#include	"kb_objtreeviewer.h"



/*  KBComponentViewer							*/
/*  KBComponentViewer							*/
/*		: Constructor for component viewer object		*/
/*  KBObjBase	: QObject	   : Parent object			*/
/*  embed	: QWidget *	   : Embedding widget			*/
/*  pDict	: QDict<QString> & : Parameter dictionary		*/
/*  modal	: bool		   : View component modally		*/
/*  (returns)	: KBComponentViewer:					*/

KBComponentViewer::KBComponentViewer
	(	KBObjBase		*parent,
		QWidget			*embed,
		const QDict<QString>	&pDict,
		bool			modal
	)
	:
	KBViewer (parent, embed, WDestructiveClose|WStyle_NormalBorder, modal),
	KBPlayer ("componentviewer", "", m_partWidget),
	m_pDict	 (pDict)
{
	m_docRoot   = 0		;
	m_objTree   = 0		;

	m_designGUI = new KBaseGUI (this, this, "rekallui.form.design") ;
}

/*  KBComponentViewer							*/
/*  startup	: Startup component viewer object			*/
/*  _docRoot	: KBComponent *	: Component object			*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: KB::ShowRC	: Startup success			*/

KB::ShowRC
	KBComponentViewer::startup
	(	KBComponent	*_docRoot,
		KBError		&pError
	)
{
	KB::ShowRC	rc	;
	QSize		size	;
	KBaseGUI 	*gui	;

	m_docRoot = _docRoot	;

	/* Show the document, either in design or data view. If the	*/
	/* user cancels (which should never happen for design view)	*/
	/* then immediately return a false result.			*/
	gui = m_designGUI ;
	setGUI		  (gui) ;
	m_docRoot->setGUI (gui) ;
	rc	= m_docRoot->showDesign (m_partWidget, size) ;

	switch (rc)
	{
		case KB::ShowRCCancel :
			/* User cancelled, return this at once to the	*/
			/* caller.					*/
			return	KB::ShowRCCancel;

		case KB::ShowRCDesign :
			/* This is the expected result.			*/
			/* error, but anyways passes back as OK.	*/
			break	;

		default	:
			/* The only other case should be an error ...	*/
			pError	= m_docRoot->lastError() ;
			return	KB::ShowRCError	;
	}

	/* Note the top-most widget in the component itself and show	*/
	/* it, size the GUI building will have left it hidden.		*/
	m_topWidget = m_docRoot->getDisplay()->getTopWidget () ;
	m_topWidget ->show () ;


	/* the report (which depends on whether we are in data or	*/
	/* design mode); set the caption and icon, and show it.		*/
	setCaption (m_docRoot->getAttrVal("caption")) ;
	m_partWidget->resize	(size.width(), size.height(), true, false) ;
	m_partWidget->setIcon	(getSmallIcon ("component")) ;

	/* Finally show the part; it should be shown modally or not	*/
	/* depending on the initial modal setting.			*/
	m_partWidget->show   	(false, KB::ShowAuto) ;

	return	KB::ShowRCOK	;
}

/*  KBComponentViewer							*/
/*  ~KBComponentViewer							*/
/*		: Destructor for component viewer			*/
/*  (returns)	: void		:					*/

KBComponentViewer::~KBComponentViewer ()
{
	DELOBJ	(m_objTree) ;
}

/*  KBComponentViewer							*/
/*  showAs	: Show document in specified mode			*/
/*  _showAs	: KB::ShowAs	: Specified mode			*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::showAs
	(	KB::ShowAs	
	)
{
}

/*  KBComponentViewer							*/
/*  saveDocumentAs: Save document under specified name			*/
/*  (returns)	  : void	:					*/

void	KBComponentViewer::saveDocumentAs ()
{
	if (m_objBase->saveDocumentAs ())
	{	m_docRoot->isLayout()->setChanged (false) ;
		setCaption (m_docRoot->getAttrVal("caption")) ;
	}
}

/*  KBComponentViewer							*/
/*  saveDocument: Save document						*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::saveDocument ()
{
	if (m_objBase->saveDocument ())
	{	m_docRoot->isLayout ()->setChanged  (false) ;
		setCaption (m_docRoot->getAttrVal("caption")) ;
	}
}

/*  KBComponentViewer							*/
/*  queryClose	: Query whether to close				*/
/*  (returns)	: bool		: True to allow close			*/

bool	KBComponentViewer::queryClose ()
{
	cchar	*cmsg	;

	if ((cmsg = getChanged (true)) != 0)
		if (TKMessageBox::questionYesNo
			(	0,
				QString(TR("Component %1 changed: close anyway?")).arg(cmsg)
			)	!= TKMessageBox::Yes
		   )	return	false	;

	return	true	;
}

/*  KBComponentViewer							*/
/*  doCtrlAlign	: Handle control alignment request			*/
/*  align	: int		: Aligment operation			*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::doCtrlAlign
	(	int	align
	)
{
	m_docRoot->doCtrlAlign ((KB::CtrlAlign)align) ;
}

/*  KBComponentViewer							*/
/*  showObjTree	: Toggle the object tree for the component		*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::showObjTree ()
{
	if (m_objTree == 0)
	{
		m_objTree = new KBObjTreeViewer
			    	(	m_objBase,
					m_embed,
					getLocation(),
					m_docRoot,
					m_docRoot
				)	;

		connect
		(	m_objTree, SIGNAL(destroyed	   ()),
			this,	   SLOT  (objTreeViewerDead())
		)	;

		m_designGUI->setChecked ("KB_showObjTree", true) ;
	}
	else
	{	DELOBJ	 (m_objTree) ;
		objTreeViewerDead () ;
	}
}

/*  KBComponentViewer							*/
/*  doMultiProp	: Invoke multiple-object properties dialog		*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::doMultiProp ()
{
	if (m_docRoot) m_docRoot->KBLayout::doMultiProp () ;
}

/*  KBComponentViewer							*/
/*  doProperties: Invoke object properties dialog			*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::doProperties ()
{
	if (m_docRoot) m_docRoot->KBLayout::doSingleProp () ;
}


/*  KBComponentViewer							*/
/*  objTreeViewerDead							*/
/*		: Note death of object tree display			*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::objTreeViewerDead ()
{
	m_objTree	= 0 ;
	m_designGUI->setChecked ("KB_showObjTree", false) ;
}

/*  KBComponentViewer							*/
/*  doCut	: Handle cut request					*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::doCut ()
{
	m_docRoot->doCut () ;
}

/*  KBComponentViewer							*/
/*  doCopy	: Handle copy request					*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::doCopy ()
{
	m_docRoot->doCopy () ;
}

/*  KBComponentViewer							*/
/*  doSaveComponent							*/
/*		: Handle request to save objects as component		*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::doSaveComponent ()
{
	m_docRoot->doSaveComponent (getLocation()) ;
}

/*  KBComponentViewer							*/
/*  doPaste	: Handle patse request					*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::doPaste ()
{
	m_docRoot->doPaste () ;
}

/*  KBComponentViewer							*/
/*  getChanged	: Report whether there are unsaved changes		*/
/*  both	: bool		: True for both data and design change	*/
/*  (returns)	: cchar *	: Changed message or null if none	*/

cchar	*KBComponentViewer::getChanged
	(	bool	both
	)
{
	return	m_docRoot->getChanged (both) ;
}

/*  KBComponentViewer							*/
/*  snapToGrid	: Snap selected controls to the grid			*/
/*  (returns)	: void		:					*/

void	KBComponentViewer::snapToGrid ()
{
	m_docRoot->snapToGrid () ;
}


bool	KBComponentViewer::playerPerform
	(	const QString		&action,
		const QStringList	&args,
		KBError			&pError
	)
{
	if (action == "close")
	{
		slotClose ()	;
		return	true	;
	}

	if (action == "save")
	{
		saveDocument () ;
		return	true	;
	}

	return	KBPlayer::playerPerform (action, args, pError) ;
}

QString	KBComponentViewer::playerName ()
{
	return	m_docRoot ? m_docRoot->getName() : QString("UnnamedComponent") ;
}

