/***************************************************************************
    file	         : kb_copier.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>

#include	<qfont.h>
#include	<qfile.h>
#include	<qtextstream.h>

#include	"kb_param.h"
#include	"kb_paramdlg.h"

#ifndef		_WIN32
#include	"kb_copier.moc"
#else
#include	"kb_copier.h"
#endif

#include	"tk_icons.h"
#include	"tk_config.h"

static	GUIElement copierGUI[] =
{
//	GType		GGroup		Enable	Text			Icon		Accelerator	Slot			  Element name		Code		Tool Tip
{	GTAction,	KB::GRNone,	true,	"&Execute copy",	"execcopy",	ACCEL(NoAccel),	SLOT(execute          ()),"KB_execCopy",	0,		"Execute copy"			},
{	GTAction,	KB::GRNone,	true,	"Parameters",		"options",	ACCEL(NoAccel),	SLOT(setParameters    ()),"KB_paramaters",	0,		"Set parameters"		},
{	GTToggle,	KB::GRNone,	true,	"Show source",		"copyfrom",	ACCEL(NoAccel),	SLOT(showSource       ()),"KB_showSrce",	0,		"Show source"			},
{	GTToggle,	KB::GRNone,	true,	"Show destiantion",	"copyto",	ACCEL(NoAccel),	SLOT(showDestination  ()),"KB_showDest",	0,		"Show destination"		},
{	GTNone,		KB::GRNone,	false,	0,			0,		ACCEL(NoAccel),	0,			  0,		 	0,		0				}
}	;

/*  KBCopier	: 							*/
/*  KBCopier	: Constructor for data copier				*/
/*  parent	: KBObjBase *	: Parent object				*/
/*  embed	: QWidget *	: Embedding widget			*/
/*  (returns)	: KBCopier	:					*/

KBCopier::KBCopier
	(	KBObjBase	*parent,
		QWidget		*embed
	)
	:
	KBViewer    (parent, embed, WDestructiveClose|WStyle_NormalBorder),
#if	__KB_EMBEDDED
	m_mainWidget(new QWidgetStack (m_partWidget)),
#else
	m_mainWidget(new QSplitter    (m_partWidget)),
#endif
	m_srce	    (new KBCopyWidget (m_mainWidget, this, true,  getLocation())),
	m_dest	    (new KBCopyWidget (m_mainWidget, this, false, getLocation()))
{
#if	__KB_EMBEDDED
	m_mainWidget->addWidget   (m_srce, 0) ;
	m_mainWidget->addWidget   (m_dest, 1) ;
#endif
	m_gui	    = 0	 ;
	m_params.setAutoDelete (true)	;
	setLocalGUISpec	(&copierGUI[0]) ;

	TKConfig *config = TKConfig::getConfig() ;
	config->setGroup ("Copier Options") ;
	m_size	 = config->readSizeEntry ("Geometry" ) ;

	if (m_size.isEmpty())
		m_size = 	  QSize (500, 400)  ;
	else	m_size.boundedTo (QSize (300, 200)) ;

	m_topWidget = m_mainWidget	;

	QSize	minSize	= m_mainWidget->minimumSizeHint() ;
	int	w	= minSize  .width () ;
	int	h	= minSize  .height() + m_srce->tabHeight() ;

	m_partWidget->setMinimumSize (w, h) ;
	m_partWidget->setIcon(getSmallIcon("copier")) ;

	setGUI (m_gui = new KBaseGUI (this, this, "rekallui.copier")) ;

	showSource () ;
	m_partWidget->show   () ;
}

/*  KBCopier	: 							*/
/*  ~KBCopier	: Destructor for simple script editor			*/
/*  (returns)	:		:					*/

KBCopier::~KBCopier ()
{
	TKConfig *config = TKConfig::getConfig() ;

	config->setGroup   ("Copier Options"  ) ;
	config->writeEntry ("Geometry", m_size) ;
	config->sync	   () ;
}

/*  KBCopier								*/
/*  startup	: Startup editor					*/
/*  _doc	: QByteArray &	: Document definition			*/
/*  _showAs	: KB::ShowAs	: Display mode				*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: KB::ShowRC	: Success				*/

KB::ShowRC
	KBCopier::startup
	(	QByteArray	&_doc,
		KB::ShowAs	_showAs,
		KBError		&pError
	)
{
	setCaption (getLocation().title()) ;

	if (_doc.isEmpty())
		return KB::ShowRCOK ;

	QDomDocument	doc	;
	doc.setContent	(_doc)	;

	/* Get and check that there is a root element, then set the	*/
	/* source and the display. If the former fails, then return at	*/
	/* once, but otherwise do both of the latter, keeping a look	*/
	/* out for errors.						*/
	QDomElement	root	= doc.documentElement () ;
	if (root.isNull())
	{
		KBError::EError
		(	TR("Copier document has no root element"),
			QString::null,
			__ERRLOCN
		)	;
		m_partWidget->show ();
		return	KB::ShowRCOK ;
	}

	if (!m_srce->set (root, pError))
	{
		pError.DISPLAY ()  ;
		_showAs = KB::ShowAsDesign ;
	}

	if (!m_dest->set (root, pError))
	{
		pError.DISPLAY ()  ;
		_showAs = KB::ShowAsDesign ;
	}

	for (QDomNode pnode = root.firstChild() ; !pnode.isNull() ; pnode = pnode.nextSibling())
	{
		QDomElement pelem = pnode.toElement() ;
		if (pelem.isNull() || (pelem.tagName() != "param"))
			continue ;

		m_params.insert
		(	pelem.attribute ("name"),
			new KBParamSet
			(	pelem.attribute ("legend"),
				pelem.attribute ("defval"),
				QString::null,
				QString::null,
				false
		)	)	;
	}

	/* If the request is to show as data (and no errors have	*/
	/* occurred) then execute the copied. If this is OK then return	*/
	/* as if the user cancelled - they will see the records-copied	*/
	/* message, but nothing else.					*/
	if (_showAs == KB::ShowAsData)
		if (execute ()) return KB::ShowRCCancel ;


	/* Either show design or an error occurred ...			*/
	m_partWidget->show() ;
	return	KB::ShowRCOK ;
}

/*  KBCopier	 : 							*/
/*  setParamaters: Set copier parameters				*/
/*  (returns)	 : void		:					*/

void	KBCopier::setParameters ()
{
	KBParamDesignDlg pDlg (m_params) ;
	if (pDlg.exec()) pDlg.getValues (m_params) ;
}

/*  KBCopier	: 							*/
/*  saveDocument: Handle file save					*/
/*  (returns)	: void		:					*/

void	KBCopier::saveDocument ()
{
	KBError	error	;

	if (!m_srce->valid (error))
	{	error.DISPLAY () ;
		return	;
	}
	if (!m_dest->valid (error))
	{	error.DISPLAY () ;
		return	;
	}

	if (m_objBase->saveDocument())
	{	
		m_gui->setEnabled ("KB_saveDoc", false) ;
		setCaption (getLocation().title()) ;
	}
}

/*  KBCopier	   : 							*/
/*  saveDocumentAs : Handle file save-as				*/
/*  (returns)	   : void	:					*/

void	KBCopier::saveDocumentAs ()
{
	KBError	error	;

	if (!m_srce->valid (error))
	{	error.DISPLAY () ;
		return	;
	}
	if (!m_dest->valid (error))
	{	error.DISPLAY () ;
		return	;
	}

	if (m_objBase->saveDocumentAs())
	{	
		m_gui->setEnabled ("KB_saveDoc", false) ;
		setCaption (getLocation().title()) ;
	}
}

/*  KBCopier								*/
/*  execute	: Execute copy						*/
/*  (returns)	: bool		: Success				*/

bool	KBCopier::execute ()
{
	KBError	error	;

	if (!m_srce->valid (error))
	{	error.DISPLAY () ;
		return	false	 ;
	}
	if (!m_dest->valid (error))
	{	error.DISPLAY () ;
		return	false	 ;
	}

	KBCopyExec copyExec (m_srce->getCopier(), m_dest->getCopier()) ;

	QDict<QString>	dummy	 ;
	QString	   	report   ;
	int	   	nRows    ;

	if (!copyExec.execute (report, error, nRows, dummy, m_params))
	{	error.DISPLAY() ;
		return false	;
	}

	KBError::EWarning
	(	TR("Copy completed"),
		report,
		__ERRLOCN
	)	;

	return	true	;
}

/*  KBCopier								*/
/*  def		: Get document definition				*/
/*  (returns)	: QString	: Definition				*/

QString	KBCopier::def ()
{
	QDomDocument	cXML	("copier") ;
	QDomElement	root	;
	KBError		error	;

	cXML.appendChild
	(	cXML.createProcessingInstruction
		(	"xml",
			"version=\"1.0\" encoding=\"UTF-8\""
	)	)	;

	cXML.appendChild (root = cXML.createElement ("copier")) ;

	m_srce->def (root) ;
	m_dest->def (root) ;

	QDictIterator<KBParamSet> iter (m_params) ;
	KBParamSet		  *pSet	;

	while ((pSet = iter.current()) != 0)
	{
		QDomElement param = cXML.createElement ("param") ;
		root.appendChild (param) ;

		param.setAttribute ("name",   iter.currentKey()) ;
		param.setAttribute ("legend", pSet->m_legend   ) ;
		param.setAttribute ("defval", pSet->m_defval   ) ;

		iter	+= 1 ;
	}

	return	cXML.toString() ;
}

bool	KBCopier::queryClose ()
{
	return	true	;
}

/*  KBCopier								*/
/*  setChanged	: Note change has happened				*/
/*  (returns)	: void		:					*/

void	KBCopier::setChanged ()
{
	m_gui->setEnabled ("KB_saveDoc", true) ;
}

/*  KBCopier								*/
/*  showAs	: Show copied in specified mode				*/
/*  _showAs	: KB::ShowAs	: Required mode				*/
/*  (returns)	: void		:					*/

void	KBCopier::showAs
	(	KB::ShowAs	_showAs
	)
{
	/* We are only interested in this is "show data" is requested,	*/
	/* wnich we just interpret as a request to execute the copier.	*/
	if (_showAs == KB::ShowAsData) execute () ;
}

void	KBCopier::showSource ()
{
#if	__KB_EMBEDDED
	m_mainWidget->raiseWidget (m_srce) ;
	m_gui->setChecked ("KB_showSrce", true ) ;
	m_gui->setChecked ("KB_showDest", false) ;
#endif
}

void	KBCopier::showDestination ()
{
#if	__KB_EMBEDDED
	m_mainWidget->raiseWidget (m_dest) ;
	m_gui->setChecked ("KB_showSrce", false) ;
	m_gui->setChecked ("KB_showDest", true ) ;
#endif
}
