/***************************************************************************
    file	         : kb_queryform.cpp
    copyright            : (C) 1999,2000,2001,2002,2003 by Mike Richardson
			   (C) 2000,2001,2002,2003 by theKompany.com
			   (C) 2001,2002,2003 by John Dean
    license              : This file is released under the terms of
                           the GNU General Public License, version 2. The
                           copyright holders retain the right to release
                           this code under diffenent non-exclusive licences.
    email                : mike@quaking.demon.co.uk                                     
 ***************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<stdarg.h>

#ifndef _WIN32
#include	<unistd.h>
#endif

#include	<qstring.h>
#include	<qlist.h>

#include	"kb_classes.h"
#include	"kb_location.h"
#include	"kb_type.h"
#include	"kb_value.h"
#include	"kb_database.h"
#include	"kb_node.h"
#include	"kb_query.h"
#include	"kb_table.h"
#include	"kb_qryexpr.h"

#include	"kb_designinfo.h"
#include	"kb_dblink.h"
#include	"kb_nodereg.h"
#include	"kb_parse.h"
#include	"kb_attrdict.h"

static	PSet	blkPSet[] =
{
	{	"dx",		"0"		},
	{	"dy",		"20"		},
	{	"autosync",	"Yes"		},
	{	"showbar",	"Yes"		},
	{	"stretch",	"Yes"		},
	{	0,		0		}
}	;

static	PSet	grdPSet[] =
{
	{	"x",		"40"		},
	{	"y",		"0"		},
	{	"h",		"20"		},
	{	"name",		"$$grid$$"	},
	{	0,		0		}
}	;

static	PSet	rowPSet[] =
{
	{	"x",		"0"		},
	{	"y",		"20"		},
	{	"w",		"40"		},
	{	"h",		"20"		},
	{	"showrow",	"Yes"		},
	{	0,		0		}
}	;

static	PSet	fldPSet[] =
{
	{	"y",		"20"		},
	{	"w",		"100"		},
	{	"h",		"20"		},
	{	"morph",	"Yes"		},
	{	0,		0		}
}	;

typedef	QDict<KBDesignInfo>	KBDesignMap	;	
static	QDict<KBDesignMap >	designDict   	;


/*  findDesign	: Find design entry for table and column		*/
/*  dbLink	: KBDBLink &	  : Database link			*/
/*  name	: const QString & : Table and field name		*/
/*  (returns)	: KBDesignInfo *  : Design information or null		*/

static	KBDesignInfo *findDesign
	(	KBDBLink	&dbLink,
		const QString	&name
	)
{
	extern	 bool	GetKBDesignEntries
			(	const QString		&,
				QDict<KBDesignInfo>	&,
				KBDBLink		&,
				KBError			&
			)	;

	int		dotp	= name.find ('.'   ) ;
	QString		table	= name.left (dotp  ) ;
	QString		field	= name.mid  (dotp+1) ;
	KBDesignMap	*ti	;
	KBError		error	;

//	fprintf	(stderr, "findDesign [%s][%s]\n", (cchar *)table, (cchar *)field) ;

	if ((ti = designDict.find (table)) == 0)
	{
//		fprintf	(stderr, "findDesign get entries\n") ;
		ti = new KBDesignMap ;
		if (!GetKBDesignEntries (table, *ti, dbLink, error))
			fprintf	(stderr, "GetKBEntries failed\n") ;
		designDict.insert (table, ti) ;
	}

	return	ti->find (field) ;
}

/*  addColumn	: Generate text for a column in the query display form	*/
/*  expr	: const QString & : Column expression			*/
/*  title	: const QString & : Column title			*/
/*  colno	: uint		  : Output column number		*/
/*  linkage	: const QDict<void> &					*/
/*				  : Linkage fields			*/	
/*  nn		: bool		  : Column is not-null			*/
/*  evalid	: const QString & : Validation expression		*/
/*  format	: const QString & : Display format			*/
/*  (returns)	: QString	  : Text for field and header		*/

static	QString	addColumn
	(	const QString		&expr,
		const QString		&title,
		uint			colno,
		const QDict<void>	&linkage,
		bool			nn,
		const QString		&evalid,
		const QString		&format
	)
{
	KBAttrDict	fldAList (fldPSet) ;
	bool		link	 = linkage.find (expr) != 0 ;

	fldAList.addValue ("x",	 	colno * 100 + 25) ;
	fldAList.addValue ("taborder",	colno + 1	) ;
	fldAList.addValue ("expr", 	expr	        ) ;
	fldAList.addValue ("name", 	title	        ) ;

	fldAList.addValue ("nullok",	nn   ? "No"       : "Yes") ;
	fldAList.addValue ("rdonly",	link ? "Yes"      : "No" ) ;
	fldAList.addValue ("bgcolor",	link ? "0xe0e0e0" : ""   ) ;

	fldAList.addValue ("evalid",	evalid) ;
	fldAList.addValue ("format",	format) ;

	return	fldAList.print ("KBField", true) ;
}

/*  addFields	: Add fields for a query table level			*/
/*  table	: KBTable *	: Top-most table in level		*/
/*  dbLink	: KBDBLink &	: Database link				*/
/*  colno	: uint		: Output column number			*/
/*  linkage	: const QDict<void> &					*/
/*				: Linkage fields			*/	
/*  text	: QString &	: Form text				*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: bool		: Success				*/

static	bool	addFields
	(	KBTable			*table,
		KBDBLink		&dbLink,
		uint			&colno,
		const QDict<void>	&linkage,
		QString			&text,
		KBError			&pError
	)
{
	QList<KBFieldSpec> fList;
	if (!table->getFieldList(fList, dbLink, true))
	{	pError	= table->lastError() ;
		return	false	;
	}

	for (uint idx = 0 ; idx < fList.count() ; idx += 1)
	{
		KBFieldSpec	*fSpec	 = fList.at   (idx) ;
		KBDesignInfo	*di	 = findDesign (dbLink, fSpec->m_name) ;

		text	+= addColumn
			   (	fSpec->m_name,
				fSpec->m_name,
				colno,
				linkage,
				(fSpec->m_flags & KBFieldSpec::NotNull) != 0,
				di == 0 ? QString::null : di->getField(DI_EVALID)->getRawText(),
				di == 0 ? QString::null : di->getField(DI_FORMAT)->getRawText()
			   )	;
		colno	+= 1	;
	}

	return	true	;
}

/*  KBOpenQuery	: Generate and open form for specified query		*/
/*  location	: KBLocation &	: Document location			*/
/*  qryRoot	: KBQuery *	: Query object				*/
/*  pError	: KBError &	: Error return				*/
/*  (returns)	: KBForm *	: Query-specific form			*/

KBForm	*KBOpenQuery
	(	KBLocation	&location,
		KBQuery		*qryRoot,
		KBError		&pError
	)
{
	KBDBLink 		dbLink	;
	QString			text	;
	QString			svrName	;
	QList<KBTable>		qryList	;
	QList<KBTable>		tabList	;
	QList<KBQryExpr>	exprList;
	QDict<void>		linkage	;

	designDict.setAutoDelete (true) ;
	designDict.clear () ;

	qryRoot->getQueryInfo (svrName, qryList, exprList) ;
	if (!KBTable::blockUp (qryList, QString::null, tabList, pError))
		return	0 ;

	if (!dbLink.connect (location, svrName))
	{	pError	= dbLink.lastError () ;
		return	0 ;
	}

	/* We make the columns that are used to link tables together	*/
	/* read-only, so that we cannot have situations where a user	*/
	/* update can change row linkage.				*/
	for (uint idx1 = 0 ; idx1 < tabList.count() ; idx1 += 1)
		TITER
		(	Table,
			tabList.at(idx1)->getChildren(),
			table,

			QStringList jbits = QStringList::split (" = ", table->getJExpr()) ;
			if (jbits.count() == 2)
			{	linkage.insert (jbits[0], (void *)1) ;
				linkage.insert (jbits[1], (void *)1) ;
			}
		)


	uint	maxf	= 0 ;
	for (uint idx2 = 0 ; idx2 < tabList.count() ; idx2 += 1)
	{	QList<KBFieldSpec> fList;
		if (!tabList.at(idx2)->getFieldList(fList, dbLink, true))
		{	pError	= qryList.at(idx2)->lastError() ;
			return	0	;
		}
		if (fList.count() > maxf) maxf = fList.count() ;
	}	

	KBAttrDict frmAList(blkPSet) ;
	frmAList.addValue  ("w", maxf * 100 + 50) ;
	frmAList.addValue  ("h", qryList.count() * 40 + 300) ;
	frmAList.addValue  ("rowcount", tabList.count() == 1 ? 0 : 1) ;
	text	+= frmAList.print ("KBForm") ;

	KBAttrDict qryAList(0)	;
	qryAList.addValue  ("query",    location.docName) ;
	qryAList.addValue  ("toptable", "") ;
	text	+= qryAList.print ("KBQryQuery", true) ;


	KBAttrDict rowAList       (rowPSet)  ;
	text	+= rowAList.print ("KBRowMark", true) ;

	uint	anyExpr	= 0 ;

	LITER
	(	KBQryExpr,
		exprList,
		expr,

		if (expr->getUsage() == KBQryExpr::AsExprOnly)
		{
			if (expr->getExpr() == "*")
			{
				if (!addFields (tabList.at(0), dbLink, anyExpr, linkage, text, pError))
					return	0 ;
				continue ;
			}

			QString	column	= expr->getExpr () ;
			QString	title	= expr->getAlias() ;

			if (title.isEmpty()) title = column ;

			text	+= addColumn
				   (	column,
					title,
					anyExpr,
				   	linkage,
				   	false,
				   	QString::null,
				   	QString::null
				   )	;
			anyExpr	+= 1 	;
		}
	)

	if (anyExpr == 0)
		if (!addFields (tabList.at(0), dbLink, anyExpr, linkage, text, pError))
			return	0 ;

	KBAttrDict grdAList (grdPSet)	;
	grdAList.addValue ("w", anyExpr * 100 ) ;
	text	+= grdAList.print ("KBGrid", true) ;

	/* The query blocking should mean that there is only a single	*/
	/* table in the table list, and the next two loops should never	*/
	/* execute, but leave the code in case we ever get it wrong (or	*/
	/* we provide an option to select the top table).		*/
	for (uint idx3 = 1 ; idx3 < tabList.count() ; idx3 += 1)
	{
		KBAttrDict blkAList (blkPSet) ;
		blkAList.addValue ("w", maxf * 100 + 50) ;
		blkAList.addValue ("h", 350  - 40 * idx3) ;
		blkAList.addValue ("y", 40)		 ;
		blkAList.addValue ("rowcount", idx3 == tabList.count() - 1 ? 0 : 1) ;
		text	+= blkAList.print ("KBFormSubBlock") ;

		uint	colno	= 0 ;
		if (!addFields (tabList.at(idx3), dbLink, colno, linkage, text, pError))
			return	0 ;
	}

	for (uint idx4 = 1 ; idx4 < tabList.count() ; idx4 += 1)
		text	+= "</KBFormSubBlock>" ;
	text	+= "</KBForm>"	;

	QByteArray f ;
	f.duplicate (text, strlen(text)) ;
	return	KBOpenFormText (location, f, pError) ;
}
